/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3BZQ
 */

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var effect:ParticleEffect;
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
            addChild(new Stats());            
        }
        
        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            var label:Label = new Label(200, 40, 40, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 202;
            label.alpha = 0.4;
            label.textColor = 0xffffff;
            label.text = "wonderfl";
            
            var area:Rectangle = new Rectangle(-200, -20, 400, 40);
            effect = new ParticleEffect(area);
            addChild(effect);
            effect.x = 232;
            effect.y = 232;
            effect.start(12, 200);
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.geom.Rectangle;

class ParticleEffect extends Sprite {
    private var area:Rectangle;
    private var particles:Array;
    private var id:uint = 0;
    private var timer:Timer;
    private static var unit:uint = 10;
    private static var interval:uint = 200;
    
    public function ParticleEffect(a:Rectangle) {
        area = a;
        init();
    }
    
    private function init():void {
        particles = new Array();
    }
    
    public function start(u:uint, i:uint = 200):void {
        unit = u;
        interval = i;
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, create, false, 0, true);
        timer.start();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);      
    }
    public function stop():void {
        timer.stop();
    }
    private function create(evt:TimerEvent):void {
        var position:int = 0;
        var distance:uint = 0;
        for(var n:uint = 0; n < unit; n++) {
            var particle:Particle = new Particle();
            addChild(particle);
            particle.id = id;
            if(id < area.height) {
                position = area.x + (area.width / area.height)*id;
                distance = area.height;
            } else {
                position = 0;
                distance = area.width;
            }
            particle.x = position + distance*(Math.random() - 0.5);
            particle.y = area.height * (Math.random() - 0.5);
            particle.scale = 0.4 + 0.6 * Math.random();
            particle.dx = 2 * (Math.random() - 0.5);
            particle.dy = 4 * (Math.random() - 0.5);
            particles.push(particle);
            id++;
        }
    }
    private function update(evt:Event):void {
        for(var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            if(particle) {
                particle.update();
                if(particle.life < 0) {
                    if(contains(particle)) removeChild(particle);
                    particles.splice(0, 1);
                    particle = null;
                }
            }
        }
    }
}

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.display.BlendMode;

class Particle extends Sprite {
    public var id:uint;
    private static var radius:uint = 5;
    private static var bColor:uint = 0xffffff;
    public var dx:Number = 0;
    public var dy:Number = 0;
    private static var acceleration:Number = 1.05;
    public var life:Number = 1;
    private static var deceleration:Number = 0.02;
    private var _scale:Number = 1;
    
    public function Particle() {
        draw();
    }
    
    private function draw():void {
        var colors:Array = [bColor, bColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        blendMode = BlendMode.LAYER;
        alpha = 0;
    }
    public function update():void {
        x += dx*acceleration;
        y += dy*acceleration;
        life -= deceleration;
        alpha = (1-life<0.5) ? (1-life)*2:life*2;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;
    
    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }
    
    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }




}


