/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3BEa
 */

// forked from curvedstraightline's 読み込んだ画像をビットマップにドローできん・・・
/*
読み込んだ画像をビットマップにドローできません・・・
ローカルではできてたんだけどなぁ・・・

http://wonderfl.net 以下ではセキュリティー上の問題でcrossdomain許可していません
画像のアップローダーを使うとhttp://assets.wonderfl.net/ に
アップされますので(こちらのドメインは許可)そちらのリンクをお使いください。
(crossdomainの危険性についての分かりやすい解説についてはこちらをご覧ください
http://tail.s68.xrea.com/blog/2008/03/crossdomainxml.html )


少々分かりにくいですが、
コードのページの左下の画像をクリックしますと、
アップロードされた画像がポップアップで表示されますので、
右クリックで画像のurlをコピーしてください！

http://assets.wonderfl.net/images/related_images/5/5f/5f57/5f5798c2740d05774babc5eaecc10f7d19e3cb18
*/
package 
{
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.StageQuality;
    import flash.net.URLRequest;
    import flash.net.*;
    
    /**
     * ...
     * @author curved straight line
     */
    [SWF(backgroundColor=0x000000)]
    public class Main extends Sprite 
    {
        private const CANVAS_WIDTH:int = stage.stageWidth;
        private const CANVAS_HEIGHT:int = stage.stageHeight;
        private const CANVAS_COLOR:uint = 0x000000;
        private var obj_bmd:BitmapData;
        private var obj_bm:Bitmap;
        private var canvas_bmd:BitmapData;
        private var canvas:Bitmap;
        private var c:Shape;
        private var map:BitmapData = new BitmapData(CANVAS_WIDTH, CANVAS_HEIGHT);
        private var ld:Loader        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.quality = StageQuality.LOW;
            loadObject();
        }
        
        private function loadObject():void
        {
            ld = new Loader();
            ld.load(
//            new URLRequest("http://wonderfl.net/static/tmp/related_images/5f5798c2740d05774babc5eaecc10f7d19e3cb18m"),
            new URLRequest("http://assets.wonderfl.net/images/related_images/5/5f/5f57/5f5798c2740d05774babc5eaecc10f7d19e3cb18"),
            new LoaderContext(true)
            );
            ld.contentLoaderInfo.addEventListener(Event.COMPLETE, drawObject);
        }
        
        private function drawObject(e:Event=null):void
        {
            //addChild(ld);
            //trace("yes");
            canvas_bmd = new BitmapData(466, 466);
            canvas_bmd.draw(ld);
            canvas = new Bitmap(canvas_bmd);
            addChild(canvas);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private var v:Number = 0;
        private function loop(e:Event=null):void
        {
            removeChild(canvas);
            canvas_bmd = new BitmapData(ld.width, ld.height);
            canvas_bmd.lock();
            canvas_bmd.draw(ld);
            canvas = new Bitmap(canvas_bmd);
            addChild(canvas);
            map.perlinNoise
            (
                map.width,
                map.height, 
                1, 
                6, 
                false,
                true,
                BitmapDataChannel.RED | BitmapDataChannel.GREEN,
                false,
                [new Point(v,v), new Point(v,v)]
            );
            
            var displace:DisplacementMapFilter = new DisplacementMapFilter
            (
                map, 
                new Point(0,0), 
                1,//BitmapDataChannel.RED,
                1,//BitmapDataChannel.GREEN, 
                (CANVAS_WIDTH/2 - mouseX)*2,//Math.floor(Math.random() * 400), 
                (CANVAS_HEIGHT/2 - mouseY)*2//Math.floor(Math.random() * 300)
            );
            v += 12;
            canvas_bmd.applyFilter(canvas_bmd, canvas_bmd.rect, new Point(0, 0), displace);
            canvas_bmd.unlock();
        }
    }
    
}