/**
 * Copyright whirlpower ( http://wonderfl.net/user/whirlpower )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Ayg
 */

// forked from whirlpower's Shape DotFonts + ひらがな + カタカナ
// ひらがな　カタカナ　も　いれました
package 
{
    import flash.display.*;
    
    [SWF (backgroundColor = "0x000000", width = "465", height = "465", frameRate = "30")]
    public class Main extends Sprite 
    {
        public function Main():void 
        {
            var　textArea　:　ShapeDotFont = new ShapeDotFont( new DotFont().fonts, 200, 100 );
            addChild( textArea );
            
            textArea.scaleX = 2;
            textArea.scaleY = 2;
            textArea.x = 145;
            textArea.y = 200;
            textArea.color = 0xFFFFFF;
            textArea.lineHeight = 16;
            textArea.delay = 4;
            textArea.ignoreSpace = true;
            
            textArea.add( "おはよう　ございます。" );
            textArea.add( "ゆうべは　おたのしみでしたね。" );
        }
    }
}

    import flash.display.*;
    import flash.utils.Dictionary;
    import flash.events.*;    
    
    internal class ShapeDotFont extends Shape
    {
        private var fonts    :Dictionary;
        private var texts    :Array = [];
        
        public var margin : int = 1;
        public var lineHeight : int = 16;
        public var ignoreSpace : Boolean = true;
        public var delay : int = 0;
        public var color : int = 0xFFFFFF;
        
        private var _width : int;
        private var _height : int;
        
        public function ShapeDotFont( fonts:Dictionary, _width:int, _height:int ):void
        {
            this.fonts = fonts;
            this._width = _width;
            this._height = _height;
        }
         
        public function add( text:String ):void
        {
            var leng:int = text.length;
            for (var i:int = 0; i < leng; i++) 
            {
                var c:String = text.charAt( i );
                texts.push( c );
            }
            texts.push( "return" );
            
            if ( delay <= 0 )
                allDraw();
            else
                addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function allDraw():void
        {
            var leng:int = texts.length-1;
            for ( head; head < leng; head++ )
            {
                drawFont( texts[ head ] );
            }
        }
        
        private var count : int = 0;
        private var head : int = 0;
        private var activeX : int = 0;
        private var activeY : int = 0;
        
        private function loop(e:Event):void 
        {
            count++;
            if ( count >= delay )
            {
                count = 0;
                do{
                    var c:String = texts[ head ]
                    drawFont( c );
                    head++;
                    if ( head >= texts.length-1 )
                    {
                        removeEventListener( Event.ENTER_FRAME, loop );
                        return;
                    }
                }
                while ( c == " " && ignoreSpace );
            }
        }
        
        private function drawFont( c:String ):void
        {
            var font    :FontData = fonts[ c ];
            if ( !font || font.width == 0 ) font = fonts[ "ng" ];
            
            switch( font.char )
            {
                case "return":
                    activeX = 0;
                    activeY += lineHeight;
                    return;
                    
                case "tab":
                    activeX = 16;
                    return;
            }
            
            var data : String = font.data;
            var width : int = font.width;
            var length : int = data.length;
            var xx:int = 0, yy:int = 1;
            var posX:int, posY:int;
            
            if ( activeX + width > _width )
            {
                activeX = 0;
                activeY += lineHeight;
            }
            
            for( var i:int = 0; i < length; i++ )
            {
                if ( data.charAt(i) == "1" )
                {
                    posX = activeX + xx;
                    posY = activeY + yy;
                    
                    graphics.beginFill( color, 1 );
                    graphics.drawRect( posX, posY, 1, 1 );
                    graphics.endFill();
                }
                xx++;
                if ( xx >= font.boxWidth )
                {
                    xx = 0;
                    yy++;
                }
            }
            activeX    += width + margin;
        }
    }
    
    internal class FontData
    {
        public var char : String;
        public var width : int = 1;
        public var data : String;
        public var boxWidth : int = 0;
        public var boxHeight : int = 0;
        public var baseline : int = 12;
        
        public function FontData( char:String ):void
        {
            this.char = char;
        }
    }
    
    internal class DotFont
    {
        public var fonts : Dictionary = new Dictionary();
        
        public function DotFont():void
        {
            fonts[ "A" ]    = getFont( "A",7,8,16,12,"000000000000000000000000000000000000000000111000011011001100011011000110111111101100011011000110000000000000000000000000");
            fonts[ "B" ]    = getFont( "B",7,8,16,12,"000000000000000000000000000000000000000011111100110001101100011011111100110001101100011011111100000000000000000000000000");
            fonts[ "C" ]    = getFont( "C",7,8,16,12,"000000000000000000000000000000000000000000111100011001101100000011000000110000000110011000111100000000000000000000000000");
            fonts[ "D" ]    = getFont( "D",7,8,16,12,"000000000000000000000000000000000000000011111000110011001100011011000110110001101100110011111000000000000000000000000000");
            fonts[ "E" ]    = getFont( "E",7,8,16,12,"000000000000000000000000000000000000000001111110011000000110000001111100011000000110000001111110000000000000000000000000");
            fonts[ "F" ]    = getFont( "F",7,8,16,12,"000000000000000000000000000000000000000011111110110000001100000011111100110000001100000011000000000000000000000000000000");
            fonts[ "G" ]    = getFont( "G",7,8,16,12,"000000000000000000000000000000000000000000111110011000001100000011001110110001100110011000111110000000000000000000000000");
            fonts[ "H" ]    = getFont( "H",7,8,16,12,"000000000000000000000000000000000000000011000110110001101100011011111110110001101100011011000110000000000000000000000000");
            fonts[ "I" ]    = getFont( "I",7,8,16,12,"000000000000000000000000000000000000000001111110000110000001100000011000000110000001100001111110000000000000000000000000");
            fonts[ "J" ]    = getFont( "J",7,8,16,12,"000000000000000000000000000000000000000000000110000001100000011000000110000001101100011001111100000000000000000000000000");
            fonts[ "K" ]    = getFont( "K",7,8,16,12,"000000000000000000000000000000000000000011000110110011001101100011110000111110001101110011001110000000000000000000000000");
            fonts[ "L" ]    = getFont( "L",7,8,16,12,"000000000000000000000000000000000000000001100000011000000110000001100000011000000110000001111110000000000000000000000000");
            fonts[ "M" ]    = getFont( "M",7,8,16,12,"000000000000000000000000000000000000000011000110111011101111111011111110110101101100011011000110000000000000000000000000");
            fonts[ "N" ]    = getFont( "N",7,8,16,12,"000000000000000000000000000000000000000011000110111001101111011011111110110111101100111011000110000000000000000000000000");
            fonts[ "O" ]    = getFont( "O",7,8,16,12,"000000000000000000000000000000000000000001111100110001101100011011000110110001101100011001111100000000000000000000000000");
            fonts[ "P" ]    = getFont( "P",7,8,16,12,"000000000000000000000000000000000000000011111100110001101100011011000110111111001100000011000000000000000000000000000000");
            fonts[ "Q" ]    = getFont( "Q",7,8,16,12,"000000000000000000000000000000000000000001111100110001101100011011000110110111101100110001111010000000000000000000000000");
            fonts[ "R" ]    = getFont( "R",7,8,16,12,"000000000000000000000000000000000000000011111100110001101100011011001110111110001101110011001110000000000000000000000000");
            fonts[ "S" ]    = getFont( "S",7,8,16,12,"000000000000000000000000000000000000000001111000110011001100000001111100000001101100011001111100000000000000000000000000");
            fonts[ "T" ]    = getFont( "T",7,8,16,12,"000000000000000000000000000000000000000001111110000110000001100000011000000110000001100000011000000000000000000000000000");
            fonts[ "U" ]    = getFont( "U",7,8,16,12,"000000000000000000000000000000000000000011000110110001101100011011000110110001101100011001111100000000000000000000000000");
            fonts[ "V" ]    = getFont( "V",7,8,16,12,"000000000000000000000000000000000000000011000110110001101100011011101110011111000011100000010000000000000000000000000000");
            fonts[ "W" ]    = getFont( "W",7,8,16,12,"000000000000000000000000000000000000000011000110110001101101011011111110111111101110111011000110000000000000000000000000");
            fonts[ "X" ]    = getFont( "X",7,8,16,12,"000000000000000000000000000000000000000011000110111011100111110000111000011111001110111011000110000000000000000000000000");
            fonts[ "Y" ]    = getFont( "Y",7,8,16,12,"000000000000000000000000000000000000000001100110011001100110011000111100000110000001100000011000000000000000000000000000");
            fonts[ "Z" ]    = getFont( "Z",7,8,16,12,"000000000000000000000000000000000000000011111110000011100001110000111000011100001110000011111110000000000000000000000000");

            fonts[ "a" ]    = getFont( "a",7,8,16,12,"000000000000000000000000000000000000000000000000000000000111100011001100110011001100110001111110000000000000000000000000");
            fonts[ "b" ]    = getFont( "b",7,8,16,12,"000000000000000000000000000000000000000001100000011000000111110001100110011001100110011001111100000000000000000000000000");
            fonts[ "c" ]    = getFont( "c",7,8,16,12,"000000000000000000000000000000000000000000000000000000000011110001100110011000000110011000111100000000000000000000000000");
            fonts[ "d" ]    = getFont( "d",7,8,16,12,"000000000000000000000000000000000000000000000110000001100011111001100110011001100110011000111110000000000000000000000000");
            fonts[ "e" ]    = getFont( "e",7,8,16,12,"000000000000000000000000000000000000000000000000000000000011110001100110011111100110000000111110000000000000000000000000");
            fonts[ "f" ]    = getFont( "f",7,8,16,12,"000000000000000000000000000000000000000000111000001100000111100000110000001100000011000000110000000000000000000000000000");
            fonts[ "g" ]    = getFont( "g",7,8,16,12,"000000000000000000000000000000000000000000000000000000000011110001100110011001100110011000111110000001100011110000000000");
            fonts[ "h" ]    = getFont( "h",7,8,16,12,"000000000000000000000000000000000000000001100000011000000111110001100110011001100110011001100110000000000000000000000000");
            fonts[ "i" ]    = getFont( "i",7,8,16,12,"000000000000000000000000000000000000000000011000000000000001100000011000000110000001100000011000000000000000000000000000");
            fonts[ "j" ]    = getFont( "j",7,8,16,12,"000000000000000000000000000000000000000000011000000000000001100000011000000110000001100000011000110110000111000000000000");
            fonts[ "k" ]    = getFont( "k",7,8,16,12,"000000000000000000000000000000000000000001100000011000000110011001101100011110000110110001100110000000000000000000000000");
            fonts[ "l" ]    = getFont( "l",8,8,16,12,"000000000000000000000000000000000000000000011000000110000001100000011000000110000001100000011000000000000000000000000000");
            fonts[ "m" ]    = getFont( "m",0,8,16,12,"000000000000000000000000000000000000000000000000100000001111110011010110110101101101011011010110000000000000000000000000");
            fonts[ "n" ]    = getFont( "n",0,8,16,12,"000000000000000000000000000000000000000000000000000000000111110001100110011001100110011001100110000000000000000000000000");
            fonts[ "o" ]    = getFont( "o",0,8,16,12,"000000000000000000000000000000000000000000000000000000000011110001100110011001100110011000111100000000000000000000000000");
            fonts[ "p" ]    = getFont( "p",0,8,16,12,"000000000000000000000000000000000000000000000000000000000111110001100110011001100110011001111100011000000110000000000000");
            fonts[ "q" ]    = getFont( "q",0,8,16,12,"000000000000000000000000000000000000000000000000000000000011111001100110011001100110011000111110000001100000011000000000");
            fonts[ "r" ]    = getFont( "r",0,8,16,12,"000000000000000000000000000000000000000000000000000000000110111001111000011100000110000001100000000000000000000000000000");
            fonts[ "s" ]    = getFont( "s",0,8,16,12,"000000000000000000000000000000000000000000000000000000000011111001110000001111000000111001111100000000000000000000000000");
            fonts[ "t" ]    = getFont( "t",0,8,16,12,"000000000000000000000000000000000000000000110000001100000111100000110000001100000011000000110000000000000000000000000000");
            fonts[ "u" ]    = getFont( "u",0,8,16,12,"000000000000000000000000000000000000000000000000000000000110011001100110011001100110011000111110000000000000000000000000");
            fonts[ "v" ]    = getFont( "v",0,8,16,12,"000000000000000000000000000000000000000000000000000000000110011001100110011001100011110000011000000000000000000000000000");
            fonts[ "w" ]    = getFont( "w",0,8,16,12,"000000000000000000000000000000000000000000000000000000001100011011010110110101101101011001101100000000000000000000000000");
            fonts[ "x" ]    = getFont( "x",0,8,16,12,"000000000000000000000000000000000000000000000000000000000110011000111100000110000011110001100110000000000000000000000000");
            fonts[ "y" ]    = getFont( "y",0,8,16,12,"000000000000000000000000000000000000000000000000000000000110011001100110011001100110011000111110000001100011110000000000");
            fonts[ "z" ]    = getFont( "z",0,8,16,12,"000000000000000000000000000000000000000000000000000000000111111000011100001110000111000001111110000000000000000000000000");

            fonts[ "0" ]    = getFont( "0",7,8,16,12,"000000000000000000000000000000000000000000111000010011001100011011000110110001100110010000111000000000000000000000000000");
            fonts[ "1" ]    = getFont( "1",7,8,16,12,"000000000000000000000000000000000000000000011000001110000111100000011000000110000001100001111110000000000000000000000000");
            fonts[ "2" ]    = getFont( "2",7,8,16,12,"000000000000000000000000000000000000000001111100110001100000111000111100011110001110000011111110000000000000000000000000");
            fonts[ "3" ]    = getFont( "3",7,8,16,12,"000000000000000000000000000000000000000001111110000011000001100000111100000001101100011001111100000000000000000000000000");
            fonts[ "4" ]    = getFont( "4",7,8,16,12,"000000000000000000000000000000000000000000011100001111000110110011001100111111100000110000001100000000000000000000000000");
            fonts[ "5" ]    = getFont( "5",7,8,16,12,"000000000000000000000000000000000000000011111100110000001111110000000110000001101100011001111100000000000000000000000000");
            fonts[ "6" ]    = getFont( "6",7,8,16,12,"000000000000000000000000000000000000000000111100011000001100000011111100110001101100011001111100000000000000000000000000");
            fonts[ "7" ]    = getFont( "7",7,8,16,12,"000000000000000000000000000000000000000011111110110001100000110000011000001100000011000000110000000000000000000000000000");
            fonts[ "8" ]    = getFont( "8",7,8,16,12,"000000000000000000000000000000000000000001111000110001001110010001111000100111101000011001111100000000000000000000000000");
            fonts[ "9" ]    = getFont( "9",7,8,16,12,"000000000000000000000000000000000000000001111100110001101100011001111110000001100000110001111000000000000000000000000000");

            fonts[ "!" ]    = getFont( "!",8,8,16,12,"000000000000000000000000000000000000000000011000000110000001100000011000000110000000000000011000000000000000000000000000");
            fonts[ "\"" ]    = getFont( "\"",0,8,16,12,"000000000000000000000000000000000000000001101100011011000010010000000000000000000000000000000000000000000000000000000000");
            fonts[ "#" ]    = getFont( "#",0,8,16,12,"000000000000000000000000000000000000000001101100111111100110110001101100011011001111111001101100000000000000000000000000");
            fonts[ "$" ]    = getFont( "$",0,8,16,12,"000000000000000000000000000000000000000001111100110101101101000001111100000101101101011001111100000000000000000000000000");
            fonts[ "%" ]    = getFont( "%",0,8,16,12,"000000000000000000000000000000000000000011100100101011001011100011111110001110100110101001001110000000000000000000000000");
            fonts[ "&" ]    = getFont( "&",0,8,16,12,"000000000000000000000000000000000000000000111000011011000110110011111110110011001100111001111010000000000000000000000000");
            fonts[ "'" ]    = getFont( "'",0,8,16,12,"000000000000000000000000000000000000000001100000011000000010000000000000000000000000000000000000000000000000000000000000");
            fonts[ "(" ]    = getFont( "(",0,8,16,12,"000000000000000000000000000000000000000000001100000110000001100000011000000110000001100000001100000000000000000000000000");
            fonts[ ")" ]    = getFont( ")",0,8,16,12,"000000000000000000000000000000000000000000011000000011000000110000001100000011000000110000011000000000000000000000000000");
            fonts[ "=" ]    = getFont( "=",0,8,16,12,"000000000000000000000000000000000000000000000000111111100000000000000000111111100000000000000000000000000000000000000000");
            fonts[ "-" ]    = getFont( "-",0,8,16,12,"000000000000000000000000000000000000000000000000011000001111001010011110000011000000000000000000000000000000000000000000");
            fonts[ "^" ]    = getFont( "^",0,8,16,12,"000000000000000000000000000000000000000000011000000110000001100000011000000110000001100000011000000000000000000000000000");
            fonts[ "~" ]    = getFont( "~",0,8,16,12,"000000000000000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000");
            fonts[ "\"" ]    = getFont( "\"",0,8,16,12,"000000000000000000000000000000000001000000111000011011000000000000000000000000000000000000000000000000000000000000000000");
            fonts[ "|" ]    = getFont( "|",0,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
            fonts[ "`" ]    = getFont( "`",7,8,16,12,"000000000000000000000000000000000000000000001100000110000001100000111000000110000001100000001100000000000000000000000000");
            fonts[ "@" ]    = getFont( "@",7,8,16,12,"000000000000000000000000000000000000000000110000000110000001100000011100000110000001100000110000000000000000000000000000");
            fonts[ "[" ]    = getFont( "[",7,8,16,12,"000000000000000000000000000000000000000000000000000100000111110000111000001010000000000000000000000000000000000000000000");
            fonts[ "]" ]    = getFont( "]",7,8,16,12,"000000000000000000000000000000000000000000000000001100000011000011111100001100000011000000000000000000000000000000000000");
            fonts[ "{" ]    = getFont( "{",8,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000");
            fonts[ "}" ]    = getFont( "}",0,8,16,12,"000000000000000000000000000000000000000000111100011001100110011000001100000110000000000000011000000000000000000000000000");
            fonts[ ";" ]    = getFont( ";",0,8,16,12,"000000000000000000000000000000000000000001100000001100000001100000001100000110000011000001100000000000000000000000000000");
            fonts[ ":" ]    = getFont( ":",0,8,16,12,"000000000000000000000000000000000000000000001100000110000011000001100000001100000001100000001100000000000000000000000000");
            fonts[ "+" ]    = getFont( "+",0,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000110000000100000000000000000000");
            fonts[ "*" ]    = getFont( "*",0,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000110000000000000000000000000000");
            fonts[ "<" ]    = getFont( "<",0,8,16,12,"000000000000000000000000000000000000000000000110000011000001100000110000011000001100000010000000000000000000000000000000");
            fonts[ ">" ]    = getFont( ">",0,8,16,12,"000000000000000000000000000000000000000011000000011000000011000000011000000011000000011000000010000000000000000000000000");
            fonts[ "," ]    = getFont( ",",0,8,16,12,"000000000000000000000000000000000000000000111000000110000001100000011000000110000001100000111000000000000000000000000000");
            fonts[ "." ]    = getFont( ".",0,8,16,12,"000000000000000000000000000000000000000000111000001100000011000000110000001100000011000000111000000000000000000000000000");
            fonts[ "/" ]    = getFont( "/",0,8,16,12,"000000000000000000000000000000000000000000000000000110000001100000000000000110000001100000000000000000000000000000000000");
            fonts[ "?" ]    = getFont( "?",0,8,16,12,"000000000000000000000000000000000000000000000000000110000001100000000000000110000001100000001000000000000000000000000000");
            fonts[ "_" ]    = getFont( "_",0,8,16,12,"000000000000000000000000000000000000000001111100110001101111011011010110111101101100000001111110000000000000000000000000");

            fonts[ "あ" ]    = getFont( "あ",7,8,16,12,"000000000000000000000000000000000000000000100000111111000010000001111100101010101011001011100100000000000000000000000000");
            fonts[ "い" ]    = getFont( "い",7,8,16,12,"000000000000000000000000000000000000000000000000100010001000010010000010100000101010001001000000000000000000000000000000");
            fonts[ "う" ]    = getFont( "う",7,8,16,12,"000000000000000000000000000000000000000001111000000000000111110010000010000000100000010000011000000000000000000000000000");
            fonts[ "え" ]    = getFont( "え",7,8,16,12,"000000000000000000000000000000000000000001111000000000001111110000001000000100000010100011001110000000000000000000000000");
            fonts[ "お" ]    = getFont( "お",7,8,16,12,"000000000000000000000000000000000000000000101100111100100010000000111100011000101010001011101100000000000000000000000000");
            fonts[ "か" ]    = getFont( "か",7,8,16,12,"000000000000000000000000000000000000000000100100111110100010011000100100010001000101010010001100000000000000000000000000");
            fonts[ "き" ]    = getFont( "き",7,8,16,12,"000000000000000000000000000000000000000000010000011111000000100011111110000010000100000000111110000000000000000000000000");
            fonts[ "く" ]    = getFont( "く",7,8,16,12,"000000000000000000000000000000000000000000001000000100000010000001000000001000000001000000001000000000000000000000000000");
            fonts[ "け" ]    = getFont( "け",7,8,16,12,"000000000000000000000000000000000000000010000100101111101000010010000100100001001000010001011000000000000000000000000000");
            fonts[ "こ" ]    = getFont( "こ",7,8,16,12,"000000000000000000000000000000000000000001111000000001000000000000000000000000001000001001111100000000000000000000000000");
            fonts[ "さ" ]    = getFont( "さ",7,8,16,12,"000000000000000000000000000000000000000000010000111111100000100000000100100011001000000001111100000000000000000000000000");
            fonts[ "し" ]    = getFont( "し",7,8,16,12,"000000000000000000000000000000000000000010000000100000001000000010000010100000100100010000111000000000000000000000000000");
            fonts[ "す" ]    = getFont( "す",7,8,16,12,"000000000000000000000000000000000000000000000100111111100011110001000100001111000000010000011000000000000000000000000000");
            fonts[ "せ" ]    = getFont( "せ",7,8,16,12,"000000000000000000000000000000000000000001000100111111100100010001000100010000000100000000111100000000000000000000000000");
            fonts[ "そ" ]    = getFont( "そ",7,8,16,12,"000000000000000000000000000000000000000001111100000010001111111000011000001000000010000000011100000000000000000000000000");
            fonts[ "た" ]    = getFont( "た",7,8,16,12,"000000000000000000000000000000000000000001000000111111000100000001011110100000001010000010011110000000000000000000000000");
            fonts[ "ち" ]    = getFont( "ち",7,8,16,12,"000000000000000000000000000000000000000000100000111111100010000000111100010000100000001000111100000000000000000000000000");
            fonts[ "つ" ]    = getFont( "つ",7,8,16,12,"000000000000000000000000000000000000000000000000111111000000001000000010000000100000010000111000000000000000000000000000");
            fonts[ "て" ]    = getFont( "て",7,8,16,12,"000000000000000000000000000000000000000011111110000010000001000000100000001000000010000000011100000000000000000000000000");
            fonts[ "と" ]    = getFont( "と",7,8,16,12,"000000000000000000000000000000000000000001000000001001100011100000100000010000000100000000111110000000000000000000000000");
            fonts[ "な" ]    = getFont( "な",7,8,16,12,"000000000000000000000000000000000000000001000000111101100100001010001000001110000100110000110010000000000000000000000000");
            fonts[ "に" ]    = getFont( "に",7,8,16,12,"000000000000000000000000000000000000000001000000100111101000000010000000100000001001000011001110000000000000000000000000");
            fonts[ "ぬ" ]    = getFont( "ぬ",7,8,16,12,"000000000000000000000000000000000000000001001000011111001100101010101010101101101011101001100110000000000000000000000000");
            fonts[ "ね" ]    = getFont( "ね",7,8,16,12,"000000000000000000000000000000000000000001000000111011000101001001100010110011101101001001001110000000000000000000000000");
            fonts[ "の" ]    = getFont( "の",7,8,16,12,"000000000000000000000000000000000000000000000000001111000101001010010010100100101001001001100100000000000000000000000000");
            fonts[ "は" ]    = getFont( "は",7,8,16,12,"000000000000000000000000000000000000000000000100101111101000010010000100100111001010011001011010000000000000000000000000");
            fonts[ "ひ" ]    = getFont( "ひ",7,8,16,12,"000000000000000000000000000000000000000000110000111000000010110001000110010001000100010000111000000000000000000000000000");
            fonts[ "ふ" ]    = getFont( "ふ",7,8,16,12,"000000000000000000000000000000000000000000111000000010000001000001010100010010101000101010110110000000000000000000000000");
            fonts[ "へ" ]    = getFont( "へ",7,8,16,12,"000000000000000000000000000000000000000000000000001000000101000010001000100001000000001000000000000000000000000000000000");
            fonts[ "ほ" ]    = getFont( "ほ",7,8,16,12,"000000000000000000000000000000000000000010111110100001001011111010000100100111001010011011011010000000000000000000000000");
            fonts[ "ま" ]    = getFont( "ま",7,8,16,12,"000000000000000000000000000000000000000000010000111111000001000011111100011100001001100011100100000000000000000000000000");
            fonts[ "み" ]    = getFont( "み",7,8,16,12,"000000000000000000000000000000000000000011100000001001000010010001111110101001001010010001001000000000000000000000000000");
            fonts[ "む" ]    = getFont( "む",7,8,16,12,"000000000000000000000000000000000000000000100000111101000010001001100010101000001010001001111100000000000000000000000000");
            fonts[ "め" ]    = getFont( "め",7,8,16,12,"000000000000000000000000000000000000000001001000011111000100101011001010101100101010001001010100000000000000000000000000");
            fonts[ "も" ]    = getFont( "も",7,8,16,12,"000000000000000000000000000000000000000000010000011111000010000011111100001000000010001000011100000000000000000000000000");
            fonts[ "や" ]    = getFont( "や",7,8,16,12,"000000000000000000000000000000000000000001001000010111000110001010100010001001000001000000010000000000000000000000000000");
            fonts[ "ゐ" ]    = getFont( "ゐ",7,8,16,12,"000000000000000000000000000000000000000001110000000100000011110001010010100100101001011001100110000000000000000000000000");
            fonts[ "ゆ" ]    = getFont( "ゆ",7,8,16,12,"000000000000000000000000000000000000000001010000101111001100101010001010101010101001110001010000000000000000000000000000");
            fonts[ "ゑ" ]    = getFont( "ゑ",7,8,16,12,"000000000000000000000000000000000000000000111000000100000111110000000100001110000111110010101010000000000000000000000000");
            fonts[ "よ" ]    = getFont( "よ",7,8,16,12,"000000000000000000000000000000000000000000010000000111000001000000010000011110001001010001100010000000000000000000000000");
            fonts[ "ら" ]    = getFont( "ら",7,8,16,12,"000000000000000000000000000000000000000000011000000001000010000001011100011000100100001000011100000000000000000000000000");
            fonts[ "り" ]    = getFont( "り",7,8,16,12,"000000000000000000000000000000000000000001000100010000100100001001010010001000100000010000001000000000000000000000000000");
            fonts[ "る" ]    = getFont( "る",7,8,16,12,"000000000000000000000000000000000000000001111000000100000011110001000010100000100011101000111100000000000000000000000000");
            fonts[ "れ" ]    = getFont( "れ",7,8,16,12,"000000000000000000000000000000000000000000100000111011100011001000100010011000101010010000100110000000000000000000000000");
            fonts[ "ろ" ]    = getFont( "ろ",7,8,16,12,"000000000000000000000000000000000000000001111000000100000011110001000010100000100000001000011100000000000000000000000000");
            fonts[ "わ" ]    = getFont( "わ",7,8,16,12,"000000000000000000000000000000000000000001000000110111000110001001000010110000100100001001000100000000000000000000000000");
            fonts[ "を" ]    = getFont( "を",7,8,16,12,"000000000000000000000000000000000000000000010000011111000011000001011110001010000100000000111100000000000000000000000000");
            fonts[ "ん" ]    = getFont( "ん",7,8,16,12,"000000000000000000000000000000000000000000010000001000000010000001110000010010001000101010000100000000000000000000000000");
            fonts[ "ぁ" ]    = getFont( "ぁ",7,8,16,12,"000000000000000000000000000000000000000000000000001000000111100000100000011101001010100011110100000000000000000000000000");
            fonts[ "ぃ" ]    = getFont( "ぃ",7,8,16,12,"000000000000000000000000000000000000000000000000000000001000100010000100100001001010010001000000000000000000000000000000");
            fonts[ "ぅ" ]    = getFont( "ぅ",7,8,16,12,"000000000000000000000000000000000000000000000000011100000000000011111000000010000000100001110000000000000000000000000000");
            fonts[ "ぇ" ]    = getFont( "ぇ",7,8,16,12,"000000000000000000000000000000000000000000000000011100000000000011111000000100000111000011011100000000000000000000000000");
            fonts[ "ぉ" ]    = getFont( "ぉ",7,8,16,12,"000000000000000000000000000000000000000000000000001010001111010000100000011110001010010011001100000000000000000000000000");
            fonts[ "っ" ]    = getFont( "っ",7,8,16,12,"000000000000000000000000000000000000000000000000000000000011100011000100000001000000010000111000000000000000000000000000");
            fonts[ "ゃ" ]    = getFont( "ゃ",7,8,16,12,"000000000000000000000000000000000000000000000000010010000111100011000100010001000010100000100000000000000000000000000000");
            fonts[ "ゅ" ]    = getFont( "ゅ",7,8,16,12,"000000000000000000000000000000000000000000000000000100001011100011010100100101001001110000110000000000000000000000000000");
            fonts[ "ょ" ]    = getFont( "ょ",7,8,16,12,"000000000000000000000000000000000000000000000000000100000001110000010000011100001001100001110100000000000000000000000000");
            fonts[ "ゎ" ]    = getFont( "ゎ",7,8,16,12,"000000000000000000000000000000000000000000000000010000001101100001100100010001001100010001001000000000000000000000000000");
            fonts[ "が" ]    = getFont( "が",7,8,16,12,"000000000000000000000000000001010000010100100100111110100010011000100100010001000101010010001100000000000000000000000000");
            fonts[ "ぎ" ]    = getFont( "ぎ",7,8,16,12,"000000000000000000000000000001010000010100010000011111000000100011111110000010000100000000111110000000000000000000000000");
            fonts[ "ぐ" ]    = getFont( "ぐ",7,8,16,12,"000000000000000000000000000001010000010100001000000100000010000001000000001000000001000000001000000000000000000000000000");
            fonts[ "げ" ]    = getFont( "げ",7,8,16,12,"000000000000000000000000000001010000010110000100101111101000010010000100100001001000010001011000000000000000000000000000");
            fonts[ "ご" ]    = getFont( "ご",7,8,16,12,"000000000000000000000000000001010000010101111000000001000000000000000000000000001000001001111100000000000000000000000000");
            fonts[ "ざ" ]    = getFont( "ざ",7,8,16,12,"000000000000000000000000000001010000010100010000111111100000100000000100100011001000000001111100000000000000000000000000");
            fonts[ "じ" ]    = getFont( "じ",7,8,16,12,"000000000000000000000000000001010000010110000000100000001000000010000010100000100100010000111000000000000000000000000000");
            fonts[ "ず" ]    = getFont( "ず",7,8,16,12,"000000000000000000000000000001010000010100000100111111100011110001000100001111000000010000011000000000000000000000000000");
            fonts[ "ぜ" ]    = getFont( "ぜ",7,8,16,12,"000000000000000000000000000001010000010101000100111111100100010001000100010000000100000000111100000000000000000000000000");
            fonts[ "ぞ" ]    = getFont( "ぞ",7,8,16,12,"000000000000000000000000000001010000010101111100000010001111111000011000001000000010000000011100000000000000000000000000");
            fonts[ "だ" ]    = getFont( "だ",7,8,16,12,"000000000000000000000000000001010000010101000000111111000100000001011110100000001010000010011110000000000000000000000000");
            fonts[ "ぢ" ]    = getFont( "ぢ",7,8,16,12,"000000000000000000000000000001010000010100100000111111100010000000111100010000100000001000111100000000000000000000000000");
            fonts[ "づ" ]    = getFont( "づ",7,8,16,12,"000000000000000000000000000001010000010100000000111111000000001000000010000000100000010000111000000000000000000000000000");
            fonts[ "で" ]    = getFont( "で",7,8,16,12,"000000000000000000000000000001010000010111111110000010000001000000100000001000000010000000011100000000000000000000000000");
            fonts[ "ど" ]    = getFont( "ど",7,8,16,12,"000000000000000000000000000001010000010101000000001001100011100000100000010000000100000000111110000000000000000000000000");
            fonts[ "ば" ]    = getFont( "ば",7,8,16,12,"000000000000000000000000000001010000010100000100101111101000010010000100100111001010011001011010000000000000000000000000");
            fonts[ "び" ]    = getFont( "び",7,8,16,12,"000000000000000000000000000001010000010100110000111000000010110001000110010001000100010000111000000000000000000000000000");
            fonts[ "ぶ" ]    = getFont( "ぶ",7,8,16,12,"000000000000000000000000000001010000010100111000000010000001000001010100010010101000101010110110000000000000000000000000");
            fonts[ "べ" ]    = getFont( "べ",7,8,16,12,"000000000000000000000000000001010000010100000000001000000111000011011000100011000000011000000010000000000000000000000000");
            fonts[ "ぼ" ]    = getFont( "ぼ",7,8,16,12,"000000000000000000000000000001010000010110111110100001001011111010000100100111001010011011011010000000000000000000000000");
            fonts[ "ぱ" ]    = getFont( "ぱ",7,8,16,12,"000000000000000000000010000001010000001000000100101111101000010010000100100111001010011001011010000000000000000000000000");
            fonts[ "ぴ" ]    = getFont( "ぴ",7,8,16,12,"000000000000000000000010000001010000001000110000111000000010110001000110010001000100010000111000000000000000000000000000");
            fonts[ "ぷ" ]    = getFont( "ぷ",7,8,16,12,"000000000000000000000010000001010000001000111000000010000001000001010100010010101000101010110110000000000000000000000000");
            fonts[ "ぺ" ]    = getFont( "ぺ",7,8,16,12,"000000000000000000000000000001000000101000000100001000000101000010001000100001000000001000000000000000000000000000000000");
            fonts[ "ぽ" ]    = getFont( "ぽ",7,8,16,12,"000000000000000000000010000001010000001010111110100001001011111010000100100111001010011011011010000000000000000000000000");

            fonts[ "ア" ]    = getFont( "ア",7,8,16,12,"000000000000000000000000000000000000000011111110000000100001001000010100000100000010000001000000000000000000000000000000");
            fonts[ "イ" ]    = getFont( "イ",7,8,16,12,"000000000000000000000000000000000000000000000010000001000001100011101000000010000000100000001000000000000000000000000000");
            fonts[ "ウ" ]    = getFont( "ウ",7,8,16,12,"000000000000000000000000000000000000000000010000111111101000001010000010000000100000010000111000000000000000000000000000");
            fonts[ "エ" ]    = getFont( "エ",7,8,16,12,"000000000000000000000000000000000000000000000000111111100001000000010000000100000001000011111110000000000000000000000000");
            fonts[ "オ" ]    = getFont( "オ",7,8,16,12,"000000000000000000000000000000000000000000000100111111100000010000001100000101000010010011000100000000000000000000000000");
            fonts[ "カ" ]    = getFont( "カ",7,8,16,12,"000000000000000000000000000000000000000000100000111111100010001000100010010000100100001010001100000000000000000000000000");
            fonts[ "キ" ]    = getFont( "キ",7,8,16,12,"000000000000000000000000000000000000000000100000111111100001000000010000111111100000100000001000000000000000000000000000");
            fonts[ "ク" ]    = getFont( "ク",7,8,16,12,"000000000000000000000000000000000000000000100000001111100100001010000010000000100000010000111000000000000000000000000000");
            fonts[ "ケ" ]    = getFont( "ケ",7,8,16,12,"000000000000000000000000000000000000000001000000011111100100010010000100000001000000100000110000000000000000000000000000");
            fonts[ "コ" ]    = getFont( "コ",7,8,16,12,"000000000000000000000000000000000000000000000000111111100000001000000010000000100000001011111110000000000000000000000000");
            fonts[ "サ" ]    = getFont( "サ",7,8,16,12,"000000000000000000000000000000000000000001000100111111100100010001000100000001000000100000110000000000000000000000000000");
            fonts[ "シ" ]    = getFont( "シ",7,8,16,12,"000000000000000000000000000000000000000011000000001000001100001000100010000001000000100001110000000000000000000000000000");
            fonts[ "ス" ]    = getFont( "ス",7,8,16,12,"000000000000000000000000000000000000000011111110000000100000010000001000000101000010001011000010000000000000000000000000");
            fonts[ "セ" ]    = getFont( "セ",7,8,16,12,"000000000000000000000000000000000000000001000000111111100100001001000100010000000100000000111110000000000000000000000000");
            fonts[ "ソ" ]    = getFont( "ソ",7,8,16,12,"000000000000000000000000000000000000000010000010010000100100001000000010000001000000100000110000000000000000000000000000");
            fonts[ "タ" ]    = getFont( "タ",7,8,16,12,"000000000000000000000000000000000000000000111110001000100110001010011010000001100000010000111000000000000000000000000000");
            fonts[ "チ" ]    = getFont( "チ",7,8,16,12,"000000000000000000000000000000000000000000001100011100000001000011111110000100000001000000100000000000000000000000000000");
            fonts[ "ツ" ]    = getFont( "ツ",7,8,16,12,"000000000000000000000000000000000000000001010010010100100101001000000010000000100000010000111000000000000000000000000000");
            fonts[ "テ" ]    = getFont( "テ",7,8,16,12,"000000000000000000000000000000000000000001111100000000001111111000010000000100000001000000100000000000000000000000000000");
            fonts[ "ト" ]    = getFont( "ト",6,8,16,12,"000000000000000000000000000000000000000001000000010000000100000001110000010011000100000001000000000000000000000000000000");
            fonts[ "ナ" ]    = getFont( "ナ",7,8,16,12,"000000000000000000000000000000000000000000001000111111100000100000001000000100000001000000100000000000000000000000000000");
            fonts[ "ニ" ]    = getFont( "ニ",7,8,16,12,"000000000000000000000000000000000000000000000000011111000000000000000000000000000000000011111110000000000000000000000000");
            fonts[ "ヌ" ]    = getFont( "ヌ",7,8,16,12,"000000000000000000000000000000000000000011111110000000100000001000110100000011000000101001110000000000000000000000000000");
            fonts[ "ネ" ]    = getFont( "ネ",7,8,16,12,"000000000000000000000000000000000000000000010000111111100000001000000100001110001101011000010000000000000000000000000000");
            fonts[ "ノ" ]    = getFont( "ノ",7,8,16,12,"000000000000000000000000000000000000000000000010000000100000001000000100000001000001100011100000000000000000000000000000");
            fonts[ "ハ" ]    = getFont( "ハ",7,8,16,12,"000000000000000000000000000000000000000001001000010001000100010001000010010000100100001010000010000000000000000000000000");
            fonts[ "ヒ" ]    = getFont( "ヒ",7,8,16,12,"000000000000000000000000000000000000000001000000010001100111100001000000010000000100000000111110000000000000000000000000");
            fonts[ "フ" ]    = getFont( "フ",7,8,16,12,"000000000000000000000000000000000000000011111110000000100000001000000010000000100000010000111000000000000000000000000000");
            fonts[ "ヘ" ]    = getFont( "ヘ",7,8,16,12,"000000000000000000000000000000000000000000000000001000000101000010001000100001000000001000000000000000000000000000000000");
            fonts[ "ホ" ]    = getFont( "ホ",7,8,16,12,"000000000000000000000000000000000000000000010000111111100001000001010100010101001001001010010010000000000000000000000000");
            fonts[ "、" ]    = getFont( "、",6,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000100000000100000000100000000000000000000000000000");
            fonts[ "。" ]    = getFont( "。",7,8,16,12,"000000000000000000000000000000000000000000000000000000000000000001100000100100001001000001100000000000000000000000000000");
            fonts[ "マ" ]    = getFont( "マ",7,8,16,12,"000000000000000000000000000000000000000011111110000000100000001000000100001010000001000000001000000000000000000000000000");
            fonts[ "ミ" ]    = getFont( "ミ",6,8,16,12,"000000000000000000000000000000000000000001110000000011000110000000011000000000001110000000011100000000000000000000000000");
            fonts[ "ム" ]    = getFont( "ム",7,8,16,12,"000000000000000000000000000000000000000000010000001000000010000001000100010001001000111011110010000000000000000000000000");
            fonts[ "メ" ]    = getFont( "メ",7,8,16,12,"000000000000000000000000000000000000000000000010010000100010001000010100000010000001010011100010000000000000000000000000");
            fonts[ "モ" ]    = getFont( "モ",7,8,16,12,"000000000000000000000000000000000000000001111100001000000010000011111110001000000010000000011100000000000000000000000000");
            fonts[ "ヤ" ]    = getFont( "ヤ",7,8,16,12,"000000000000000000000000000000000000000001000000111111100100001000100100001000000001000000010000000000000000000000000000");
            fonts[ "ヰ" ]    = getFont( "ヰ",7,8,16,12,"000000000000000000000000000000000000000000001000000010000111100001001000111111100000100000001000000000000000000000000000");
            fonts[ "ユ" ]    = getFont( "ユ",7,8,16,12,"000000000000000000000000000000000000000000000000011110000000100000001000000010000000100011111110000000000000000000000000");
            fonts[ "ヱ" ]    = getFont( "ヱ",7,8,16,12,"000000000000000000000000000000000000000011111100000001000001010000011000000100000001000011111110000000000000000000000000");
            fonts[ "ヨ" ]    = getFont( "ヨ",6,8,16,12,"000000000000000000000000000000000000000011111100000001000000010011111100000001000000010011111100000000000000000000000000");
            fonts[ "ラ" ]    = getFont( "ラ",7,8,16,12,"000000000000000000000000000000000000000001111100000000001111111000000010000000100000010001111000000000000000000000000000");
            fonts[ "リ" ]    = getFont( "リ",7,8,16,12,"000000000000000000000000000000000000000001000010010000100100001001000010000000100000010000111000000000000000000000000000");
            fonts[ "ル" ]    = getFont( "ル",7,8,16,12,"000000000000000000000000000000000000000000010000010100000101000001010000010100100101010010011000000000000000000000000000");
            fonts[ "レ" ]    = getFont( "レ",6,8,16,12,"000000000000000000000000000000000000000010000000100000001000000010000000100001001000100011110000000000000000000000000000");
            fonts[ "ロ" ]    = getFont( "ロ",7,8,16,12,"000000000000000000000000000000000000000011111110100000101000001010000010100000101000001011111110000000000000000000000000");
            fonts[ "ワ" ]    = getFont( "ワ",7,8,16,12,"000000000000000000000000000000000000000011111110100000101000001000000010000000100000010000111000000000000000000000000000");
            fonts[ "ヲ" ]    = getFont( "ヲ",7,8,16,12,"000000000000000000000000000000000000000011111110000000100000001000111110000000100000010001111000000000000000000000000000");
            fonts[ "ン" ]    = getFont( "ン",7,8,16,12,"000000000000000000000000000000000000000011000000001100100000001000000010000000100000110011110000000000000000000000000000");
            fonts[ "ァ" ]    = getFont( "ァ",5,8,16,12,"000000000000000000000000000000000000000000000000111110000000100000101000001100000010000001000000000000000000000000000000");
            fonts[ "ィ" ]    = getFont( "ィ",5,8,16,12,"000000000000000000000000000000000000000000000000000010000001000011100000001000000010000000100000000000000000000000000000");
            fonts[ "ゥ" ]    = getFont( "ゥ",5,8,16,12,"000000000000000000000000000000000000000000000000001000001111100010001000000010000001000000100000000000000000000000000000");
            fonts[ "ェ" ]    = getFont( "ェ",5,8,16,12,"000000000000000000000000000000000000000000000000000000001111100000100000001000000010000011111000000000000000000000000000");
            fonts[ "ォ" ]    = getFont( "ォ",5,8,16,12,"000000000000000000000000000000000000000000000000000100001111100000010000001100000101000010010000000000000000000000000000");
            fonts[ "ッ" ]    = getFont( "ッ",5,8,16,12,"000000000000000000000000000000000000000000000000000000001010100010101000000010000001000001100000000000000000000000000000");
            fonts[ "ャ" ]    = getFont( "ャ",5,8,16,12,"000000000000000000000000000000000000000000000000010000001111100001001000010010000010000000100000000000000000000000000000");
            fonts[ "ュ" ]    = getFont( "ュ",5,8,16,12,"000000000000000000000000000000000000000000000000000000000111000000010000000100000001000011111000000000000000000000000000");
            fonts[ "ョ" ]    = getFont( "ョ",5,8,16,12,"000000000000000000000000000000000000000000000000000000001111100000001000011110000000100011111000000000000000000000000000");
            fonts[ "ヮ" ]    = getFont( "ヮ",5,8,16,12,"000000000000000000000000000000000000000000000000000000001111100010001000000010000001000001100000000000000000000000000000");
            fonts[ "ガ" ]    = getFont( "ガ",7,8,16,12,"000000000000000000000000000001010000010100100000111111100010001000100010010000100100001010001100000000000000000000000000");
            fonts[ "ギ" ]    = getFont( "ギ",7,8,16,12,"000000000000000000000000000001010000010100100000111111100001000000010000111111100000100000001000000000000000000000000000");
            fonts[ "グ" ]    = getFont( "グ",7,8,16,12,"000000000000000000000000000001010000010100100000001111100100001010000010000000100000010000111000000000000000000000000000");
            fonts[ "ゲ" ]    = getFont( "ゲ",7,8,16,12,"000000000000000000000000000001010000010101000000011111100100010010000100000001000000100000110000000000000000000000000000");
            fonts[ "ゴ" ]    = getFont( "ゴ",7,8,16,12,"000000000000000000000000000001010000010100000000111111100000001000000010000000100000001011111110000000000000000000000000");
            fonts[ "ザ" ]    = getFont( "ザ",7,8,16,12,"000000000000000000000000000001010000010101000100111111100100010001000100000001000000100000110000000000000000000000000000");
            fonts[ "ジ" ]    = getFont( "ジ",7,8,16,12,"000000000000000000000000000001010000010111000000001000001100001000100010000001000000100001110000000000000000000000000000");
            fonts[ "ズ" ]    = getFont( "ズ",7,8,16,12,"000000000000000000000000000001010000010111111110000000100000010000001000000101000010001011000010000000000000000000000000");
            fonts[ "ゼ" ]    = getFont( "ゼ",7,8,16,12,"000000000000000000000000000001010000010101000000111111100100001001000100010000000100000000111110000000000000000000000000");
            fonts[ "ゾ" ]    = getFont( "ゾ",7,8,16,12,"000000000000000000000000000001010000010110000000010000100100001000000010000001000000100000110000000000000000000000000000");
            fonts[ "ダ" ]    = getFont( "ダ",7,8,16,12,"000000000000000000000000000001010000010100111110001000100110001010011010000001100000010000111000000000000000000000000000");
            fonts[ "ヂ" ]    = getFont( "ヂ",7,8,16,12,"000000000000000000000000000001010000010100001100011100000001000011111110000100000001000000100000000000000000000000000000");
            fonts[ "ヅ" ]    = getFont( "ヅ",7,8,16,12,"000000000000000000000000000001010000010101010000010100100101001000000010000000100000010000111000000000000000000000000000");
            fonts[ "デ" ]    = getFont( "デ",7,8,16,12,"000000000000000000000000000001010000010101111100000000001111111000010000000100000001000000100000000000000000000000000000");
            fonts[ "ド" ]    = getFont( "ド",7,8,16,12,"000000000000000000000000000010100000101001000000010000000100000001110000010011000100000001000000000000000000000000000000");
            fonts[ "バ" ]    = getFont( "バ",7,8,16,12,"000000000000000000000000000001010000010101001000010001000100010001000010010000100100001010000010000000000000000000000000");
            fonts[ "ビ" ]    = getFont( "ビ",7,8,16,12,"000000000000000000000000000001010000010101000000010001100111100001000000010000000100000000111110000000000000000000000000");
            fonts[ "ブ" ]    = getFont( "ブ",7,8,16,12,"000000000000000000000000000001010000010111111110000000100000001000000010000000100000010000111000000000000000000000000000");
            fonts[ "ベ" ]    = getFont( "ベ",7,8,16,12,"000000000000000000000000000000000000101000001010001000000101000010001000100001000000001000000000000000000000000000000000");
            fonts[ "ボ" ]    = getFont( "ボ",7,8,16,12,"000000000000000000000000000001010000010100010000111111100001000001010100010101001001001010010010000000000000000000000000");
            fonts[ "パ" ]    = getFont( "パ",7,8,16,12,"000000000000000000000010000001010000001001001000010001000100010001000010010000100100001010000010000000000000000000000000");
            fonts[ "ピ" ]    = getFont( "ピ",7,8,16,12,"000000000000000000000010000001010000001001000000010001100111100001000000010000000100000000111110000000000000000000000000");
            fonts[ "プ" ]    = getFont( "プ",7,8,16,12,"000000000000000000000010000001010000001011111110000000100000001000000010000000100000010000111000000000000000000000000000");
            fonts[ "ペ" ]    = getFont( "ペ",7,8,16,12,"000000000000000000000000000001000000101000000100001000000101000010001000100001000000001000000000000000000000000000000000");
            fonts[ "ポ" ]    = getFont( "ポ",8,8,16,12,"000000000000000000000010000001010000001000010000111111100001000001010100010101001001001010010010000000000000000000000000");            
            
            fonts[ " " ]    = getFont( " ",5,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
            fonts[ "　" ]    = getFont( "　",5,8,16,12,"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
            
            fonts[ "ng" ]    = getFont( "ng",7,8,16,12,"000000001111111011000110101010101001001010101010110001101111111000000000000000000000000000000000000000000000000000000000");
            fonts[ "return" ]    = new FontData( "return" );
        }
        
        private function getFont( c:String, width:int, boxWidth:int, boxHeight:int, baseline:int, data:String ):FontData
        {
            var font    :FontData = new FontData( c );
            font.width       = width;
            font.boxWidth    = boxWidth;
            font.boxHeight   = boxHeight;
            font.baseline    = baseline;
            font.data        = data;
            return font;
        }
    }