/**
 * Copyright yoshuki ( http://wonderfl.net/user/yoshuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Au0
 */

package {
  import flash.display.Sprite
  import flash.events.Event
  import flash.events.MouseEvent
  
  import org.papervision3d.core.utils.Mouse3D
  import org.papervision3d.events.InteractiveScene3DEvent
  import org.papervision3d.lights.PointLight3D
  import org.papervision3d.materials.shadematerials.FlatShadeMaterial
  import org.papervision3d.objects.primitives.Plane
  import org.papervision3d.objects.primitives.Sphere
  import org.papervision3d.view.BasicView

  [SWF(width=640, height=480, frameRate=30, backgroundColor=0xffffff)]

  public class BallPut extends Sprite {
    private var degree:int

    private var ball:Sphere
    private var light:PointLight3D
    private var world:BasicView
    private var land:Plane

    public function BallPut() {
      Mouse3D.enabled = true

      world = new BasicView(640, 480, true, true)
      addChild(world)
      world.startRendering()

      world.camera.y = 150

      light = new PointLight3D(true)
      light.y = 250
      world.scene.addChild(light)

      var ballMat:FlatShadeMaterial = new FlatShadeMaterial(light, 0xffffff)
      ball = new Sphere(ballMat, 30, 20, 20)
      ball.y = 30
      world.scene.addChild(ball)

      var landMat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x66cc66)
      landMat.interactive = true
      land = new Plane(landMat, 500, 500, 20, 20)
      land.rotationX = 90
      land.rotationY = 30
      land.addEventListener(MouseEvent.MOUSE_OVER, function (event:InteractiveScene3DEvent):void {
        world.viewport.containerSprite.buttonMode = true
      })
      land.addEventListener(MouseEvent.MOUSE_OUT, function (event:InteractiveScene3DEvent):void {
        world.viewport.containerSprite.buttonMode = false
      })
      land.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, function(event:InteractiveScene3DEvent):void {
        ball.x = world.viewport.interactiveSceneManager.mouse3D.x
        ball.z = world.viewport.interactiveSceneManager.mouse3D.z
      })
      world.scene.addChild(land)

      addEventListener(Event.ENTER_FRAME, function(event:Event):void {
        degree += 1
        if (degree === 360) { degree = 0 }

        world.camera.x = (500 * Math.cos(degree * Math.PI / 180))
        world.camera.z = (500 * Math.sin(degree * Math.PI / 180))

        light.x = (300 * Math.cos((360 - degree) * Math.PI / 180))
        light.z = (300 * Math.sin((360 - degree) * Math.PI / 180))
      })
    }
  }
}