/**
 * Copyright luis.castrejon.s ( http://wonderfl.net/user/luis.castrejon.s )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/3AaV
 */

// forked from romatica's [FLARToolkit]　マーカーに「蝶」がとまる (Butterfly Animation)
// forked from romatica's FLARToolkitマーカー位置にイージング移動 (easing motion)
// forked from rokubou's FLARToolKit_Sample_Simple_PV3D
/**
 *-------------------------------------------------
 *
 *  FLARToolkit Butterfly Animation
 *
 * 　マーカーを認識すると、「蝶」がマーカーによってきて、とまります。
 * 　非認識だと、飛び立ちます。
 * 　認識中マーカーを極端に動かすと、飛び立ち、また、マーカー位置にとまります。
 *
 *　　TODO:
 *　　蝶のアニメーションもっと自然にしたい。
 *　　蝶のアニメーション動き部分、コードぐちゃぐちゃ。後で直す。
 *
 *　
 *　　認識中はマーカー位置に花とか表示するとよい？かも
 *
 *　　[marker pdf] マーカーをプリントしてください
 *　　www.romatica.com/dev/resource/flarlogo-marker.pdf
 * 
 *-------------------------------------------------
 */
 
package {
    import org.libspark.flartoolkit.core.FLARCode;
    import org.libspark.flartoolkit.core.param.FLARParam;
    import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
    import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
    import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
    import org.libspark.flartoolkit.support.pv3d.FLARBaseNode;
    import org.libspark.flartoolkit.support.pv3d.FLARCamera3D;
    import org.papervision3d.core.math.Matrix3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.LazyRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.Dictionary;

    [SWF(width=640, height=480, backgroundColor=0x808080, frameRate=30)]

    /**
        auther @itoz (http://www.romatica.com)
    **/
    public class FLARToolkit_Butterfly extends Sprite {

        /**
         * FLAR
         */
        protected var canvasWidth : int;
        protected var canvasHeight : int;

        protected var captureWidth : int;
        protected var captureHeight : int;

        protected var codeWidth : int;

        protected var cameraParamFile : String;
        protected var markerPatternFile : String;

        private var urlLoader : URLLoader;

        protected var cameraParam : FLARParam;
        protected var markerPatternCode : FLARCode;
        protected var hiroCode:FLARCode;

        protected var webCamera : Camera;

        protected var video : Video;

        private var capture : Bitmap;

        private var raster : FLARRgbRaster_BitmapData;

        private var detector : FLARSingleMarkerDetector;

        /**
         * PV3D
         */
        protected var scene : Scene3D;
        protected var viewport : Viewport3D;
        protected var camera3D : FLARCamera3D;
        protected var renderer : LazyRenderEngine;
        protected var markerNode : FLARBaseNode;

        protected var container : DisplayObject3D;

        private var _modelWRAP : DisplayObject3D;
        private var _hane1 : Bitmap;
        private var _hane2 : Bitmap;
        private var _lastRot : Number3D = new Number3D();
        private var loaderList : Dictionary;
        private var _loadCount : int = 0;
        //        private const loadURLArr : Array = [
        //                    "http://assets.wonderfl.net/images/related_images/a/a3/a321/a321a5037c6dbe4f496bbf4470a543190db4c840m",
        //                    "http://assets.wonderfl.net/images/related_images/0/0a/0ab3/0ab3a5daf0ce7e0df84abcfc28b7a411c2d66f28m"];
        private const loadURLArr : Array = ["http://www.romatica.com/dev/wonderfl/butterfly1.png",
"http://www.romatica.com/dev/wonderfl/butterfly2.png"];
        protected var _butt : DisplayObject3D;
        private const _stayLimit : int = 20;//蝶が飛び立つきっかけとなる目標点までの距離
        private var hane1 : Plane;
        private var hane2 : Plane;
        //認識/非認識 表示
        private var _recognizer : TextField = new TextField();

        /**
         * Constructor
         * ここから初期化処理を呼び出して処理をスタート
         */
        public function FLARToolkit_Butterfly() {
    //Wonderfl.capture_delay(16);
            // 各種サイズの初期化
            captureWidth = 320;
            captureHeight = 240;
            canvasWidth = 640
            canvasHeight = 480;
            codeWidth = 80;
            
            // パラメータファイルの読込み
            // 今回は省略して初期値を用いる
            this.cameraParam = new FLARParam();
            this.cameraParam.changeScreenSize(captureWidth, captureHeight);
            
            // マーカーパターンファイルの読込み
            markerPatternFile = 'http://assets.wonderfl.net/static/flar/flarlogo.pat';
            this.urlLoader = new URLLoader();
            this.urlLoader.dataFormat = URLLoaderDataFormat.TEXT;
            this.urlLoader.addEventListener(Event.COMPLETE, this.onLoadCode);
            this.urlLoader.addEventListener(IOErrorEvent.IO_ERROR, dispatchEvent);
            this.urlLoader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, dispatchEvent);
            this.urlLoader.load(new URLRequest(markerPatternFile));
            this.hiroCode = new FLARCode(16, 16);
            hiroCode.loadARPatt(" 234 235 240 233 240 234 240 235 240 237 240 238 240 240 240 232\r\n" + 
                                " 229 240 240 240 240 240 240 240 240 240 240 240 240 240 240 228\r\n" + 
                                " 227 240 240 240 240 240 240 240 240 240 240 240 240 240 240 239\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 236 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 234 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 236 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 231 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 229 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 225 149 240 240 186 216 225 174 240 240 240 237 238 240 240 240\r\n" + 
                                " 150 107 238 231  75 208 115 147 238 228 223 226 237 180 226 240\r\n" + 
                                " 150  62 181 213  62 187 113 169 197  72  29 237 120  50  53 207\r\n" + 
                                " 149  63  47  78  53 184 113 101 142   5 150 150  45 217 186  83\r\n" + 
                                " 121  84 220 222  58 180 121  92 128 109 237 124 155 232 161  64\r\n" + 
                                " 149  71 240 240  76 210  98 109 122 108 240 129  51 119 161 155\r\n" + 
                                " 149 186 240 240  98 219 135 152 207 191 236 227 152  77 175 209\r\n" + 
                                " 235 235 240 233 240 234 240 235 240 236 240 238 240 240 240 240\r\n" + 
                                " 229 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 227 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 236 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 234 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 236 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 232 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 229 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 225 156 240 240 186 216 225 186 240 240 240 240 240 240 240 240\r\n" + 
                                " 150 117 240 231  72 206 115 162 240 232 223 237 240 180 226 240\r\n" + 
                                " 150  74 187 213  51 184 103 168 197  78  29 237 120  50  53 216\r\n" + 
                                " 144  77  51  74  61 184 106 101 142   5 150 152  52 217 186  85\r\n" + 
                                " 117  89 219 219  65 184 121  92 128 100 236 125 156 240 170  73\r\n" + 
                                " 148  71 240 240  76 210 109 109 121  99 240 137  51 120 166 164\r\n" + 
                                " 140 186 240 240  98 220 150 156 207 192 236 230 152  77 176 212\r\n" + 
                                " 234 235 240 233 240 234 240 235 240 236 240 238 240 240 240 233\r\n" + 
                                " 229 240 240 240 240 240 240 240 240 240 240 240 240 240 240 239\r\n" + 
                                " 227 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 234 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 232 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 232 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 228 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 225 156 240 240 182 212 225 180 240 240 240 240 240 240 240 240\r\n" + 
                                " 150 116 238 228  66 205 115 151 238 236 225 240 240 180 226 240\r\n" + 
                                " 156  84 186 211  47 184 109 170 200  92  30 240 120  50  53 216\r\n" + 
                                " 147  83  51  73  50 184 106 110 148  17 151 150  45 217 186  85\r\n" + 
                                " 127  98 219 219  58 179 109 101 128 107 237 125 155 240 163  72\r\n" + 
                                " 155  86 240 240  76 201  85 108 121  95 232 137  51 118 153 155\r\n" + 
                                " 149 189 240 240  98 220 141 154 206 178 235 230 152  77 175 209\r\n" + 
                                "\r\n" + 
                                " 232 228 239 240 240 240 240 240 240 240 240 207  83  64 155 209\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 226  53 186 161 161 175\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 180  50 217 232 119  77\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 238 237 120  45 155  51 152\r\n" + 
                                " 238 240 240 240 240 240 240 240 240 237 226 237 150 124 129 227\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 223  29 150 237 240 236\r\n" + 
                                " 237 240 240 240 240 240 240 240 240 240 228  72   5 109 108 191\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 238 197 142 128 122 207\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 174 147 169 101  92 109 152\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 225 115 113 113 121  98 135\r\n" + 
                                " 234 240 240 240 240 240 240 240 240 216 208 187 184 180 210 219\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 186  75  62  53  58  76  98\r\n" + 
                                " 233 240 240 240 240 240 240 240 240 240 231 213  78 222 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 238 181  47 220 240 240\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 149 107  62  63  84  71 186\r\n" + 
                                " 234 229 227 240 236 234 236 231 229 225 150 150 149 121 149 149\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 216  85  73 164 212\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 226  53 186 170 166 176\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 180  50 217 240 120  77\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 120  52 156  51 152\r\n" + 
                                " 238 240 240 240 240 240 240 240 240 240 237 237 152 125 137 230\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 223  29 150 236 240 236\r\n" + 
                                " 236 240 240 240 240 240 240 240 240 240 232  78   5 100  99 192\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 197 142 128 121 207\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 186 162 168 101  92 109 156\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 225 115 103 106 121 109 150\r\n" + 
                                " 234 240 240 240 240 240 240 240 240 216 206 184 184 184 210 220\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 186  72  51  61  65  76  98\r\n" + 
                                " 233 240 240 240 240 240 240 240 240 240 231 213  74 219 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 187  51 219 240 240\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 156 117  74  77  89  71 186\r\n" + 
                                " 235 229 227 240 236 234 236 232 229 225 150 150 144 117 148 140\r\n" + 
                                " 233 239 240 240 240 240 240 240 240 240 240 216  85  72 155 209\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 226  53 186 163 153 175\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 180  50 217 240 118  77\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 120  45 155  51 152\r\n" + 
                                " 238 240 240 240 240 240 240 240 240 240 240 240 150 125 137 230\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 225  30 151 237 232 235\r\n" + 
                                " 236 240 240 240 240 240 240 240 240 240 236  92  17 107  95 178\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 238 200 148 128 121 206\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 180 151 170 110 101 108 154\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 225 115 109 106 109  85 141\r\n" + 
                                " 234 240 240 240 240 240 240 240 240 212 205 184 184 179 201 220\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 182  66  47  50  58  76  98\r\n" + 
                                " 233 240 240 240 240 240 240 240 240 240 228 211  73 219 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 238 186  51 219 240 240\r\n" + 
                                " 235 240 240 240 240 240 240 240 240 156 116  84  83  98  86 189\r\n" + 
                                " 234 229 227 240 234 232 235 232 228 225 150 156 147 127 155 149\r\n" + 
                                "\r\n" + 
                                " 209 175  77 152 227 236 191 207 152 135 219  98 240 240 186 149\r\n" + 
                                " 155 161 119  51 129 240 108 122 109  98 210  76 240 240  71 149\r\n" + 
                                "  64 161 232 155 124 237 109 128  92 121 180  58 222 220  84 121\r\n" + 
                                "  83 186 217  45 150 150   5 142 101 113 184  53  78  47  63 149\r\n" + 
                                " 207  53  50 120 237  29  72 197 169 113 187  62 213 181  62 150\r\n" + 
                                " 240 226 180 237 226 223 228 238 147 115 208  75 231 238 107 150\r\n" + 
                                " 240 240 240 238 237 240 240 240 174 225 216 186 240 240 149 225\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 229\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 231\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 236\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 234\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 236\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 239 240 240 240 240 240 240 240 240 240 240 240 240 240 240 227\r\n" + 
                                " 228 240 240 240 240 240 240 240 240 240 240 240 240 240 240 229\r\n" + 
                                " 232 240 240 240 238 240 237 240 235 240 234 240 233 240 235 234\r\n" + 
                                " 212 176  77 152 230 236 192 207 156 150 220  98 240 240 186 140\r\n" + 
                                " 164 166 120  51 137 240  99 121 109 109 210  76 240 240  71 148\r\n" + 
                                "  73 170 240 156 125 236 100 128  92 121 184  65 219 219  89 117\r\n" + 
                                "  85 186 217  52 152 150   5 142 101 106 184  61  74  51  77 144\r\n" + 
                                " 216  53  50 120 237  29  78 197 168 103 184  51 213 187  74 150\r\n" + 
                                " 240 226 180 240 237 223 232 240 162 115 206  72 231 240 117 150\r\n" + 
                                " 240 240 240 240 240 240 240 240 186 225 216 186 240 240 156 225\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 229\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 232\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 236\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 234\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 236\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 227\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 229\r\n" + 
                                " 240 240 240 240 238 240 236 240 235 240 234 240 233 240 235 235\r\n" + 
                                " 209 175  77 152 230 235 178 206 154 141 220  98 240 240 189 149\r\n" + 
                                " 155 153 118  51 137 232  95 121 108  85 201  76 240 240  86 155\r\n" + 
                                "  72 163 240 155 125 237 107 128 101 109 179  58 219 219  98 127\r\n" + 
                                "  85 186 217  45 150 151  17 148 110 106 184  50  73  51  83 147\r\n" + 
                                " 216  53  50 120 240  30  92 200 170 109 184  47 211 186  84 156\r\n" + 
                                " 240 226 180 240 240 225 236 238 151 115 205  66 228 238 116 150\r\n" + 
                                " 240 240 240 240 240 240 240 240 180 225 212 182 240 240 156 225\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 228\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 232\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 232\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 234\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 240 240 240 240 240 240 240 240 240 240 240 240 240 227\r\n" + 
                                " 239 240 240 240 240 240 240 240 240 240 240 240 240 240 240 229\r\n" + 
                                " 233 240 240 240 238 240 236 240 235 240 234 240 233 240 235 234\r\n" + 
                                "\r\n" + 
                                " 149 149 121 149 150 150 225 229 231 236 234 236 240 227 229 234\r\n" + 
                                " 186  71  84  63  62 107 149 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 240 240 220  47 181 238 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 222  78 213 231 240 240 240 240 240 240 240 240 240 233\r\n" + 
                                "  98  76  58  53  62  75 186 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 219 210 180 184 187 208 216 240 240 240 240 240 240 240 240 234\r\n" + 
                                " 135  98 121 113 113 115 225 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 152 109  92 101 169 147 174 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 207 122 128 142 197 238 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 191 108 109   5  72 228 240 240 240 240 240 240 240 240 240 237\r\n" + 
                                " 236 240 237 150  29 223 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 227 129 124 150 237 226 237 240 240 240 240 240 240 240 240 238\r\n" + 
                                " 152  51 155  45 120 237 238 240 240 240 240 240 240 240 240 240\r\n" + 
                                "  77 119 232 217  50 180 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 175 161 161 186  53 226 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 209 155  64  83 207 240 240 240 240 240 240 240 240 239 228 232\r\n" + 
                                " 140 148 117 144 150 150 225 229 232 236 234 236 240 227 229 235\r\n" + 
                                " 186  71  89  77  74 117 156 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 240 240 219  51 187 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 219  74 213 231 240 240 240 240 240 240 240 240 240 233\r\n" + 
                                "  98  76  65  61  51  72 186 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 220 210 184 184 184 206 216 240 240 240 240 240 240 240 240 234\r\n" + 
                                " 150 109 121 106 103 115 225 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 156 109  92 101 168 162 186 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 207 121 128 142 197 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 192  99 100   5  78 232 240 240 240 240 240 240 240 240 240 236\r\n" + 
                                " 236 240 236 150  29 223 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 230 137 125 152 237 237 240 240 240 240 240 240 240 240 240 238\r\n" + 
                                " 152  51 156  52 120 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                "  77 120 240 217  50 180 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 176 166 170 186  53 226 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 212 164  73  85 216 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 149 155 127 147 156 150 225 228 232 235 232 234 240 227 229 234\r\n" + 
                                " 189  86  98  83  84 116 156 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 240 240 219  51 186 238 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 240 240 219  73 211 228 240 240 240 240 240 240 240 240 240 233\r\n" + 
                                "  98  76  58  50  47  66 182 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 220 201 179 184 184 205 212 240 240 240 240 240 240 240 240 234\r\n" + 
                                " 141  85 109 106 109 115 225 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 154 108 101 110 170 151 180 240 240 240 240 240 240 240 240 235\r\n" + 
                                " 206 121 128 148 200 238 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 178  95 107  17  92 236 240 240 240 240 240 240 240 240 240 236\r\n" + 
                                " 235 232 237 151  30 225 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 230 137 125 150 240 240 240 240 240 240 240 240 240 240 240 238\r\n" + 
                                " 152  51 155  45 120 240 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                "  77 118 240 217  50 180 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 175 153 163 186  53 226 240 240 240 240 240 240 240 240 240 240\r\n" + 
                                " 209 155  72  85 216 240 240 240 240 240 240 240 240 240 239 233\r\n");
            
        }

        /**
         * マーカーパターンを読み込む
         * @param e Event
         */
        protected function onLoadCode(e : Event) : void {
            // URL Loader関連のイベントを削除
            this.urlLoader.removeEventListener(Event.COMPLETE, this.onLoadCode);
            
            // 分割数(縦・横)、黒枠の幅(縦・横)
            this.markerPatternCode = new FLARCode(16, 16, 50, 50);
            this.markerPatternCode.loadARPatt(this.urlLoader.data);
            this.markerPatternCode = this.hiroCode;
            // loaderがgc対象になるようにnullを突っ込む
            this.urlLoader = null;
     
            //画像読み込み
            laodImages();
        }

        //imege load start
        private function laodImages() : void {
            loaderList = new Dictionary();
            for (var i : int = 0;i < loadURLArr.length ;i++) {
                var loader : Loader = new Loader();
                loaderList[loader] = i;
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler)
                loader.load(new URLRequest(loadURLArr[i]), new LoaderContext(true));
            }
        }

        private function completeHandler(event : Event) : void {
            var loader : Loader = event.target.content.parent as Loader;
            switch(loaderList[loader]) {
                case 0:
                    _hane1 = event.target.content as Bitmap;
                    break;
                case 1:
                    _hane2 = event.target.content as Bitmap;
                    break;
                default:
            }
            _loadCount++;
            if(_loadCount >= loadURLArr.length) {
                trace("LoadComplete")
                _allLoadComplete()
            }
        }

        /**
         * 画像ロード完了
         */
        private function _allLoadComplete() : void {
            // 初期化
            onInit();
        }

        /**
         * Webカメラの設定と、ARToolKitの準備
         */
        protected function onInit() : void {
            // setup webcam
            this.webCamera = Camera.getCamera();
            if (!this.webCamera) {
                throw new Error('No webcamera!');
            }
            this.webCamera.setMode(this.captureWidth, this.captureHeight, 30);
            
            this.video = new Video(this.captureWidth, this.captureHeight);
            this.video.attachCamera(this.webCamera);
            
            // setup ARToolKit
            this.capture = new Bitmap(new BitmapData(this.captureWidth, this.captureHeight, false, 0), PixelSnapping.AUTO, true);
            // ウェブカメラの解像度と表示サイズが異なる場合は拡大する
            this.capture.width = this.canvasWidth;
            this.capture.height = this.canvasHeight;
            this.addChild(this.capture);
            
            this.raster = new FLARRgbRaster_BitmapData(this.capture.bitmapData);
            // setup Single marker detector
            this.detector = new FLARSingleMarkerDetector(this.cameraParam, this.markerPatternCode, this.codeWidth);
            this.detector.setContinueMode(true);
            
            // PV3D
            this.viewport = this.addChild(new Viewport3D(this.captureWidth, this.captureHeight)) as Viewport3D;
            this.viewport.scaleX = this.canvasWidth / this.captureWidth;
            this.viewport.scaleY = this.canvasHeight / this.captureHeight;
            this.viewport.x = -4; // なぜかずれるので補正
            this.scene = new Scene3D();
            this.markerNode = this.scene.addChild(new FLARBaseNode(FLARBaseNode.AXIS_MODE_PV3D)) as FLARBaseNode;
            this.camera3D = new FLARCamera3D(this.cameraParam);
            this.renderer = new LazyRenderEngine(this.scene, this.camera3D, this.viewport);
            this.container = new DisplayObject3D();
            // モデルデータ
            this.setModelData();
            // モデルデータを登録
            this.markerNode.addChild(this.container);
            
            
            //認識非認識チェッカー
            _recognizer = new TextField();
            _recognizer.autoSize = TextFieldAutoSize.LEFT;
            _recognizer.background = true;
            _recognizer.backgroundColor = 0xcc0000;
            addChild(_recognizer);
            
            // start
            this.start();
            //
        }

        /**
         * モデルデータ作成
         */
        protected function setModelData() : void {
            _modelWRAP = new DisplayObject3D();
            _butt = new DisplayObject3D();
            //_butt.rotationX=90;
            //            var crynder:Cylinder=new Cylinder(new WireframeMaterial(0xcc0000),)
            //            _butt.addChild(crynder)
            var h1BMM : BitmapMaterial = new BitmapMaterial(_hane1.bitmapData)
            h1BMM.oneSide = false;
            var h2BMM : BitmapMaterial = new BitmapMaterial(_hane2.bitmapData)
            h2BMM.oneSide = false;
            hane1 = new Plane(h1BMM, 43, 61, 4, 6);
            hane2 = new Plane(h2BMM, 43, 61, 4, 6);
            _butt.addChild(hane1);
            _butt.addChild(hane2);
            hane1.transformVertices(Matrix3D.translationMatrix(21.5, 0, 0));
            hane2.transformVertices(Matrix3D.translationMatrix(-21.5, 0, 0));
            scene.addChild(_butt);
            _modelWRAP.addChild(_butt);
            scene.addChild(_modelWRAP);
        }

        
        /**
         * マーカーの認識と3次元モデルの描写を開始する
         */
        public function start() : void {
            // マーカー認識・非認識時用のイベントを登録
            this.addEventListener(MarkerEvent.MARKER_ADDED, this.onMarkerAdded);
            this.addEventListener(MarkerEvent.MARKER_UPDATED, this.onMarkerUpdated);
            this.addEventListener(MarkerEvent.MARKER_REMOVED, this.onMarkerRemoved);
            
            // 処理開始
            this.addEventListener(Event.ENTER_FRAME, this.run);
        }

        /**
         * Events
         */
        protected var resultMat : FLARTransMatResult = new FLARTransMatResult();

        public function onMarkerAdded(e : Event = null) : void {
            //          trace("[add]");
            _recognizer.text = "Marca activa"
            _recognizer.backgroundColor = 0xffffff;
        }

        public function onMarkerUpdated(e : Event = null) : void {
            _recognizer.text = "Marca aun activa"
            _recognizer.backgroundColor = 0x00cc00;
        }

        public function onMarkerRemoved(e : Event = null) : void {
            _recognizer.text = "Marca no encontrada"
            _recognizer.backgroundColor = 0xcc0000;
        }

        /**
         * 蝶の動き。
         * ここで処理振り分けを行っている
         */
        private var ang : Number = 0;
        private var _r : Number = 60;
        private var _spd : Number = 60;

        public function run(e : Event) : void {
            this.capture.bitmapData.draw(this.video);
            var rad : Number = ang / 180 * Math.PI;
            var rot : Number = Math.sin(rad);
            
            // Marker detect
            var detected : Boolean = false;
            try {
                detected = this.detector.detectMarkerLite(this.raster, 80) && this.detector.getConfidence() > 0.5;
            } catch (e : Error) {
            }
            
            // when marker is being detected
            if (detected) {
                detector.getTransformMatrix(this.resultMat);
                markerNode.setTransformMatrix(this.resultMat);
                var transform : Matrix3D = markerNode.transform;
                _lastRot = Matrix3D.matrix2euler(transform);
                this.dispatchEvent(new MarkerEvent(MarkerEvent.MARKER_ADDED));
            // when marker is missed
            } else {
                this.dispatchEvent(new MarkerEvent(MarkerEvent.MARKER_REMOVED));
                markerNode.x += (rot * (Math.random() * 30 + 25));
                markerNode.y += (rot * Math.random() * 10 + 3);
                markerNode.z += (rot * (Math.random() * 10 + 10));
                if(markerNode.y>100)
                    markerNode.y-(Math.random()*10);
            }      
            // calculates the distance between the current position's marker and the actual 3d model
            var _xAbs : Number = (markerNode.x - _modelWRAP.x);
            _xAbs = (_xAbs > 0) ? _xAbs : -_xAbs;
            var _yAbs : Number = (markerNode.y - _modelWRAP.y);
            _yAbs = (_yAbs > 0) ? _yAbs : -_yAbs;
            var _zAbs : Number = (markerNode.z - _modelWRAP.z);
            _zAbs = (_zAbs > 0) ? _zAbs : -_zAbs;
            
            // adjusts the speed of the butterfly
            if((_xAbs > _stayLimit || _yAbs > _stayLimit || _zAbs > _stayLimit)) {
                _r = 60;
                ang += _spd;
                if(_butt.rotationX < 90)_butt.rotationX += 20;
                _butt.x += (rot * (Math.random() * 20));
                if(_butt.x > 10 )_butt.x = 10;
                if(_butt.x < -10 )_butt.x = -10;
                _butt.y += (rot * Math.random() * 25 + 20);
                if(_butt.y > 90 )_butt.y = 90;
                if(_butt.y < 0 )_butt.y = 0;
                _butt.z += (rot * ( Math.random() * 5 + 5));
                if(_butt.z > 20 )_butt.z = 20;
                if(_butt.z < -20 )_butt.z = -20;
            } else {
                _r = 30;
                ang += _spd / 11;
            }
            
            
            hane1.rotationY = rot * _r;
            hane2.rotationY = -(rot * _r)
                
                
            //イージング移動
            trace(rot);
            _modelWRAP.x += (markerNode.x - _modelWRAP.x) * 0.15;
            _modelWRAP.y += (markerNode.y - _modelWRAP.y) * 0.15;
            _modelWRAP.z += (markerNode.z - _modelWRAP.z) * 0.15;
            _modelWRAP.rotationX += (_lastRot.x - _modelWRAP.rotationX) * 0.1;
            _modelWRAP.rotationY += (_lastRot.y - _modelWRAP.rotationY) * 0.1;
            _modelWRAP.rotationZ += (_lastRot.z - _modelWRAP.rotationZ) * 0.1;
            //
            _butt.rotationX += (0 - _butt.rotationX) * 0.3;
            _butt.x += (0 - _butt.x) * 0.2;
            _butt.y += (0 - _butt.y) * 0.2;
            _butt.z += (0 - _butt.z) * 0.2;
            this.renderer.render();
        }
    }
}

import flash.events.Event;

/**
 * the event dispatcher
 */
class MarkerEvent extends Event {

    /**
     * On added
     */
    public static const MARKER_ADDED : String = "markerAdded";

    /**
     * On updated
     */
    public static const MARKER_UPDATED : String = "markerUpdated";

    /**
     * On missed
     */
    public static const MARKER_REMOVED : String = "markerRemoved";

    public function MarkerEvent(type : String, bubbles : Boolean = false, cancelable : Boolean = false) {
        super(type, bubbles, cancelable);
    }
}
