/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3A1u
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.KeyboardEvent;
	import flash.media.Camera;
	import flash.media.Video;

	 /**
      * author Jesse Freeman aka @theFlashBum | http://jessefreeman.com
      * 
      * This class simply takes a bitmap screen shot of from a webcam source.
      * 
      * Keyboard Short Cuts
      * 
      * Space Bar - Takes the snapshop and redraws the bitmap under the
      * video display.
      * 
      */
	public class FlashTest extends Sprite 
	{

		private var webcam:Camera;
		private var video:Video;
		private var webcamSampleBitmap:Bitmap;

		public function FlashTest()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;	
			
			webcam = Camera.getCamera( );
			webcam.setMode( 320, 240, 24 );
			video = new Video( webcam.width, webcam.height );
			video.attachCamera( webcam );
			addChild( video );
			
			webcamSampleBitmap = new Bitmap( new BitmapData( webcam.width, webcam.height, false, 0x000000 ) );
			webcamSampleBitmap.y = video.height + 2;
			addChild( webcamSampleBitmap );
			
			// KeyboardShortcuts
			addKeyboardShortcuts( );
		}

		protected function addKeyboardShortcuts():void 
		{
			stage.addEventListener( KeyboardEvent.KEY_DOWN, keyDownHandler );
		}

		protected function keyDownHandler(event:KeyboardEvent):void 
		{
			switch(event.keyCode) 
			{
				case 32:
					takeScreenShot();
					break;
			}
			
			//For debug right now
			trace( "keyDownHandler: " + event.keyCode );
		}
		
		private function takeScreenShot():void
		{
			trace("FlashTest.takeScreenShot()");
			webcamSampleBitmap.bitmapData.draw(video);
		}
	}
}