/**
 * Copyright antalg ( http://wonderfl.net/user/antalg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/39Zw
 */

package {
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.filters.ColorMatrixFilter;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            addChild(new Bitmap(_bmd));
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private const SIDE:int = 465;
        private var _bmd:BitmapData = new BitmapData(SIDE, SIDE, false, 0x000000);
        private var _dir:Vector.<int> = new Vector.<int>();
        
        private var _cmf:ColorMatrixFilter = new ColorMatrixFilter([   0,   0,   0,   0,   0,
                                                                       0,  .9,   0,   0,   0,
                                                                       0,   0,   1,   0,   0,
                                                                       0,   0,   0,  .98,   0]);
        private var _bf:BlurFilter = new BlurFilter(3, 3, 2);
        
        private function enterFrame(e:Event):void {
            renderRandom(30);
            update();
        }
        
        private function update():void {
           _bmd.applyFilter(_bmd, _bmd.rect, new Point(0,0), _cmf);
           _bmd.applyFilter(_bmd, _bmd.rect, new Point(0,0), _bf);
        }
        
        private function renderRandom(n:int):void {
            while(--n>=0) {
                var x:int = Math.random()*SIDE;
                var y:int;
                
                var b:int = 128;
                
                for(y = 0; y<SIDE; ++y) {
                    b = b+Math.random()*20-10;
                    b = b<0?0:(b>255?255:b);
                    
                    _bmd.setPixel(x, y, (b<<16)|(b<<8)|b);
                }
            }
        }
    }
}