/**
 * Copyright hacker_3sypya60 ( http://wonderfl.net/user/hacker_3sypya60 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/38bc
 */

// forked from hacker_3sypya60's forked from: flash on 2009-6-1
// forked from spikything's flash on 2009-6-1
package {
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	
	[SWF(width=700, height=700, backgroundColor=0x000000, frameRate=30)]
	public class Main extends Sprite {
		
		private var mic:Mic;
		private var view:SmokeTrailEffect;
		private var scratchPad:Shape;
		private var jitter:Number = 250;
		private var visualGain:Number = .4;
		private var colour:int = 0xFFFF999;
		private var _width:uint = 700;
		private var _height:uint = 700;
		
		public function Main ():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init (e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.quality = StageQuality.LOW;
			mic = new Mic();
			scratchPad = new Shape();
			view = new SmokeTrailEffect(scratchPad, _width, _height);
			addChild(view);
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update (e:Event):void {
			var level:Number = mic.activityLevel;
			if (level > 40 || Math.random() < .05) scratchPad.graphics.clear();
			if (level > 90) view.setupPerlinNoise();
			scratchPad.graphics.beginFill(level * colour);
			scratchPad.graphics.drawCircle(_width/2 + Math.random()*jitter - jitter/2, _height/2 + Math.random()*jitter - jitter/2, level * visualGain);
			scratchPad.graphics.endFill();
		
		}
		
	}
	
}

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.IBitmapDrawable;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BitmapFilter;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	class SmokeTrailEffect extends Sprite {
		
		private var _width:uint;
		private var _height:uint;
		private var bitmap:Bitmap;
		private var displacementMap:BitmapData;
		private var displacementMapFilter:BitmapFilter;
		private var blurFilter:BitmapFilter;
		private var source:IBitmapDrawable;
		public var shimmer:Boolean;
		
		public function SmokeTrailEffect (source:IBitmapDrawable, width:uint, height:uint) {
			this.source = source;
			_width = width;
			_height = height;
			bitmap = new Bitmap(new BitmapData(_width, _height, false, 0xffff00ff));
			addChild(bitmap);
			displacementMap = new BitmapData(_width, _height, false);
			setupPerlinNoise();
			displacementMapFilter = getDisplacementMapFilter(displacementMap, 200);
			blurFilter = new BlurFilter(20, 20);
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		public function setupPerlinNoise():void {
			addPerlinNoise(displacementMap);
		}
		
		private function addPerlinNoise (bitmapData:BitmapData):void{
			bitmapData.perlinNoise(400, 400, 2, Math.floor(Math.random() * int.MAX_VALUE), false, true, 3, false);
		}
		
		private function update (e:Event):void {
			if (shimmer) setupPerlinNoise();

			bitmap.bitmapData.draw(source);
			bitmap.bitmapData.applyFilter(bitmap.bitmapData, bitmap.getRect(this), new Point(), displacementMapFilter);
			bitmap.bitmapData.applyFilter(bitmap.bitmapData, bitmap.getRect(this), new Point(), blurFilter);
		}
		
		private function getDisplacementMapFilter (mapBitmap:BitmapData, amount:Number):BitmapFilter {
			return new DisplacementMapFilter(mapBitmap, new Point(), 1, 2, amount, amount, DisplacementMapFilterMode.CLAMP);
		}
		
	}

	import flash.media.Microphone;
	import flash.media.SoundTransform;
	import flash.system.Security;
	
	class Mic {
		
		public var mic:Microphone;
		
		public function Mic() {
			mic = Microphone.getMicrophone();
			mic.gain = 300;
		mic.rate = 100;
			mic.setLoopBack(true);
			mic.setUseEchoSuppression(true);
			mic.soundTransform = new SoundTransform(0);
		}
		
		
		
		public function get activityLevel ():Number { return mic.activityLevel };
		
	}

