/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/38NA
 */

// forked from Quasimondo's Binary Multiplication Bit Patterns
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(frameRate=30)]
    public class BinaryMultiplication extends Sprite
    {
        private var w:int  = 465;
        private var h:int  = 465;
        private var dx:int = 0;
        private var dy:int = 0;
        private var map:BitmapData = new BitmapData(w, h, false, 0x434038);
        
        public function BinaryMultiplication()
        {
            addChild(new Bitmap(map));
            addEventListener(Event.ENTER_FRAME, run);
        }
        
        private function run(e:Event):void
        {
            var binaryMap:Vector.<uint> = map.getVector(map.rect);
            for (var y:int = 0; y < 93; y++)
            {
                for (var x:int = 0; x < 93; x++)
                {
                    var value:int  = (x + dx) * (y + dy);
                    var offset:int = (x * 5 + 1) + (y * 5 + 1) * w;
                    
                    for (var i:int = 0; i < 16; i++)
                    {
                        binaryMap[offset + (i & 3) + (i >> 2) * w >> 0] = value & 1 << 15 - i ? 0xffffff : 0x000000;
                    }
                }
            }
            map.setVector(map.rect, binaryMap);
            
            dx += int(stage.mouseX / 93) - 2;
            dy += int(stage.mouseY / 93) - 2;
        }
    }
}