/**
 * Copyright Aksor.Al1 ( http://wonderfl.net/user/Aksor.Al1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/380X
 */

// forked from say0's flash on 2010-10-14
package {
    import flash.display.Sprite;
    import flash.filters.*;
    import flash.events.Event;
    import flash.events.MouseEvent; 
    import flash.media.*;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor=0x000000, width="456", height="456", frameRate="30")]
    
    public class Main extends Sprite {
        private var blockSize:int = 10;
        private var centerX:int= stage.stageWidth/2;
        private var centerY:int= stage.stageHeight/2;
        private var waveArr:ByteArray = new ByteArray();
        private var FFTArr:ByteArray = new ByteArray();
        private var URL:String = "http://scfire-dtc-aa03.stream.aol.com:80/stream/1035"
        private var urlList:Array = ["Mysound"];
        private var bm:Bitmap = new Bitmap();
        private var bmd:BitmapData;
        private var bmd2:BitmapData;
        private var rect:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);;
        private var point:Point= new Point(0,0);
        private var sp:Sprite = new Sprite();
        private var sp2:Sprite = new Sprite();
        private var colorArr:Array = [0x0000ff,0x4444ff,0x00ee00,0x80ff00,0xffff00,0xff8800,0xff0000]     
        private var filter:BlurFilter = new BlurFilter(2,2,2);
        public function Main(){
            
            init();
            playSound();
            stage.addEventListener(Event.ENTER_FRAME,hdFrame);
            stage.addEventListener(MouseEvent.CLICK,hdClick);
            addChild( new Stats() );
        }
        
        private function init():void {
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            bm = new Bitmap(bmd);
            addChild(bm);
            addChild(sp);
            sp.y=centerY
            
        }
        
        private function playSound():void{
            
            var sound:Sound = new Sound(new URLRequest(URL+urlList[0]+".mp3"),
                                        new SoundLoaderContext(1000,true));
            sound.play();
        }
        
        private function hdClick(e:MouseEvent):void{
            blockSize = 4+ Math.round(Math.random()*40);
        }

        private function hdFrame(e:Event):void{
            
            
            SoundMixer.computeSpectrum(FFTArr, true, 0);
            drawLevel(-1);
            drawLevel(1);
            filterAct();
            SoundMixer.computeSpectrum(waveArr, false, 0);
            sp.graphics.clear();
            drawWave(1);
            drawWave(3);
            
            
            
        }

        
        private function drawLevel(a:int):void {
            var fRect:Rectangle;
            var rectX:Number = centerX;
            var rectY:Number =centerY;
            var rectW:Number =blockSize*.75;
            var rectH:Number =blockSize*.75;
            var amp:Number =0;
            var temp:Number =0;
            //var rad:Number = Math.PI*2;
            var color:uint = 0x0000ff;
            var blockNum:int = centerY / blockSize * .7;
            for(var i:int=0;i<256;++i){
                temp=FFTArr.readFloat();
                amp=Math.max(temp,amp);
                if(i%blockSize==0){
                    color = colorArr[Math.round(amp * colorArr.length*.7)];
                    if(color==0xff0000) blockSize = 4+ Math.round(Math.random()*40);
                    rectX= i*a + centerX ;
                    for(var j:int=0;j<amp*blockNum;++j){
                        rectY = centerY - j * blockSize -rectH;
                        fRect= new Rectangle(rectX, rectY, rectW, rectH);
                        bmd.fillRect(fRect, color);
                        
                    }
                    
                   amp=0;
                }
                
            }
            
        }
        
        private function drawWave(a:Number =1):void{
            var maxPick:Number =stage.stageHeight/8
            var x:Number=0;
            var y:Number=maxPick*a;
            sp.graphics.lineStyle(1,colorArr[Math.round(blockSize/44*(colorArr.length-1))]);
            
            sp.graphics.moveTo(stage.stageWidth,y);
            sp.graphics.lineTo(0,y);
            for(var i:int=0;i<256;i++){
                x=i*stage.stageWidth/256;
                y=(a+waveArr.readFloat())*maxPick;
                sp.graphics.lineTo(x,y);
                //sp.graphics.beginFill(0x808080);
            }
            //sp.graphics.endFill();

        }

        
        private function filterAct():void {
            
            bmd.applyFilter(bmd, rect, point, filter);
        }
    }
}
