/**
 * Copyright dotton ( http://wonderfl.net/user/dotton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/37tO
 */

// forked from alumican_net's [Prototyping] Microphone Study #01 マイク入力の取得
package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.SampleDataEvent;
    import flash.media.Microphone;
    import flash.utils.ByteArray;
    
    /**
     * マイクからリアルタイムに波形を取得して表示する
     * 
     * @author Yukiya Okuda
     */
    public class Main extends Sprite
    {
        //----------------------------------------
        //CLASS CONSTANTS
        
        
        
        
        
        //----------------------------------------
        //VARIABLES
        
        /**
         * マイクロフォン
         */
        private var _mic:Microphone;
        
        
        
        
        
        //----------------------------------------
        //STAGE INSTANCES
        
        
        
        
        
        //----------------------------------------
        //METHODS
        
        /**
         * コンストラクタ
         */
        public function Main():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _mic = Microphone.getMicrophone();
            _mic.addEventListener(SampleDataEvent.SAMPLE_DATA, _micSampleDataHandler);
        }
        
        /**
         * マイク入力の取得
         */
        private function _micSampleDataHandler(e:SampleDataEvent):void
        {
            var sw:int = stage.stageWidth;
            var sh:int = stage.stageHeight;
            
            graphics.clear();
            graphics.lineStyle(1, 0x0, 1);
            graphics.moveTo(0, sh * 0.5);
            
            var n:int = e.data.length / 4;
            for (var i:int = 0; i < n; ++i)
            {
                var x:Number = i / n * sw;
                var y:Number = sh * 0.5 - e.data.readFloat() * 1000;
                trace(y);
                
                if (i % 2 == 0) graphics.lineTo(x, y);
            }
        }
    }
}