/**
 * Copyright yasai ( http://wonderfl.net/user/yasai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/37Q8
 */

package 
{
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.FocusEvent;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.text.TextFieldType;
	import flash.ui.Keyboard;
	
	/**
	 * 左のテキストフィールドに色を入力すると、右のテキストフィールドに
	 * 左の補色が出力されまーす
	 */
	public class Main extends Sprite 
	{
		private var color_num:Number = 0x000000;
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			var base_module:MovieClip = generateModule1(color_num);
			addChild(base_module);
			
			var target_module:MovieClip = generateModule2(color_num);
			addChild(target_module);
			target_module.x = base_module.x + base_module.width;
			
			var prev_color:Number = color_num;
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				if (prev_color == color_num) return;
				base_module.moduleFunction1(color_num);
				target_module.moduleFunction2(color_num);
				prev_color = color_num;
			});
		}
		
		private function generateModule2(color:Number, slider_bool:Boolean = false):MovieClip {
			var c:Number = -(color - 0xFFFFFF);
			var module:MovieClip = generateModule1(c);
			module.moduleFunction2 = function(_color:Number):void {
				c = -(_color - 0xFFFFFF)
				module.moduleFunction1(c);
			}
			
			return module;
		}
		
		private function generateModule1(color:Number, slider_bool:Boolean = false):MovieClip {
			var y_pos:int;
			
			var module:MovieClip = new MovieClip();
			module.graphics.beginFill(0x000000, 0);
			module.graphics.drawRect(0, 0, stage.stageWidth / 2, stage.stageHeight / 2);
			module.graphics.endFill();
			
			var color_mc:MovieClip = generateColorMc(color, module.width);
			module.addChild(color_mc);
			color_mc.x = 10;
			color_mc.y = 10;
			
			y_pos = color_mc.y + color_mc.height;
			
			var color_txt_mc:MovieClip = generateColorTxtMc(color, module.width);
			module.addChild(color_txt_mc);
			color_txt_mc.x = 10;
			color_txt_mc.y = 10 + y_pos;
			
			y_pos += color_txt_mc.y + color_txt_mc.height;
			
			if (slider_bool == true) {
				var slider_mc:MovieClip = generateSliderMc();
				module.addChild(slider_mc);
				slider_mc.x = 10;
				slider_mc.y = 10 + y_pos;
			}
			
			module.moduleFunction1 = function(_color:Number):void {
				color_mc.drawFunction(_color);
				color_txt_mc.textFunction(_color);
			}
			
			return module;
		}
		
		private function generateColorMc(color:Number, m_width:uint):MovieClip {
			var color_mc:MovieClip = new MovieClip();
			color_mc.color = color;
			color_mc.drawFunction = function(_color:Number):void {
				color_mc.graphics.clear();
				color_mc.graphics.lineStyle(1, 0x555555);
				color_mc.graphics.beginFill(_color);
				color_mc.graphics.drawRect(0, 0, m_width - 20, m_width - 20);
				color_mc.graphics.endFill();
				color_mc.color = _color;
			}
			color_mc.drawFunction(color);
			
			return color_mc;
		}
		
		private function generateColorTxtMc(color:Number, m_width:uint, input_flag:Boolean = false):MovieClip {
			var color_str:String;
			var mc:MovieClip = new MovieClip();
			var f:TextFormat = new TextFormat();
			f.align = TextFormatAlign.RIGHT;
			var text:TextField = new TextField();
			var onMouseClick:Function = function(e:MouseEvent):void {
				text.removeEventListener(MouseEvent.CLICK, arguments.callee);
				text.setSelection(0, text.length);
				text.addEventListener(FocusEvent.FOCUS_OUT, function(_e:FocusEvent):void {
					text.removeEventListener(FocusEvent.FOCUS_OUT, arguments.callee);
					text.addEventListener(MouseEvent.CLICK, onMouseClick);
				});
			};
			text.addEventListener(MouseEvent.CLICK, onMouseClick);
			text.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void {
				if (e.keyCode == Keyboard.ENTER) {
					trace("keydown");					
					color_num = Number(text.text);
					trace("cn", color_num);
				}
			});
			mc.addChild(text);
			text.defaultTextFormat = f;
			text.type = TextFieldType.INPUT;
			text.multiline = false;
			text.border = true;
			text.background = true;
			text.backgroundColor = 0xFFFFFF;
			text.width = m_width - 20;
			text.height = 20;
			
			mc.textFunction = function(_color:Number):void {
				color_str = _color.toString(16);
				while (color_str.length < 6) {
					color_str = "0" + color_str;
				}
				color_str = "0x" + color_str;
				text.text = color_str;
			}
			mc.textFunction(color);
			
			return mc;
		}
		
		private function generateSliderMc():MovieClip {
			var base_mc:MovieClip = new MovieClip();
			return base_mc;
		}
		
	}
	
}