/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/37BD
 */

package {
    import away3dlite.templates.BasicTemplate;
    import away3dlite.primitives.Cube6;
    import away3dlite.materials.BitmapFileMaterial;
    import flash.geom.*;
    import flash.events.*;
    import flash.system.*;

    public class Main extends BasicTemplate {
        private var mat:BitmapFileMaterial;
        private var obj:Cube6;

        public function Main() {}

        override protected function onInit():void {
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            mat = new BitmapFileMaterial("http://assets.wonderfl.net/images/related_images/7/76/7622/7622017e439aa9bb136d64c4f74030607c3cbcf5");
            mat.smooth = true;
            obj = new Cube6(mat, 400, 100, 400);
            scene.addChild(obj);
            addEventListener("enterFrame", onEnterFrame);
        }

        private static const SPEED:Number = 1/40;

        public function onEnterFrame(e:Event):void {
            var mp:Point = new Point(stage.stageWidth/2 - stage.mouseX, stage.stageHeight/2 - stage.mouseY);
            var angle:Number = -mp.length * SPEED;

            mp.normalize(1);
            var axis:Vector3D = new Vector3D(-mp.y, mp.x, 0);

            obj.transform.matrix3D.appendRotation(angle, axis);
        }
    }
}