/**
 * Copyright vasari ( http://wonderfl.net/user/vasari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/36M0
 */

// forked from yonatan2's forked from: forked from: flash on 2009-4-28
// forked from yonatan's forked from: flash on 2009-4-28
// forked from yonatan's flash on 2009-4-28
package {
    import flash.events.*;
    import flash.utils.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.view.*;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.geom.renderables.*;
    
    [SWF(backgroundColor="0x000000")]
    
    public class Main extends BasicView {
        private var do3d:DisplayObject3D;
        private var materials :MaterialsList;
        private var mat :FlatShadeMaterial;
        private var light:PointLight3D;
        private var updateNormals:Boolean
        private var time:uint;
        
        public function Main() {
            stage.quality = "high";
            
            light = new PointLight3D(false);
            light.x = 0;
            light.y = 0;
            light.z = -1000;

            mat = new FlatShadeMaterial(light, 0xD7261C );
            mat.fillAlpha = 0.9;
            do3d  = new Sphere( mat, 100, 45, 30 );
            scene.addChild( do3d );
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }
        
        public function onEnterFrame(e:Event): void {
            var vertices:Array = do3d.geometry.vertices;
            var x:Number, y:Number, z:Number, len:Number;

            time = getTimer();

            var i:Number = 0;
            for each( var v:Vertex3D in vertices ) {
                x = v.x; y = v.y; z = v.z;
                len = Math.sqrt(x*x+y*y+z*z) / 300 * (1.5+ Math.sin(time/1000 *  i/vertices.length*3.14));
                x /= len;
                y /= len;
                z /= len;
                v.x = x ;
                v.y = y;
                v.z = z;
                
                i++;
            }

            for each( var face:Triangle3D in do3d.geometry.faces ) {
                var fn:Number3D = new Number3D(0,0,0);
                fn.plusEq(face.v0.toNumber3D());
                fn.plusEq(face.v1.toNumber3D());
                fn.plusEq(face.v2.toNumber3D());
                fn.normalize();
                face.faceNormal = fn;
                //Tweener.addTween( face.faceNormal, {x: fn.x, y: fn.y, z: fn.z, time: 4, transition: "linear"} );
            }

            do3d.rotationY++;
            do3d.rotationX++;
            renderer.renderScene( scene, camera, viewport );
        }
    }
}