/**
 * Copyright alfonso ( http://wonderfl.net/user/alfonso )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/36K3
 */

// forked from osamX's LifeGame
// LifeQR失敗作
// ただのライフゲームです。 クリックで再生・停止。
//　http://flash-scope.com/?p=599

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	
	[SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "30")]
	public class LifeGame extends Sprite 
	{
		private const SIZE:uint = 93;
		private var field:Array = new Array(SIZE * SIZE);
		private var bmd:BitmapData;
		private var rect:Rectangle;
		private var cTraR:ColorTransform;
		private var cTraG:ColorTransform;
		private var cTraB:ColorTransform;
		private var play:Boolean = true;
		private var lastplay:Boolean = true;
		private var delay:uint = 0;
		
		public function LifeGame():void 
		{
			rect = new Rectangle(0, 0, SIZE, SIZE);
			cTraR = new ColorTransform(1, 1, 1, 1, 32, 16, 16);
			cTraG = new ColorTransform(1, 1, 1, 1, 16, 32, 16);
			cTraB = new ColorTransform(1, 1, 1, 1, 16, 16, 32);
			bmd = new BitmapData(SIZE, SIZE, false, 0xFF00FF);
			initField();
			var bmp:Bitmap = new Bitmap(bmd);
			bmp.width *= 5;
			bmp.height *= 5;
			addChild(bmp);
			addEventListener(Event.ENTER_FRAME, refreshField);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function initField():void 
		{
			bmd.lock();
			for (var i:uint = 0; i < SIZE * SIZE; i++ ) {
				var y:uint = uint(i / SIZE);
				var x:uint = i - y * SIZE;
				var rand:Number = Math.random() * 1;
				
				if (rand >= 0.8) {
					field[i] = true;
					bmd.setPixel(x, y, 0x000000);
				}
				else {
					field[i] = false;
				}
			}
			bmd.unlock();
		}
		
		private function onClick(event:MouseEvent):void
		{
			
               initField()
		}
		
		private function refreshField(event:Event):void
		{
			if(delay < 17){
				var tmp:Array = new Array(SIZE * SIZE);
				for (var j:uint = 0; j < SIZE * SIZE; j++ ) {
					tmp[j] = field[j];
				}
				
				bmd.lock();
				switch(int(Math.random()*3)) {
					case 0:
						bmd.colorTransform(rect, cTraR);
						break;
					case 1:
						bmd.colorTransform(rect, cTraG);
						break;
					case 2:
						bmd.colorTransform(rect, cTraB);
						break;
				}
				
				if (play) {
					for ( var i:uint = 0; i < SIZE * SIZE; i++ ) {
						var neighbors:uint = 0;
						var y:uint = uint(i / SIZE);
						var x:uint = i - y * SIZE;
						
						for (var oy:int = -1; oy < 2; oy++ ) {
							for (var ox:int = -1; ox < 2; ox++) {
								if (getField(x + ox, y + oy)) neighbors++;
							}
						}
						
						if (neighbors == 6 ||neighbors == 3 ||neighbors == 7 ||
							(field[i] && ( neighbors == 3|| neighbors == 2))) {
							tmp[i] = true;
						}
						else {
							tmp[i] = false;
						}
						
					}
				}
				else {
					delay++;
				}
					
				for ( i = 0; i < SIZE * SIZE; i++ ) {
					field[i] = tmp[i];
					y = uint(i / SIZE);
					x = i - y * SIZE;
					if (field[i]) bmd.setPixel(x, y, 0x000000);
				}
				
				bmd.unlock();
				lastplay = play;
			}
		}
		
		private function getField(x:int, y:int):Boolean
		{
			var tx:uint = x;
			var ty:uint = y;
			if (x == -1) tx += SIZE;
			else if (x == SIZE) tx -= SIZE;
			if (y == -1) ty += SIZE;
			else if (y == SIZE) ty -= SIZE;
			return field[x + y * SIZE];
		}
		
	}
	
}