/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/35xl
 */

//youtube プレイヤー

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
    import flash.ui.*;
    public class FlashTest extends Sprite {
        
        private var loader:TubeLoader;
        private var player:TubePlayer = new TubePlayer();
        private var t3:TextField = new TextField();
        private var t2:TextField = new TextField();
        private var scrY:int=0;
        private var s1:Sprite =new Sprite();
        
        
        private var save:TubeMylist = new TubeMylist();
        

        
        public function FlashTest(){
            loader = new TubeLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            //addChild(t3);
            //addChild(player);
            t3.height=300;
            t3.width = 400;
            t3.y =30;
            t3.x = 350;
            addChild(s1);
            t2.border = true;
            t2.type ="input";
            t2.text = "MMDPV";
            //t2.height = 20;
            //t2.width = 120;
            t2.x = 322;
            t2.y = 20;
            //t2.background =true;
            //t2.backgroundColor = 0xdddddd;
            t2.height = t2.textHeight+5;
            addChild(t2);
            
            var t4:TextField = new TextField();
            //t4.border = true;
            t4.text = "search";
            t4.selectable=false;
            t4.background =true;
            t4.backgroundColor = 0x55ddff;
            t4.addEventListener(MouseEvent.MOUSE_OVER,function():void{
                Mouse.cursor = MouseCursor.BUTTON;
            });
            t4.addEventListener(MouseEvent.MOUSE_OUT,function():void{
                Mouse.cursor = MouseCursor.AUTO;
            });

            t4.addEventListener(MouseEvent.CLICK,function():void{
                loader.requestWords(t2.text);
            });

            t4.x = t2.x+t2.width+3;
            t4.y = t2.y;
            t4.width = t4.textWidth+5;
            t4.height = t2.height;
            addChild(t4);
            
            t2.addEventListener(KeyboardEvent.KEY_UP,onKey);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey2);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);
            //loadMylist();
            
            addChild(player);
            
            addChild(seekBar); 
            seekBar.y=300;
            //seekBar.setColor(0xff0000,0x000000);
            seekBar.value = 0.5;
            seekBar.addEventListener(MouseEvent.MOUSE_UP,function():void{
                player.seek = seekBar.value;
            });

        }
        
        private var seekBar:SeekBar = new SeekBar();        
        
        private function onFrame(e:Event):void{
            var seek:Number = player.seekTime;//先頭からの経過時間
            var seekEnd:Number = player.seekEnd;
            seekBar.length = seekEnd;
            if(seekEnd==0)return;
            seekBar.value = seek;//(seek / seekEnd);//再生進捗率更新
            
        }
        
        private function onWheel(e:MouseEvent):void{
            var scr:int = e.delta*5;
            s1.y += scr;
            scrY += scr;
                if(scrY<200){
                    loader.requestWords(t2.text);
                }
        }

        
        private function onKey(e:KeyboardEvent):void{
            if(e.keyCode == 13){
                loader.requestWords(t2.text);
            }
        }
        private function onKey2(e:KeyboardEvent):void{
            if(e.keyCode==40){
                s1.y-=20;
                scrY-=20;
                if(scrY<200){
                    loader.requestWords(t2.text);
                }

            }
            if(e.keyCode==38){
                s1.y+=20;
                scrY+=20;
            }
            
            t3.text = scrY.toString();


        } 
         
        private var lastY:int=0;
        private var listCnt:int=0;
        private function onComplete(e:Event):void{            
            //t.text = "";
            if(loader.idList.length<listCnt){
                while(0<s1.numChildren)s1.removeChildAt(0);
                lastY=0;
                listCnt=0;
                scrY=0;
                s1.y=300;
            } 

            for(var i:int=listCnt;i<loader.idList.length;i++){ 
                var s:Sprite = createThumb(i);
                s1.addChild(s);
                s.y = lastY;
                lastY += 100;
                
            }
            var t:TextField = new TextField();
            //t = new TextField();
            t.text = loader.idList.length.toString();
            t.height = 20;
            t.y = lastY;
            s1.addChild(t);
            
            lastY+=20;
            scrY = lastY+s1.y-400;
            listCnt = loader.idList.length;
            //t.text+="\n";
            //t.scrollV = t.maxScrollV;
            //t.text += loader._xml;
            
            
        }
        
        //サムネイル作成
        private function createThumb(num:int):Sprite{
            var id:String = loader.idList[num].toString();
            
            var s:Sprite = loader.getImage(id);
            s.addEventListener(MouseEvent.CLICK,onClick);
            s.name = id;
            s.buttonMode = true;
            
            var result:Sprite = new Sprite();
            result.addChild(s);//loader.getImage(id);
            
            var t:TextField = new TextField();
            var str:String = new String();
            str+=loader.titleList[num]+"\n";
            str+= "投稿者:"+loader.authorList[num]+"\n";
            var n:int = loader.durationList[num];
            var h:int = n/3600;
            var min:int = (n/60)%60;
            var sec:int = n%60;
            if(0<h)str+=h.toString()+":";
            str+= min.toString()+":"+sec.toString()+"\n";
            //str+=loader.idList[i].toString()+"\n";
            t.text = str;
            
            t.width=t.textWidth+5;
            t.height=t.textHeight+5;
            t.selectable=false;
            t.x = 130;
            result.addChild(t);
            return result;
        }

        
        private function loadMylist():void{
            var list:Array = save.mylist(); 
            for(var i:int=0;i<list.length;i++){
                var t:TextField = new TextField();
                t.border=true;
                t.text = list[i].toString();
                t.width=t.textWidth+5;
                t.height=t.textHeight+5;
                t.selectable=false;
                t.y=lastY;
                s1.addChild(t);
                lastY+=t.height;
                t.addEventListener(MouseEvent.CLICK,onClick);
                t.name = list[i].toString();
            }
            listCnt = s1.numChildren;

        }
        
        
        private function onClick(e:MouseEvent):void{ 
            var id:String = e.currentTarget.name;
            //var yp2:YoutubePlayer = new YoutubePlayer();
            //yp2.resize(e.currentTarget.width,e.currentTarget.height);
            //e.currentTarget.addChild(yp2);
            //chat.player.play(id);
            player.play(id);
            //save.add(id);
            addEventListener(Event.ENTER_FRAME,onFrame);
        }

    }
}




//シークバー
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.text.*;
    import flash.geom.*;
    class SeekBar extends Sprite{
        private var thumb:Sprite=new Sprite();
     
        private var _width:Number = 300;
        private var _height:Number = 20;
        private var _value:Number = 1.0;
        private var color1:uint = 0x44aaff;
        private var color2:uint = 0x223388;//青
        private var color3:uint = 0xff0000;//シークポイント
        private var isSlide:Boolean;
        private var isOver:Boolean;
        private var _length:Number = 1.0;
        private var info:InfoLabel = new InfoLabel();
        public function SeekBar(){
            init();
            this.mouseChildren = false;
        }
        private function init():void{
            draw();
            this.addEventListener(MouseEvent.MOUSE_OVER,onMouse);
            this.addEventListener(MouseEvent.MOUSE_OUT,outMouse);
            this.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            this.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        }

        
        public function setSize(w:Number=300,h:Number=20):void{
            _width = w;
            _height= h;
            draw(_value);
        }
        public function setColor(c1:uint,c2:uint=0x333333,c3:uint=0xff0000):void{
            color1 = c1;
            color2 = c2;
            color3 = c3;
            draw(_value);
        }
        
        public function set length(n:Number):void{
            _length=n;
            _value = 0;
            draw(_value);
        }

        public function get length():Number{
            return _length;
        }


        
        public function set value(n:Number):void{
            if(isSlide)return;
            _value=n;
            if(n<0)_value=0;
            if(_length<n)_value=_length;
            draw(_value);
        }
        
        public function get value():Number{
            return _value;
        }
        

        //シークバー描画
        private function draw(n:Number=0):void{
            
            var p:Number=n;
            if(p<0)p=0;
            if(_length<p)p=_length;
            var par:Number = p/_length;
            
            with(this.graphics){
                clear();
                
                beginFill(color1,0);
                drawRect(-30,-20,_width+60,_height+40);
                endFill();
                
                beginFill(color1);
                drawRect(0,0,_width,_height);
                endFill();
                
                beginFill(color2);
                //drawRect(0,0,seekWidth*par,10);
                drawRect(_width*par,0,_width*(1.0-par),_height);
                endFill();
                
            }
        }
        
        //シークポイントの描画
        private function draw2():void{
            var sx:Number = this.mouseX;
            if(sx<0)sx=0;
            if(_width<sx)sx=_width;
            var t:Number = _length * (sx/_width);
            var s:int = Math.floor(t%60);
            var m:int = Math.floor((t/60)%60);
            var h:int = Math.floor(t/3600);
            var str:String = new String();
            if(3600<_length)str += h.toString()+":";
            if(60<_length)str += m.toString()+":";
            str += s.toString();
            
            info.text =str;
            info.x = sx;
            with(this.graphics){
                //clear();
                beginFill(color3);
                //drawRect(_width*par,-10,2,30);
                drawRect(sx,0,3,_height);
                endFill();
            }
        }

        
        //シーク
        private function onDown(e:MouseEvent):void{
            this.addEventListener(MouseEvent.MOUSE_UP, onUp, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp, false, 0, true);
            stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        
            value = _length * (this.mouseX/_width);
            isSlide=true;
            //this.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        }
        private function onUp(e:MouseEvent):void{
            var e2:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
            dispatchEvent(e2);
            this.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            isSlide=false;
            //this.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
        }
        private function leave(e:Event):void {
            //thumb.stopDrag();
            //checkValue();
            var e2:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
            dispatchEvent(e2);
            this.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            //isSlide=false;
        }
        private function onMove(e:MouseEvent):void{
            if(isSlide)_value = _length * (this.mouseX/_width);
            draw(_value);
            draw2();
        }



        
        private function onMouse(e:MouseEvent):void{
            Mouse.cursor = MouseCursor.BUTTON;
            isOver=true;
            this.addChild(info);
        }
        private function outMouse(e:MouseEvent):void{ 
            
            Mouse.cursor = MouseCursor.AUTO;
            isOver=false;
            draw(_value);
            this.removeChild(info);
        }


    }

//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}




//////////////////////////////////////////////////
//  吹出し
//////////////////////////////////////////////////

import flash.text.*;
import flash.display.*;
class InfoLabel extends Sprite{
    private var _text:String ="";
    public function InfoLabel(str:String=""){
        _text = str;
        this.mouseEnabled = this.mouseChildren = false;
        draw();
    }
    public function set text(str:String):void{
        _text = str;
        draw();
    }

    //描画
    private function draw():void{
        while(0<this.numChildren)this.removeChildAt(0);
        var tf:TextField = new TextField();
        tf = new TextField();
        tf.selectable = false;
        tf.text = _text;
        tf.width = tf.textWidth+5;
        tf.height = tf.textHeight+5;
        
        var c:uint = 0xdddddd;     
        var x1:Number= tf.width/2;
        var y1:Number= tf.height+15;
        var x2:Number= x1-5;
        var x3:Number= x1+5;
        var y2:Number= tf.height+5;
        
        
        var s:Sprite = new Sprite();
        with(s.graphics){
            clear();
            beginFill(c);
            drawRoundRect(-10,-5,tf.width+20,tf.height+10,10,10);

            endFill();
            beginFill(c);
            moveTo(x2,y2);
            lineTo(x3,y2)
            lineTo(x1,y1);
            lineTo(x2,y2);
            endFill();
        }
        s.addChild(tf);
        s.x = -x1;
        s.y = -y1;
        s.alpha = 0.8;
        this.addChild(s);
        
    }
}







//ブックマーク登録
//id title author time 
class TubeMylist{
    private var so:SharedObject;
    
    public function TubeMylist():void{
        so = SharedObject.getLocal("tubeMylist");
    }
    
    public function mylist():Array{ 
        var list:Array = new Array();
        if(so){ 
            var obj:Object = so.data;
            for(var str:String in obj){
                list.push(str);
            }
        }
        return list;
    }
        public function add(id:String,title:String=""):void{
            var obj:Object = so.data;
            var n:String="";
            if(obj.hasOwnProperty(id) == false) obj[id] = n; 
        }
        public function remove(id:String):void{ 
            var obj:Object = so.data;
            if(obj.hasOwnProperty(id) == true) obj[id] = null;
        }
}



import flash.text.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.utils.*;
import flash.system.*;
class TubeLoader extends Sprite{

        //動画ID取得
        //投稿者取得
        //動画タイトル取得
        //再生時間取得
        
        //キーワード検索
        //投稿者検索
        
        private var loader:URLLoader;
        public var idList:Array;
        public var titleList:Array;
        public var authorList:Array;
        public var durationList:Array;
        private var _words:String = "";//前回の検索ワード
        private var cnt:int=0;//リクエスト回数
        private var _results:int = 20;
        
        public function TubeLoader() {
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
        }
        
        public function clear():void{
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
            cnt=0;
        }
        
        public function set results(n:int):void{
            _results = n;
            clear();
        }
        
        public function requestWords(key:String):void{            
            //var str:String = "http://gdata.youtube.com/feeds/api/videos/-/";
            var str:String = "http://gdata.youtube.com/feeds/api/videos?"
            if(_words != key){ 
                _words = key;
                clear();
            }
            str += "q="+escapeMultiByte(_words);//検索ワード
            //str += escapeMultiByte(_words)+"?";//検索ワード
            str += "&max-results="+_results.toString();//件数
            str += "&start-index="+(cnt*_results+1).toString();//インデックス
            str += "&v=2";
            //var loader:URLLoader = new URLLoader();
            
            loader = new URLLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            var url:URLRequest = new URLRequest(str);
            loader.load(url);
            cnt++;
        }
        
        public function getImage(id:String,num:int=1):Sprite{
            var loader:Loader;
            loader = new Loader();
            //const req:String = "http://www.ozworks.dip.jp/img/01/1426006.png";
            const str1:String = "http://i.ytimg.com/vi/";
            const str3:String = "/default.jpg";
            const str4:String = "/0.jpg";
            var req2:String;
            switch(num){
                case 0:
                    req2 = str1+id+str4;
                    break;
                case 1:
                    req2 = str1+id+"/default.jpg";
                    break;
                
            }

            
            loader.load(new URLRequest(req2));//youtubeプレイヤー読み込み
            var s:Sprite = new Sprite();
            s.addChild(loader);
            return s;
        }


        
        public var _xml:String;
        private function onComplete(e:Event):void{
            loader.removeEventListener(Event.COMPLETE,onComplete);
            var res:XML = new XML(e.target.data);
            var list:XMLList = res.children();
            //var str:String = "";
            var cnt:int=0;
            
            for(var i:int=0;i<list.length();i++){
                if(list[i].localName()!="entry")continue;
                var list3:XMLList = list[i].elements();
                for(var j:int=0;j<list3.length();j++){
                    if(list3[j].localName()=="title"){ //タイトル抽出
                        //str += list3[j].text()+"\n";
                        var title:String = new String();
                        title += list3[j].text();
                        titleList.push(title);
                    }
                    else if(list3[j].localName()=="id"){ //ID抽出
                        var str3:String = list3[j].text();
                        var n:int = str3.indexOf("video:")+6;
                        //var n:int = str3.indexOf("videos/")+7;
                        var id:String = str3.substring(n);
                        //str += id+"\n";
                        idList.push(id);
                    }
                    else if(list3[j].localName()=="author"){//投稿者名
                        var str4:String;
                        var list2:XMLList = list3[j].elements();
                        str4 = list2[0].text();
                        authorList.push(str4);
                    }    
                    else if(list3[j].localName()=="group"){//再生時間
                        var str5:String = list3[j].toXMLString();
                        var n2:int = str5.indexOf('duration="')+10;
                        var n3:int = str5.indexOf('"',n2);
                        var n4:int = parseInt(str5.substring(n2,n3));
                        durationList.push(n4);
                    }//*/
                    
                }

                //str += list3.elements("id").toXMLString()+"\n\n";
                //str += i.toString()+" "+list[i].localName()+"\n";
                //str += list[i].toXMLString()+"\n\n";
                //str += "\n";
                _xml = res.toXMLString();
            }
            
            //コンプリートイベント発行
            var event:Event = new Event(Event.COMPLETE);
            this.dispatchEvent(event);
        }
    }
//}

 

import flash.display.*;
import flash.net.*;
import flash.system.*;
import flash.events.*;
import flash.text.*;
class TubePlayer extends Sprite{
    
    private var WIDTH:int = 320;
    private var HEIGHT:int= 240;
    private var player:Object;
    //private var players:Array;
    private var _state:int = -1;//プレイヤー状態
    private var txt:TextField;
    public function TubePlayer():void{
        var loader:Loader;
            loader = new Loader();
            Security.loadPolicyFile('http://www.youtube.com/crossdomain.xml');            
            loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
            const req:String = "http://www.youtube.com/apiplayer?enablejsapi=1&version=3";
            loader.load(new URLRequest(req));//youtubeプレイヤー読み込み
            
            txt = new TextField();
            txt.textColor = 0x00ff00;
            
    }
    
    public function resize(w:int,h:int):void{
        WIDTH = w;
        HEIGHT = h;
        if(player != null){
            player.setSize(WIDTH, HEIGHT);//サイズ
        }
    }

   
    //ローダー初期化
        private function onLoaderInit(e:Event):void{
            var loader:Loader = e.currentTarget.loader;
            loader.content.addEventListener("onReady", onPlayerReady);
            loader.content.addEventListener("onStateChange",onChangeState);
            addChild(loader);
            //addChild(txt);
        }
        public function load(id:String):void{
            player.clearVideo();
            player.cueVideoById(id);//動画ID
            txt.appendText(id);
        }
        
        public function play(id:String=null):void{
            if(id!=null)load(id);
            player.playVideo();//再生
        }
        
        public function pause():void{
            player.pauseVideo();
        }
        
        public function stop():void{
            player.clearVideo();
        }

        public function get seekTime():Number{
            return player.getCurrentTime();
        }
        
        public function set seek(time:Number):void{
            player.seekTo(time);
        }
        
        public function get seekEnd():Number{
            return player.getDuration();
        }
        
        public function get state():int{
            return _state;
        }




        //プレイヤー設定
        private function onPlayerReady(e:Event):void{
            player = e.currentTarget;
            player.setSize(WIDTH, HEIGHT);//サイズ
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,WIDTH,HEIGHT);
            graphics.endFill();
        }
        
        //動画ステータス変化
        private function onChangeState(e:Event):void{            
            _state = player.getPlayerState()
            txt.appendText(_state.toString()+":");
          //動画終了
            if(state == 0){   
                txt.appendText("stop");         
            }
            else if(_state == 1){
                txt.appendText("play");
            }
            else if(_state == 2){
                txt.appendText("pause");
            }
            //バッファリング中
            else if(_state == 3){
                txt.appendText("loading.....");
            }

            else if(_state == 5){//頭出し済み  
                txt.appendText("loading.....");
            }  
            txt.appendText("\n");
            txt.scrollV = txt.maxScrollV;
        }
}//class
//}//package



