/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/35ti
 */

// forked from kazy's SPRING TO MOUSE
package
{
	/**
	 * 重力消しただけです
	 */
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * Main
	 * メインクラス.
	 */
	public class Main extends Sprite
	{
		private var ball:Ball;
		private var spring:Number = 0.1;
		private var targetX:Number = stage.stageWidth / 2;
		private var targetY:Number = stage.stageHeight / 2;
		private var vx:Number = 0;
		private var vy:Number = 0;
		private var friction:Number = 0.95;
		private var gravity:Number = 15;
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void
		{
			ball = new Ball();
			addChild(ball);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
			var dx:Number = mouseX - ball.x;
			var dy:Number = mouseY - ball.y;
			var ax:Number = dx * spring;
			var ay:Number = dy * spring;
			//バネ
			vx += ax;
			vy += ay;
			//重力っぽく
			//vy += gravity;
			//減速
			vx *= friction;
			vy *= friction;
			//ボールの座標に適応
			ball.x += vx;
			ball.y += vy;
			//ラインを描く
			graphics.clear();
			graphics.lineStyle(1);
			graphics.moveTo(ball.x, ball.y);
			graphics.lineTo(mouseX, mouseY);
		}
	}
}

/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}