/**
 * Copyright h_sakurai ( http://wonderfl.net/user/h_sakurai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/35sg
 */

// forked from ogies's Flash純正3Dでboxを作ってみた
package 
{
    import flash.display.GradientType;
    import flash.display.LineScaleMode;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    
    /**
     * ...
     * @author ...
     */
    [SWF(frameRate="30", width="465", height="465")]
    public class MyBox extends Sprite
    {
        
        public var view:Sprite;
        
        public var pp:PerspectiveProjection;
        
        public function MyBox() 
        {
            view = new Sprite();
            
            pp = root.transform.perspectiveProjection;// パースペクティブプロジェクション
            pp.projectionCenter = new Point( stage.stageWidth / 2 , stage.stageHeight / 2 );// 中心を画面の中心に
            rotationX = 60;        
            view.x = stage.stageWidth / 2;
            view.y = stage.stageHeight / 2;
            
            for ( var i:uint = 0 ; i < 10 ; i++  ) {
                var box0:Sprite = new Box();
                box0.x = i * 20 - 230;
                box0.y =  50;
                box0.z = i * 50 - 200;
                view.addChild( box0 );
            
            }
            addChild( view );
        }
        
    }
    
}

import flash.display.GradientType;
import flash.display.LineScaleMode;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix3D;
import flash.geom.PerspectiveProjection;
import flash.geom.Point;

class Box extends Sprite {
    
    public var renders:Array;
    
    public function Box( _length:Number = 35 ) {
        
        renders = new Array();
        
        this.z = 0;
        
        for ( var i:uint = 0 ; i < 4 ; i++  ) {
            
            var child:Sprite = new Sprite();
            child.graphics.beginGradientFill( GradientType.RADIAL , [ 0xffffff, 0x999999
            ] , [ 1 , 1 ] , [ 32 , 200 ] );
            child.graphics.lineStyle( 0.1, 0xcccccc , 0.5 , false );
            child.graphics.drawRect(-_length/2, -_length/2, _length, _length);
            child.z = _length/2;
            
            var main:Sprite = new Sprite();
            main.addChild( child );
            main.z = 0;
            
            main.rotationY = 90 * i;
            
            addChild( main );
            renders.push( child );
        }
        
        addEventListener( Event.ENTER_FRAME , render );
    }
    
    public function render( ev:Event = null ):void {
        rotationY += 5;
        renders.sort( order , Array.NUMERIC | Array.DESCENDING );
        renders.forEach(
            function( item:* , index:uint , arr:Array ):void {
                addChild( item.parent );
            }
        );
    }
    
    public function order( a:Sprite , b:Sprite ):Number {
        
        var mtxA:Matrix3D = a.transform.getRelativeMatrix3D( root );
        var mtxB:Matrix3D = b.transform.getRelativeMatrix3D( root );
        
        if ( mtxA.position.z < mtxB.position.z ) {
            return -1;
        } else if ( mtxA.position.z > mtxB.position.z ) {
            return 1;
        } else {
            return 0;
        }
    }
    
}
