/**
 * Copyright wwbeyondww1 ( http://wonderfl.net/user/wwbeyondww1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/35Zf
 */

// forked from h6k's ライツアウト
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    public class FlashTest extends Sprite {
        private var pos:Array = new Array(5);
        private var sw:int = stage.stageWidth;    // 全体サイズ
        private var sh:int = stage.stageHeight;
        private var fw:int = sw / 6 * 5;            // マスサイズ
        private var fh:int = sh / 6 * 5;
        private var ofx:int = (sw - fw) / 2;        // オフセット
        private var ofy:int = (sh - fh) / 2;
        
        private var sp:Sprite = new Sprite();
        private var fld:TextField = new TextField();
        private var btn:Sprite = new Sprite();
        
        public function FlashTest() {
            // write as3 code here..
            // 配列初期化
            for (var X:int = 0; X < 5; X++) {
                pos[X] = [false, false, false, false, false];
            }
            loadStage();
        }
        
        // 配列から描画
        private function repaint():Boolean {
            var col:uint;
            var clear:Boolean = true;
            for (var X:int = 0; X < pos.length; X++) {
                for (var Y:int = 0; Y < pos[X].length; Y++) {
                    if (pos[X][Y]) {
                        col = 0xFF00FF;
                        clear = false;
                    } else {
                        col = 0;
                    }
                    var matrix:Matrix = new Matrix();
                    matrix.createGradientBox(fw / 5, fh / 5, Math.PI, fw / 5 * X + ofx, fh / 5 * Y + ofy);
                    sp.graphics.beginGradientFill("radial", [col, 0], [1, 1], [0, 255], matrix);
                    sp.graphics.drawRect(fw / 5 * X + 1 + ofx, fh / 5 * Y + 1 + ofy, fw / 5 - 2, fh / 5 - 2);
                    sp.graphics.endFill();
                }
            }
            return clear;
        }
        
        // ステージ作成
        private function loadStage():void {
            addChild(sp);
            sp.graphics.beginFill(0, 1);
            sp.graphics.drawRect(0, 0, sw, sh);
            sp.graphics.endFill();
            sp.graphics.beginFill(0x999999, 1);
            sp.graphics.drawRect(ofx, ofy, fw, fh);
            sp.graphics.endFill();
            repaint();
            
            addChild(fld);
            fld.textColor = 0x999999;
            fld.x = ofx;
            fld.y = fh + ofy + 10;
            fld.width = fw;
            fld.border = true;
            fld.borderColor = 0x999999;
            fld.mouseEnabled = false;
            fld.autoSize = TextFieldAutoSize.CENTER;
            fld.text = "- PLAY! -";
            
            addChild(btn);
            btn.addChild(fld);
            btn.addEventListener(MouseEvent.CLICK, GameStart);
        }
        
        // ゲームスタート
        private function GameStart(e:MouseEvent):void {
            // 配置
            for (var X:int = 0; X < 5; X++) {
                for (var Y:int = 0; Y < 5; Y++) {
                    var r:int = Math.random() * 100;
                    if (r % 2 == 0) {
                        reposition(X, Y);
                    }
                }
            }
            repaint();
            
            // クリックイベント
            fld.text = "- GIVE UP -";
            btn.removeEventListener(MouseEvent.CLICK, arguments.callee);
            btn.addEventListener(MouseEvent.CLICK, allClear);
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);
        }
        
        // クリック
        private function onMouseClick(e:MouseEvent):void {
            var X:int = -1;
            var Y:int = -1;
            var i:int;
            
            // クリックした座標取得
            for (i = 0; i <= 5; i++) {
                if (mouseX < fw / 5 * i + ofx) {
                    X = i - 1;
                    break;
                }
            }
            for (i = 0; i <= 5; i++) {
                if (mouseY < fh / 5 * i + ofy) {
                    Y = i - 1;
                    break;
                }
            }
            if (X >= 0 && Y >= 0) {
                reposition(X, Y);
                if (repaint()) {
                    // クリア
                    fld.text = "CONGRATULATIONS! b(^_-)";
                    stage.removeEventListener(MouseEvent.CLICK, arguments.callee);
                    btn.addEventListener(MouseEvent.CLICK, allClear);
                }
            }
        }
        
        // 配列更新
        private function reposition(X:int, Y:int):void {
            // 押した場所
            pos[X][Y] = !pos[X][Y];
            // 上
            if (Y - 1 >= 0) {
                pos[X][Y - 1] = !pos[X][Y - 1];
            }
            // 右
            if (X + 1 < 5) {
                pos[X + 1][Y] = !pos[X + 1][Y];
            }
            // 下
            if (Y + 1 < 5) {
                pos[X][Y + 1] = !pos[X][Y + 1];
            }
            // 左
            if (X - 1 >= 0) {
                pos[X - 1][Y] = !pos[X - 1][Y];
            }
        }
        
        // 初期化
        private function allClear(e:MouseEvent):void {
            for (var X:int = 0; X < 5; X++) {
                pos[X] = [false, false, false, false, false];
            }
            repaint();
            
            // クリックイベント
            fld.text = "- PLAY! -";
            btn.removeEventListener(MouseEvent.CLICK, arguments.callee);
            btn.addEventListener(MouseEvent.CLICK, GameStart);
        }
    }
}