/**
 * Copyright 5parrowhawk ( http://wonderfl.net/user/5parrowhawk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/35TV
 */

// forked from 5parrowhawk's パーティクル崩し Rev. G
// forked from 5parrowhawk's パーティクル崩し ブラックレーベル
// forked from 5parrowhawk's forked from: パーティクル崩し
// forked from coppieee's パーティクル崩し
//コードはめっちゃ汚いよ！
//ブロックの数465*100
//がんばってクリアしてください
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", frameRate = "30")]
    public class BlockBreaker extends Sprite 
    {
        private static const HEIGHT:Number = 465;
        private static const WIDTH:Number = 465;
        private static const BLOCKWIDTH:Number = 200;
        private static const ELECHEIGHT:Number = 100;
        private static const MAGHEIGHT:Number = 120;
        private var _canvas:BitmapData;
        private var _fallBlocks:Vector.<Particle>;
        private var _balls:Vector.<Particle>;
        
        private var _magnetUpper: Bitmap;
        private var _magnetLower: Bitmap;
        private var _elecField: Bitmap;
        
        private var _elecBmpPlus:BitmapData;
        private var _elecBmpMinus:BitmapData;
        
        private var _elecAccel: Number = -0.06; //this is the acceleration imparted by the electric field
        private var _elecPeriod: Number = 1.195; //this is the period between electric field switching

        private var _magAccel: Number = 0.09; //this is the acceleration imparted by the magnetic field
        
        private var _elecTimer: Number;
        
        public function BlockBreaker()
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown); 
            
            _elecTimer = _elecPeriod * 0.55;
            
            _canvas = new BitmapData(WIDTH, HEIGHT,false,0x000000);
            addChild(new Bitmap(_canvas));
                        
            _fallBlocks = new Vector.<Particle>();
            
            var b:BitmapData = new BitmapData(4, 4, false, 0x00FF00);
            var c:BitmapData = new BitmapData(100, 100, true, 0x3000FF00);

            var magnetLowerBmp:BitmapData = new BitmapData(BLOCKWIDTH, MAGHEIGHT, true, 0x30FF00FF);
            var magnetUpperBmp:BitmapData = new BitmapData(BLOCKWIDTH+40, MAGHEIGHT, true, 0x30FF00FF);
            _elecBmpPlus = new BitmapData(BLOCKWIDTH, ELECHEIGHT, true, 0x30FF0000);
            _elecBmpMinus = new BitmapData(BLOCKWIDTH, ELECHEIGHT, true, 0x300000FF);
            
            addChild(_magnetUpper = new Bitmap(magnetUpperBmp));
            addChild(_magnetLower = new Bitmap(magnetLowerBmp));
            addChild(_elecField = new Bitmap(_elecBmpMinus));
            
            _magnetUpper.x = (WIDTH-BLOCKWIDTH)/2;
            _magnetLower.x = (WIDTH-BLOCKWIDTH)/2;
            _elecField.x = (WIDTH-BLOCKWIDTH)/2;
            _magnetUpper.y = HEIGHT/2-(ELECHEIGHT/2+MAGHEIGHT);
            _magnetLower.y = HEIGHT/2+(ELECHEIGHT/2);
            _elecField.y = HEIGHT/2-(ELECHEIGHT/2);
            
            var _ball:Particle = new Particle(WIDTH / 2-10, HEIGHT / 2);
            _ball.vy = -1;
//            _ball.vx = Math.random() *6 - 3;
//            _ball.vy = -Math.random() *2 -2;
            _ball.color = 0xFFFFFF;
            
            _balls = new Vector.<Particle>();
            _balls.push(_ball);
            
            //var stats:Stats = new Stats();
            //stats.y = 200;
            //addChild(stats);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function update(e:Event):void
        {
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect, new ColorTransform (0.99, 0.8, 0.99));
            
            _elecTimer += 0.02;
            if (_elecTimer > _elecPeriod) //switch the field polarity
            {
                _elecTimer -= _elecPeriod;
                _elecAccel = -_elecAccel;
                if (_elecAccel > 0)
                {
                    _elecField.bitmapData = _elecBmpPlus;
                }
                else
                {
                    _elecField.bitmapData = _elecBmpMinus;
                }
            }
 
            
            var removeBalls:Vector.<Particle> = new Vector.<Particle>();
             for each(var ball:Particle in _balls)
             {
                var bvx:Number = ball.vx;
                var bvy:Number = ball.vy;
                var bspeed:Number = Math.sqrt(bvx * bvx + bvy * bvy);
                var bradians:Number = Math.atan2(bvy, bvx);
                //for (var i:int = 0; i < bspeed;i++)
                //{
                ball.x += ball.vx// /bspeed;
                ball.y += ball.vy// /bspeed;
                
                if ((ball.x < 0 && ball.vx < 0) || (ball.x > WIDTH && ball.vx > 0))
                {
                    ball.vx = -ball.vx;
                }
                if ((ball.y < 0 && ball.vy < 0) || (ball.y > HEIGHT  && ball.vy > 0))
                {
                    ball.vy = -ball.vy;
                    removeBalls.push(ball);
                }

                _canvas.setPixel(ball.x, ball.y, ball.color);
                //}
                if ((_magnetUpper.hitTestPoint(ball.x, ball.y))||(_magnetLower.hitTestPoint(ball.x, ball.y)))
                {
                    //apply magnetic force
                    //first get angle
                    bradians += Math.PI/2;
                    if (bradians > Math.PI * 2) bradians -= Math.PI*2;
                    //now we have the angle - decomp it into horiz/vert components
                    var ax: Number = Math.cos(bradians);
                    var ay: Number = Math.sin(bradians);
                    
                    var amult: Number = _magAccel * bspeed;
                    
                    ball.vx += ax*amult;
                    ball.vy += ay*amult;
                    var bnspeed:Number = Math.sqrt(ball.vx * ball.vx + ball.vy * ball.vy);
                    //speed limiter: this compensates for error due to the frame-by-frame nature of the setup
                    ball.vx *= bspeed/bnspeed;
                    ball.vy *= bspeed/bnspeed;
                }
                if ((_elecField.hitTestPoint(ball.x, ball.y)))
                {
                    //apply electric force
                    ball.vy += _elecAccel;
                    
                    //hack to compensate for frame error
                    //ball.vx = 0;
                }
            }
            removeBalls.forEach(function(b:Particle, ...args):void {
                var index:int = _balls.indexOf(b);
                if (index != -1)
                {
                    _balls.splice(index, 1);
                }
            });
            
            var removeFallBs:Vector.<Particle> = new Vector.<Particle>();
            _fallBlocks.forEach(function(fallP:Particle, ...args):void {
                fallP.vy += 0.1;
                fallP.x += fallP.vx;
                fallP.y += fallP.vy;
                _canvas.setPixel(fallP.x, fallP.y, fallP.color);

                if (fallP.y > HEIGHT)
                {
                    removeFallBs.push(fallP);
                }
            });
            
            removeFallBs.forEach(function(b:Particle,...args):void{
                var index:int = _fallBlocks.indexOf(b);
                if (index != -1)
                {
                    _fallBlocks.splice(index, 1);
                }
            });
            _canvas.unlock();
                 
                 
        }
        
        private function onMouseDown(event:MouseEvent):void {
            
            var _ball:Particle = new Particle(WIDTH / 2-10, HEIGHT / 2);
            _ball.vy = -1;
//            _ball.vx = Math.random() *6 - 3;
//            _ball.vy = -Math.random() *2 -2;
            _ball.color = 0xFFFFFF;
            
            _balls = new Vector.<Particle>();
            _balls.push(_ball);
        }       
    }
}
import frocessing.color.ColorHSV;
class Particle
{
    public var x:Number;
    public var y:Number;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var color:uint;
    public function Particle(x:Number=0,y:Number=0 )
    {
        this.x = x;
        this.y = y;
    }
}