/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/34sL
 */

package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.utils.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.*;
    import Box2D.Common.Math.b2Vec2;

    import com.demonsters.debugger.MonsterDebugger;


    public class FlashTest extends MovieClip {
        private var sim:QuickBox2D;
        private var contacts:QuickContacts;
        private var circles:Array = [];
        private var cs:Array = [];
        private var group:QuickObject;
        private var other:QuickObject;

        public function FlashTest() {
            MonsterDebugger.initialize(this);
            MonsterDebugger.trace(this, "Hello World!");
            
            sim = new QuickBox2D(this, {debug:false});
            sim.createStageWalls();

            cs = [sim.addCircle({x:1, y:1, radius:0.5, fillColor:0xff0000})];
            for (var i:int = 0; i < 5; i++){
                for (var j:int = 0; j < 5; j++){
                    circles.push(sim.addCircle({x:2 + i*2 + j*0.1, y:2 + i + j, radius:0.5}));
                }
            }

            sim.start();
            sim.mouseDrag();

            var contacts:QuickContacts = sim.addContactListener();
            contacts.addEventListener(QuickContacts.ADD, function onAdd(evt:Event):void {
                for each (var circle:QuickObject in circles) {
                    for each (var c:QuickObject in cs) {
                        if (contacts.isCurrentContact(c, circle) || contacts.isCurrentContact(circle, c)) {
                            other = circle;
                            return;
                        }
                    }
                }
            });
            addEventListener(Event.ENTER_FRAME, onLoop);
        }

        private function onLoop(evt:Event):void {
            if (other != null) {
                for each (var c:QuickObject in cs) {
                    sim.addJoint({a:c.body, b:other.body, collideConnected:false});
                }
                cs.push(other);
                other = null;

                //sim.addJoint({type:QuickBox2D.REVOLUTE, a:group.body, b:other.body, lowerAngle:-0.1, upperAngle:0.1, collideConnected:false});
                //sim.addJoint({a:group.body, b:other.body});
                /*
                sim.addJoint({a:group.body, b:other.body, x1:group.x+0.1, y1:group.y, x2:other.x+0.1, y2:other.y, collideConnected:false});
                sim.addJoint({a:group.body, b:other.body, x1:group.x-0.1, y1:group.y, x2:other.x-0.1, y2:other.y, collideConnected:false});
                sim.addJoint({a:group.body, b:other.body, x1:group.x, y1:group.y+0.1, x2:other.x, y2:other.y+0.1, collideConnected:false});
                sim.addJoint({a:group.body, b:other.body, x1:group.x, y1:group.y-0.1, x2:other.x, y2:other.y-0.1, collideConnected:false});
                */
            }
        }
    }
}