/**
 * Copyright _ryotaros ( http://wonderfl.net/user/_ryotaros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/34QR
 */

package {
    import flash.display.Sprite;
    import jp.nium.utils.*;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.text.TextFormat;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.accessibility.Accessibility;
	
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0xFFFFCC")]
    public class calender extends Sprite {
    		
    		public var dateLength:int;
    		public var dat:int;
    		public var day:int;
    		public var firstDay:int;
    		public var ball:Ball;
    		
    		public var firstSevenDay:int;
    		public var secondSevenDay:int;
    		
    		public var balls:Array;
    		public var topPointArray:Array;
    		public var rightPointArray:Array;
	    public var underPointArray:Array;
	    public var leftPointArray:Array;
    		
		public var spring:Number = 0.022;
		public var spring2:Number = 0.1;
    		public var friction:Number = 0.9425;
    		public var gravity:Number = 0.05;
    		public var sideMargin:int = 58;
    		public var underMargin:int = 10;
    		
    		public var isMouseDown:Boolean = false;	
    		public var activeBall:Ball;
    
        public var _onX:Number;
        public var _onY:Number;
        private var lastSevenDay:int;
    		
        public function calender():void{
            init();
        }
        
        public function init():void{
        		dateLength = DateUtil.getMaxDateLength(new Date());
        		var date:Date = new Date;
        		dat = date.getDate();
        		day = date.getDay();
        		firstDay = new Date(date.getFullYear(),date.getMonth(),1).getDay();
        		
        		balls = [];
        		var daycount:int = firstDay;
        		for (var i:int = 0;i < dateLength;i++){
        			
        			if(dat == i+1) {
						ball = new Ball(25,daycount,0x00FF00);
        			} else {
						if(daycount == 0){
							ball = new Ball(20, daycount,0xFF0032);
						} else if (daycount == 6){
							ball = new Ball(20,daycount, 0x0066FF);
						}else {
							ball = new Ball(20,daycount);							
						}
        			}
        			
					if(i==0){
        				ball.x = ball.y = sideMargin * (firstDay+1);	
        			} else {
        				ball.x = balls[i-1].x + sideMargin;
        				ball.y = balls[i-1].y;
        			}
					
        			if (daycount == 0){
        				ball.x = sideMargin;
        				ball.y = balls[i-1].y + sideMargin;
        			}
					
        			var text:TextField = new TextField();
        			var format:TextFormat = new TextFormat();
        			format.size = 20;
        			format.color = 0x000000;
        		    format.font = "Helvetica";
        			text.defaultTextFormat = format;
        			text.text = String(i+1);
        			ball.addChild(text); 
        			text.x = -text.width/9.5;
        			text.y = -text.height/9.5;
        			//text.x = -ball.width/2;
        			//text.y = -ball.height/2;
        			
        			
        			ball.useHandCursor = true;
				ball.buttonMode    = true;

        		    
        			ball.addEventListener(MouseEvent.MOUSE_DOWN,_mouseDownFunc);			
					
				addChild(ball);
        			balls.push(ball);
					
				if (daycount == 6) {daycount = 0;}
				              else {daycount++;}
        		}
				
			stage.addEventListener(MouseEvent.MOUSE_UP,_mouseUpFunc);
				
        		topPointArray = [];
				underPointArray = [];
        		for (i = 0;i<7;i++){
        				topPointArray.push(new Point(sideMargin * (i + 1), 0));     
					underPointArray.push(new Point(sideMargin * (i + 1), stage.stageHeight));   
        		}
        		
        		rightPointArray = [];
			leftPointArray = [];
        		for (i = 0; i < 7; i++) {
					leftPointArray.push(new Point(0,underMargin * (i+1)));     
        				rightPointArray.push(new Point(stage.stageWidth,underMargin * (i+1)));     
        		}
        		
        		firstSevenDay = 7 - firstDay;
        		secondSevenDay = 7 - firstSevenDay;
        		lastSevenDay = daycount;
				
        		addEventListener(Event.ENTER_FRAME,onenterframe);
        }
		
        public function _mouseDownFunc(e:MouseEvent):void {
			addEventListener(MouseEvent.MOUSE_UP, _mouseUpFunc);
        		activeBall = Ball(Object(e.target));
        		_onX = mouseX - activeBall.x;
        		_onY = mouseY - activeBall.y;
        		isMouseDown = true;
        }
        
        public function _mouseUpFunc(e:MouseEvent):void {
			removeEventListener(MouseEvent.MOUSE_UP, _mouseUpFunc);
        		isMouseDown = false;
        }
        
        public function onenterframe(e:Event):void{
        		this.graphics.clear();
        		this.graphics.lineStyle(2,0x000000);
        		var daycount:int = (firstDay+1);
        		
        		if (isMouseDown){
        			activeBall.x = mouseX - _onX;
        			activeBall.y = mouseY - _onY;	
        		}
        		
        		var weekCount:int = 0;
			var drawTargetBall:Array = [];
        		
        		for (var i:int = 0; i < dateLength; i++) {
				
					var targetBall:Ball = balls[i];
					var rightBall:Ball = balls[i + 1];
					var leftBall:Ball = balls[i - 1];
					var topBall:Ball = balls[i - 7];
					var underBall:Ball = balls[i + 7];
					
					if (i < firstSevenDay){
        				moveTo(targetBall, targetBall.x, topPointArray[targetBall.day].y, 0);
						
    				} else if (i < 7){
    					moveTo(targetBall, targetBall.x, topPointArray[targetBall.day].y, 70);
						
    				}else{
        				moveTo(targetBall, topBall.x, topBall.y, underMargin);
					}
					
					var _num:int = (dateLength-1) - i
					if(i < lastSevenDay){
						moveTo(balls[_num], underPointArray[balls[_num].day].x, underPointArray[balls[_num].day].y, 20);
					}else if(i<7){ 
						moveTo(balls[_num], underPointArray[balls[_num].day].x, underPointArray[balls[_num].day].y, 100);
					}else if(balls[_num+7]){
						moveTo(balls[_num], balls[_num + 7].x, balls[_num + 7].y, underMargin+10);
					}
					
					if (targetBall.day == 6) {
						moveTo(targetBall, rightPointArray[weekCount].x, targetBall.y, sideMargin);
        			}else if(rightBall){
	        			moveTo(targetBall, rightBall.x, rightBall.y, sideMargin);
        			}
					
					
				 if (targetBall.day == 0) {
					moveTo(targetBall,leftPointArray[weekCount].x,targetBall.y,sideMargin);
				}else if (leftBall){
					moveTo(targetBall,leftBall.x,leftBall.y,sideMargin);
				}
					
				drawTargetBall[i] = [];
				drawTargetBall[i] = [targetBall, leftBall, rightBall, topBall, underBall];
					
				daycount = i% 7;
        			if(daycount == 0) {weekCount++;} 	
        		}
			
			for (i = 0; i < dateLength; i++){
				targetBall = balls[i];
				for (var j:int = i + 1;j < dateLength;j++){
					var checkBall:Ball = balls[j];
					var dx:Number = targetBall.x - checkBall.x;
					var dy:Number = targetBall.y - checkBall.y;
					var dist:Number = Math.sqrt(dx * dx + dy * dy);
					var mindist:Number = targetBall.rad + checkBall.rad;
					if(dist < mindist){
						var angle:Number = Math.atan2(dy , dx);
						var tx:Number = targetBall.x + Math.cos(angle) * mindist;
						var ty:Number = targetBall.y + Math.sin(angle) * mindist;						
						var ax:Number = (tx - checkBall.x) * spring2;
						var ay:Number = (ty - checkBall.y) * spring2;
						targetBall.x -= ax;
						targetBall.y -= ay;
						checkBall.x += ax;
						checkBall.y += ay;
					}
				}	
			}
				
			for (i = 0; i < dateLength; i++) {
					
				drawLine(i, drawTargetBall[i][0], drawTargetBall[i][1], drawTargetBall[i][2], drawTargetBall[i][3], drawTargetBall[i][4]);			
				daycount = i% 7;
        			if(daycount == 0) {weekCount++;} 	
        		}
        }
		
		public function drawLine(num:int,target:Ball,left:Ball,right:Ball,top:Ball,under:Ball):void {
				if (!top){
        				graphics.moveTo(target.x,target.y);
        				graphics.lineTo(topPointArray[(num+1)%7].x,topPointArray[(num+1)%7].y)	
        			}
        			if((num % 7) != 5 && num != (dateLength -1)){
	        			graphics.moveTo(target.x,target.y);
					graphics.lineTo(right.x,right.y);
        			}
        			if(under){
        				graphics.moveTo(target.x,target.y);
        				graphics.lineTo(under.x,under.y);
        			}
		}
        
        public function moveTo(ball:Ball, tX:Number, tY:Number ,margin:Number):void {

        		var dx:Number = ball.x - tX;
        		var dy:Number = ball.y - tY;
        	
        		var angle:Number = Math.atan2(dy, dx);
        		var targetX:Number = tX + Math.cos(angle) * margin;
        		var targetY:Number = tY + Math.sin(angle) * margin;
			
        		ball.vx += (targetX - ball.x) * spring;
        		ball.vy += (targetY - ball.y) * spring;
        		
        		ball.vx *= friction;
        		ball.vy *= friction;
        		ball.vy += gravity;
        		
        		ball.x += ball.vx;
        		ball.y += ball.vy;
        }
    }
}

import flash.display.Sprite;
class Ball extends Sprite{
	
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var size:int;
	public var rad:Number;
	public var day:int;

	public function Ball(radius:Number = 20, week:int = 0, color:uint = 0xFFFFFF):void {
		day = week;
		rad = radius/2;
		size = radius;
		this.graphics.beginFill(color);
		this.graphics.lineStyle(0,0x000000);
		this.graphics.drawCircle(0,0,size);
		this.graphics.endFill()
	}
}