/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/34E7
 */

// forked from rect's OnomatopoeiaRoom forked from: Saqoosha challenge for professionals
// forked from checkmate's Saqoosha challenge for professionals
// 玉をつかんでこうポイっと。

// Base64ImageLoader add complete
// http://wonderfl.net/code/d13a85899a700da06cfcce52aa87fbefd5708479
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import flash.filters.*;

    import org.papervision3d.*;
    import org.papervision3d.events.*;
    import org.papervision3d.view.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.shaders.*;
    
    import jiglib.geometry.*;
    import jiglib.math.*;
    import jiglib.physics.RigidBody;
    import jiglib.plugin.papervision3d.Papervision3DPhysics;
    import jiglib.plugin.papervision3d.constraint.MouseConstraint;
    import jiglib.plugin.papervision3d.Pv3dMesh;
    
    import caurina.transitions.*;

    [SWF(width="465", height="465", backgroundColor=0x000000, frameRate="40")]

    public class onomatopoeiaRoom extends BasicView
    {
        private var physics:Papervision3DPhysics;
        private var mouseConstraint:MouseConstraint;
        
        private const BALLCOUNT:int = 8;
        private const BALLSIZE:int = 1800;
        private const ROOMSIZE:int = 18400;
        
        private var idleTimer:Timer;
        private var texBmd:BitmapData;
        private var onomatopoeicLayer: BitmapData;
        private var walls:Dictionary = new Dictionary();
        private var balls:Dictionary = new Dictionary();
        private var draggingObj:DisplayObject3D;
        private var colorTr: ColorTransform;
        private var onomatopoeicList:Vector.<BitmapData> = new Vector.<BitmapData>();
        private var cameraCount:int = 0;
        private var cameraAxis:Vector.<Number3D> = Vector.<Number3D>([new Number3D(3000,-6000,-12000),new Number3D(0,10000,-4000), new Number3D(-6000,0,-8000), new Number3D(8000,9000,-8000)]);

        public function onomatopoeiaRoom()
        {
            super (0,0,true,true,"Target");
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            
            physics = new Papervision3DPhysics(scene, 50);
            
            Base64ImageLoader.load( TEXTUREIMG, textureLoadComplete );
        }
        
        private function textureLoadComplete(e:Event):void
        {
            texBmd = (e.target.content as Bitmap).bitmapData;
            colorTr = new ColorTransform(1, 1, 1, 1, 0, 0, 0, -12);
            
            onomatopoeicLayer = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            var hud:Bitmap = new Bitmap(onomatopoeicLayer);
            addChild(hud);
            
            
            var rectArray:Array = [
                new Rectangle(4,255,24,42),
                new Rectangle(4,255,24,42),
                new Rectangle(31,245,50,70),
                new Rectangle(31,245,50,70),
                new Rectangle(84,245,76,68),
                new Rectangle(84,245,76,68),
                new Rectangle(163,247,103,87),
                new Rectangle(163,247,103,87),
                new Rectangle(274,245,104,99),
                new Rectangle(274,245,104,99)
            ];
            
            for (var i:int = 0; i < rectArray.length; i++)
            {
                var bd:BitmapData = new BitmapData(rectArray[i].width,rectArray[i].height, true, 0x00000000);
                bd.copyPixels(texBmd, rectArray[i], new Point(0,0), null, null, true);
                onomatopoeicList.push(bd);
            }

            init3D();
            startRendering();
            
            idleTimer = new Timer(10000);
            idleTimer.addEventListener(TimerEvent.TIMER, cameraPosition);
            idleTimer.start();
        }

        private function init3D():void
        {
            var pt:Point = new Point(0,0);
            var tmpArray:Array = [];
            var i:int
            
            for ( i = 0; i < 6; i++)
            {
                var wallBmd:BitmapData = new BitmapData(122,122,false);
                var copyRect:Rectangle = new Rectangle(Math.floor(i%4)*122, Math.floor(i/4)*122, 122, 122);
                wallBmd.copyPixels(texBmd, copyRect, pt);
                var mat:BitmapMaterial = new BitmapMaterial(wallBmd);
                mat.opposite = true;
                tmpArray.push(mat);
            }
            
            var wallMat:MaterialsList = new MaterialsList({
                top:tmpArray[0],
                bottom:tmpArray[1],
                front:tmpArray[2],
                back:tmpArray[3],
                left:tmpArray[4],
                right:tmpArray[5]
            });
            
            var objCube:Cube = new Cube(wallMat, ROOMSIZE, ROOMSIZE, ROOMSIZE, 6, 6, 6);
            scene.addChild(objCube);
            objCube.meshSort = DisplayObject3D.MESH_SORT_FAR;
            
            var dummySkin:Plane = new Plane(new WireframeMaterial(), ROOMSIZE+1000, ROOMSIZE+1000);
            var ground:RigidBody = new JPlane(new Pv3dMesh(dummySkin));
            ground.movable = false;
            ground.setOrientation(JMatrix3D.rotationX(Math.PI / 2));
            ground.y = -10200;
            physics.addBody(ground);
            
            var tWall:RigidBody = new JBox(new Pv3dMesh(dummySkin), ROOMSIZE, ROOMSIZE, BALLSIZE*1.2);
            tWall.movable = false;
            tWall.y = ROOMSIZE * 0.5 + (BALLSIZE*1.2*0.5);
            physics.addBody(tWall);
            
            var fWall:RigidBody = new JBox(new Pv3dMesh(dummySkin), ROOMSIZE, BALLSIZE*1.2, ROOMSIZE);
            fWall.movable = false;
            fWall.z = -(ROOMSIZE * 0.5 + (BALLSIZE*1.2*0.5));
            physics.addBody(fWall);
            
            var bWall:RigidBody = new JBox(new Pv3dMesh(dummySkin), ROOMSIZE, BALLSIZE*1.2, ROOMSIZE);
            bWall.movable = false;
            bWall.z = ROOMSIZE * 0.5 + (BALLSIZE*1.2*0.5);
            physics.addBody(bWall);
            
            var lWall:RigidBody = new JBox(new Pv3dMesh(dummySkin), BALLSIZE*1.2, ROOMSIZE+BALLSIZE*1.2, ROOMSIZE+BALLSIZE*1.2);
            lWall.movable = false;
            lWall.x = ROOMSIZE * 0.5 + (BALLSIZE*1.2*0.5);
            physics.addBody(lWall);
            
            var rWall:RigidBody = new JBox(new Pv3dMesh(dummySkin), BALLSIZE*1.2, ROOMSIZE+BALLSIZE*1.2, ROOMSIZE+BALLSIZE*1.2);
            rWall.movable = false;
            rWall.x = -(ROOMSIZE * 0.5 + (BALLSIZE*1.2*0.5));
            physics.addBody(rWall);

            walls[ground]='floor';
            walls[tWall]='top';
            walls[fWall]='front';
            walls[bWall]='back';
            walls[lWall]='left';
            walls[rWall]='right';
            
            var keylight:PointLight3D = new PointLight3D(false);
            scene.addChild(keylight);
            keylight.x = 500;
            keylight.y = 3000;

            var r:Number = 0;
            var rd:Number = 360 / BALLCOUNT;
            
            for ( i = 0; i < BALLCOUNT; i++)
            {
                var ballMat:PhongMaterial = new PhongMaterial(keylight,0xffffff,0xdddddd,10);
                ballMat.interactive = true;
                ballMat.lineAlpha = 1;
                ballMat.lineThickness = 5;
                var ball:Sphere = new Sphere(ballMat,BALLSIZE,10,6);
                scene.addChild(ball);
                ball.autoCalcScreenCoords = true;
                ball.extra = {oldCollision:null, dragging:false};
                ball.useOwnContainer = true;
                ball.filters = [ new GlowFilter( 0x000000, 1, 4, 4, 6) ];
                ball.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, pressHandler);
                
                var jball:RigidBody = new JSphere(new Pv3dMesh(ball), BALLSIZE);
                
                r += rd;
                jball.x = Math.cos(r*Math.PI/180)*6000, jball.y = 8000, jball.z = Math.sin(r*Math.PI/180)*6000;
                jball.friction = 1.48;
                jball.restitution = 0.7;
                physics.addBody(jball);
                balls[ball] = jball;
            }

            camera.fov = 50;
            camera.zoom = 24;
            var ct:DisplayObject3D = camera.target;
            ct.y = -3000;
            camera.position = cameraAxis[0];
        }
        
        private function cameraPosition(e:Event):void
        {
            cameraCount++;
            var pos:Number3D = cameraAxis[cameraCount&0x3];
            Tweener.addTween(camera,{x:pos.x, y:pos.y, z:pos.z, time:1, transition:"easeInOutSine"});
        }

        private function drawOnomatopoeic(sx:Number, sy:Number, modulo:Number):void
        {
            var index:int
            if (modulo > 200000) index = 8;
            else index = Math.max(0, Math.min(8,Math.round(modulo/15000)));
            
            var cpRect:Rectangle = onomatopoeicList[index].rect;
            onomatopoeicLayer.copyPixels(onomatopoeicList[index], cpRect, new Point(sx-cpRect.width*0.5,sy-cpRect.height*0.5), null, null, true);
        }
        
        private function resetPosition():void
        {
            for each(var item:RigidBody in balls)
            {
                if (item.currentState.position.x > ROOMSIZE || item.currentState.position.x < -ROOMSIZE || item.currentState.position.z > ROOMSIZE || item.currentState.position.z < -ROOMSIZE)
                item.moveTo(new JNumber3D(0, 8000, 0));
            }
        }

        override protected function onRenderTick(event:Event = null):void
        {
            physics.step();
            for each(var item:RigidBody in balls)
            {
                if (!(item.skin as Pv3dMesh).mesh.extra.dragging)
                {
                    var cc:int = item.collisions.length;
                    
                    for (var i:int = 0; i < cc; i++)
                    {
                        var colTarget:RigidBody = item.collisions[i].objInfo.body1;
                        if (colTarget != (item.skin as Pv3dMesh).mesh.extra.oldCollision && item.currentState.linVelocity.modulo2 > 15000)
                        {
                            drawOnomatopoeic(
                                stage.stageWidth * 0.5 + (item.skin as Pv3dMesh).mesh.screen.x,
                                stage.stageHeight * 0.5 + (item.skin as Pv3dMesh).mesh.screen.y,
                                item.currentState.linVelocity.modulo2
                            );
                        }
                        (item.skin as Pv3dMesh).mesh.extra.oldCollision = colTarget;
                    }
                }
            }
            onomatopoeicLayer.colorTransform(onomatopoeicLayer.rect, colorTr);

            resetPosition();
            super.onRenderTick(event);
        }


        private function pressHandler(event:InteractiveScene3DEvent):void
        {
            mouseConstraint = new MouseConstraint(event.displayObject3D, new Number3D(0, 0, 0.1), camera, viewport);
            stage.addEventListener(MouseEvent.MOUSE_UP, removeMouseConstraint);
            event.displayObject3D.extra.oldCollision = null;
            event.displayObject3D.extra.dragging = true;
            draggingObj = event.displayObject3D;
        }

        private function removeMouseConstraint(e:MouseEvent):void
        {
            mouseConstraint.destroy();
            mouseConstraint = null;
            draggingObj.extra.dragging = false;
            stage.removeEventListener(MouseEvent.MOUSE_UP, removeMouseConstraint);
        }


        private const TEXTUREIMG:String = "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";
    }
}

import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.events.Event;
import flash.utils.ByteArray;
import mx.utils.Base64Decoder;

class Base64ImageLoader
{
    
    static public function load(data:String, complete:Function = null):Loader
    {
        var byteArray:ByteArray;
        var base64Decoder:Base64Decoder;

        base64Decoder = new Base64Decoder();
        base64Decoder.decode(data);

        try {
            byteArray = base64Decoder.toByteArray();
            byteArray.position = 0;
        } catch (e:Error) {
            return null
        }

        var loader:Loader = new Loader();
        loader.loadBytes(byteArray);
        
        loader.contentLoaderInfo.addEventListener( Event.COMPLETE, complete );
        return loader;
     }
}
