/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/342x
 */

/*
確認用URL
http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&q=waterdrop&imglic=commercial&max-results=3&imgmax=288
↑これをブラウザのURL欄にコピー＆ペースト


【参考】Picasa Web Albums Data API
http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
*/
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.filters.DropShadowFilter;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	public class Main extends Sprite {
		public function Main() {
			//検索結果のロード
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
			var xmlURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&q=waterdrop&imglic=commercial&max-results=3&imgmax=288";
			//crossdomain.xml（クロスドメインポリシーファイル）の位置を指定
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");		//*1
			myURLLoader.load(new URLRequest(xmlURL));
		}
		
		private function onCompleteXML(e:Event):void {
			//取得したデータをXML型にする。
			var myXML:XML = new XML(e.currentTarget.data);		//*2
			
			//背景のグレーの文字。XMLの文字列を流し込んでいる。
			var tf:TextField = new TextField();
			tf.text = myXML;
			tf.textColor = 0xCCCCCC;
			tf.wordWrap = true;
			tf.width = tf.height = 465;
			addChild(tf);
			
			//XMLを解析
			var titleStr:String = myXML.channel.item[0].title;		//*3
			var linkURL:String = myXML.channel.item[0].link;		//*4
			//namespaceを設定
			default xml namespace = new Namespace("http://search.yahoo.com/mrss/");		//*5
			var creditStr:String = myXML.channel.item[0].group.credit;		//*6
			var imgURL:String = myXML.channel.item[0].group.content.@url;		//*7
			
			//タイトル、クレジット、リンクのテキストを入れて、ドロップシャドウをかける
			var htmldata:String = "Title:" + titleStr + "<br>";
			htmldata += "Credit:" + creditStr + "<br>";
			htmldata += "<a href='" + linkURL + "'>" + linkURL + "</a>";
			var fld:TextField = new TextField();
			fld.autoSize = TextFieldAutoSize.LEFT;
			fld.width = 300;
			fld.x = 50;
			fld.y = 50;
			fld.multiline = true;
			fld.htmlText = htmldata;
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			fld.filters = [dsf];
			addChild(fld);
            
			//画像のロード
			var myLoader:Loader = new Loader();
			var myURLRequest:URLRequest = new URLRequest(imgURL);
			//クロスドメインポリシーファイルをドキュメントルートから取得
			var myLoaderContext:LoaderContext = new LoaderContext(true);		//*8
			myLoader.load(myURLRequest, myLoaderContext);
			myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
		}
		
		private function onCompleteImg(e:Event):void {
			//読み込んだ画像をBitmapData化し、SpriteにbeginBitmapFillで転写しています。
			//この操作を複数ドメイン上で行うにはクロスドメインポリシーファイルによる
			//許可が必要です。
			var myBitmap:Bitmap = e.target.content;
			var myBitmapData:BitmapData = new BitmapData(myBitmap.width, myBitmap.height);
			myBitmapData.draw(myBitmap);
			var mySprite:Sprite = new Sprite();
			mySprite.graphics.beginBitmapFill(myBitmapData);
			mySprite.graphics.drawRoundRect(0, 0, myBitmap.width, myBitmap.height, 50, 50);
			mySprite.x = 50;
			mySprite.y = 100;
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			mySprite.filters = [dsf];
			addChild(mySprite);
		}
	}
}
