/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/33FA
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	
    public class Main extends Sprite {

        private var bmd:BitmapData;
		private var list:Array;
		private var p_num:uint = 10000;
		private var filter:BlurFilter = new BlurFilter();
		
		public function Main() {
			if (stage) this.addEventListener(Event.ADDED_TO_STAGE, init);
			else init();			
        }
		
		private function init(e:Event = null):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, init);
			//ビットマップﾃﾞｰﾀを作る、ここにパーティクルをsetPixelして点をつける。
			bmd  new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			this.addChild(new Bitmap(bmd));
			//ここから繰り返し、とりあえずパーティ来る10000個
			for (var i:uint = 0; i < p_num; i++) {
				var p:Particle = new Particle();
				p.x = rand(stage.stageWidth);
				p.y = rand(stage.stageHeight);
				p.vx = rand(10) - 5;
				p.vy = -rand(10);
				p.color = rand(0xffffff);
				bmd.setPixel(p.x, p.y, p.color);
				list.push(p);
			}
			this.addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			bmd.applyFilter(bmd, bmd.rect, new Point(0, 0), filter);
			bmd.scroll(0, -10);
			var p:Particle;
			bmd.lock();
			for (var i:uint = 0; i < p_num; i++) {			
			p = list[i];
			p.x += p.vx;
			p.y += p.vy;
			bmd.setPixel(p.x, p.y, p.color);
			}
			bmd.unlock();
		}
		private function rand(num:Number):Number {
		return Math.random() * num;	
		}
    }
}


class Particle {
	public var x:Number, y:Number, vx:Number, vy:Number, color:uint;
}