/**
 * Copyright xoul ( http://wonderfl.net/user/xoul )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/32eS
 */

package
{
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite
    {
        private var _canvas : BitmapData;
        
        private var _lastMouseX : Number = 0;
        private var _lastMouseY : Number = 0;
        
        private var _heads : Vector.<Head>;
        
        private var _alphaTransform : ColorTransform;
        
        public function FlashTest()
        {
           _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
           addChild( new Bitmap( _canvas ) );
           
           _heads = new Vector.<Head>( 100, true );
           var len : int = _heads.length;
           for( var i : int = 0; i < len; i++ )
               _heads[i] = new Head;
           
           stage.addEventListener( MouseEvent.MOUSE_MOVE, onMouseMove );
           stage.addEventListener( Event.ENTER_FRAME, onEnterFrame );
           
           _alphaTransform = new ColorTransform( 1, 1, 1, .95 );
           
           _lastMouseX = mouseX;
           _lastMouseY = mouseY;
        }
        
        private function onMouseMove( e : MouseEvent ) : void
        {        
            var len : int = _heads.length;
            for( var i : int = 0; i < len; i++ )
            {
                if( !_heads[i].shooted )
                {
                    shoot( _heads[i], Math.atan2( mouseY - _lastMouseY, mouseX - _lastMouseX ) );
                    break;
                }
            }
            
            _lastMouseX = mouseX;
            _lastMouseY = mouseY;
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.colorTransform( _canvas.rect, _alphaTransform );
            
            var len : int = _heads.length;
            for( var i : int = 0; i < len; i++ )
            {
                var head : Head = _heads[i];
                if( head.shooted )
                {
                    var lastX : Number = head.x;
                    var lastY : Number = head.y;
                    head.x += head.radius * Math.cos( head.direction );
                    head.y += head.radius * Math.sin( head.direction );
                    
                    if( head.rightOrLeft ) head.direction -= head.dDir;
                    else head.direction += head.dDir;;
                    head.radius -= .5;
                    
                    if( head.radius <= 0 )
                    {
                        head.shooted = false;
                    }
                    
                    drawLine( lastX, lastY, head.x, head.y, head.color );
                }
            }

        }
        
        private function shoot( head : Head, direction : Number ) : void
        {
            head.shooted = true;
            head.x = _lastMouseX;
            head.y = _lastMouseY;
            head.direction = direction;
            head.dDir = Math.random();
            head.radius = Math.random() * 10 + 5;
            head.rightOrLeft = Math.random() < .5;
            head.color = Math.random() * 0xFFFFFF;
        }

        private function drawLine( startX : Number, startY : Number, endX : Number, endY : Number, color : Number ) : void
        {
            var dx : Number = endX - startX;
            var dy : Number = endY - startY;
            var a : Number;
            var b : Number;
            var tmp : Number;
            var len : Number;
            var i : int;
            
            if( getAbs( dx ) > getAbs( dy ) )
            {
                a = dy / dx;
                b = startY;
                
                if( startX > endX )
                {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                    b = endY;
                }
                
                len = endX - startX;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i + startX, i * a + b, color );
                }
            }
            else
            {
                a = dx / dy;
                b = startX;
                
                if( startY > endY )
                {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                    b = endX;
                }
                
                len = endY - startY;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i * a + b, i + startY, color );
                }
            }
        }
        
        private function getAbs( x : Number ) : Number
        {
            return x < 0 ? -x : x;
        }
    }
}

class Head
{
    public var x : Number;
    public var y : Number;
    public var radius : Number;
    public var direction : Number;
    public var dDir : Number;
    public var rightOrLeft : Boolean;
    public var shooted : Boolean;
    public var color : uint;
}
