/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/32QR
 */

package
{
    import alternativ7.engine3d.materials.TextureMaterial;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import alternativ7.engine3d.containers.ConflictContainer
    import alternativ7.engine3d.core.View
    import alternativ7.engine3d.core.Camera3D
    import alternativ7.engine3d.controllers.SimpleObjectController
    import alternativ7.engine3d.primitives.Box
    import alternativ7.engine3d.materials.FillMaterial
    
    
    /**
     * TokyoTeraco11 その5
     * 6面にテクスチャーを張り分けてみよう！
     *
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="60")]
    public class Main extends Sprite
    {
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            //ルートオブジェクト（Root Object）
            var container:ConflictContainer = new ConflictContainer();

            //ビューを作る
            var view:View = new View(stage.stageWidth, stage.stageHeight);
            addChild(view);

            //カメラを作る
            var camera:Camera3D = new Camera3D();

            //カメラとビューを関連付ける
            camera.view = view;

            //カメラを撮影する3D空間に配置する
            container.addChild(camera);

            //カメラの位置を調整
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;

            //カメラをコントローラ
            var cameraController:SimpleObjectController = new SimpleObjectController(stage, camera, 10);
            cameraController.mouseSensitivity = 0
            cameraController.unbindAll()
            cameraController.lookAtXYZ(0, 0, 0)
            
            
            //BitmapDataを作成
            var bmdArry:Vector.<BitmapData> = new Vector.<BitmapData>(6)
            var matArry:Vector.<TextureMaterial> = new Vector.<TextureMaterial>(6)
            for (var i:int = 0; i < 6; i++)
            {
                bmdArry[i] = new BitmapData(300, 300, false, 0xFFFFFFFF);
                matArry[i] = new TextureMaterial(bmdArry[i])
            }
            
            var canvas:Sprite = new Sprite()

            //丸1
            canvas.graphics.beginFill(0xFF0000);
            canvas.graphics.drawCircle(150, 150, 50)
            
            bmdArry[0].draw(canvas);
            
            //丸2
            canvas.graphics.clear();
            canvas.graphics.beginFill(0x000000);
            canvas.graphics.drawCircle(80, 80, 30)
            canvas.graphics.drawCircle(220, 220, 30)
            bmdArry[1].draw(canvas);

            //丸3
            canvas.graphics.clear();
            canvas.graphics.beginFill(0x000000);
            canvas.graphics.drawCircle(70, 70, 30)
            canvas.graphics.drawCircle(150, 150, 30)
            canvas.graphics.drawCircle(230, 230, 30)
            bmdArry[2].draw(canvas);
            
            //丸4
            canvas.graphics.clear();
            canvas.graphics.beginFill(0x000000);
            canvas.graphics.drawCircle(70, 70, 30)
            canvas.graphics.drawCircle(230, 70, 30)
            canvas.graphics.drawCircle(70, 230, 30)
            canvas.graphics.drawCircle(230, 230, 30)
            bmdArry[3].draw(canvas);
            
            //丸5
            canvas.graphics.clear();
            canvas.graphics.beginFill(0x000000);
            canvas.graphics.drawCircle(70, 70, 30)
            canvas.graphics.drawCircle(70, 230, 30)
            canvas.graphics.drawCircle(150, 150, 30)
            canvas.graphics.drawCircle(230, 70, 30)
            canvas.graphics.drawCircle(230, 230, 30)
            bmdArry[4].draw(canvas);
            
            //丸6
            canvas.graphics.clear();
            canvas.graphics.beginFill(0x000000);
            canvas.graphics.drawCircle(80, 70, 30)
            canvas.graphics.drawCircle(80, 150, 30)
            canvas.graphics.drawCircle(80, 230, 30)
            canvas.graphics.drawCircle(210, 70, 30)
            canvas.graphics.drawCircle(210, 150, 30)
            canvas.graphics.drawCircle(210, 230, 30)
            bmdArry[5].draw(canvas);
            
            
            //オブジェクトを作成して3D空間（コンテナ）に追加
            var box:Box = new Box(100, 100, 100, 1, 1, 1, false,false,matArry[0],matArry[5],matArry[1],matArry[4],matArry[2],matArry[3])
            container.addChild(box)


            //オブジェクトコントローラを追加
            var objectController:SimpleObjectController = new SimpleObjectController(stage, box, 10);
            objectController.mouseSensitivity = 1
            objectController.unbindAll()

            addEventListener(Event.ENTER_FRAME, onEnterFrame)

            var RADIAN:Number = Math.PI/180

            function onEnterFrame(e:Event):void
            {
                //box.rotationY += RADIAN
                //カメラコントローラの操作をコントロールオブジェクトに反映
                cameraController.update();
                
                //オブジェクトコントローラの操作をコントロールオブジェクトに反映
                objectController.update();
                
                //レンダリング
                camera.render();
            }

            
        }
        

        
    }
    
}
