/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/32Fb
 */

// forked from makc3d's Rule 90
// forked from makc3d's Pixel Bender Mandelbrot (with bail out)
// forked from makc3d's Pixel Bender Mandelbrot
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ShaderFilter;
    import flash.geom.Point;
    import flash.utils.ByteArray;
    import flash.utils.Endian;
    public class Rule90 extends Sprite {
        public function Rule90 () {
            // create kernel (source below)
            var a:Array = [-23295,0,164,1536,21109,27749,14640,-24564,28257,28005,29552,24931,25856,25976,28773,29289,28005,28276,24940,160,3190,25966,25711,29184,28001,27491,160,2166,25970,29545,28526,1,160,3172,25971,25458,26992,29801,28526,114,30060,25888,14640,161,258,0,3167,20341,29763,28527,29284,163,4,29554,25344,-24318,1025,15,25715,29696,-24319,1026,15,29285,25460,162,1133,26990,22113,27765,25856,0,0,0,0,0,0,0,0,-24060,28001,30806,24940,30053,69,0,69,0,69,0,69,0,162,1124,25958,24949,27764,22113,27765,25856,0,0,0,0,17096,0,17096,0,7424,49,0,4096,11010,128,0,-32768,7425,-32640,128,0,11010,64,0,-16384,7425,-32704,128,0,7425,-32736,384,0,11521,-32736,384,16384,11008,32,512,-32768,7425,-32640,128,0,7425,-32704,384,-32768,11521,-32704,384,0,11008,16,512,-16384,7425,-32640,128,0,7425,-32736,384,16384,11521,-32736,384,0,13312,0,384,-32768,12803,32,16256,0,7427,16,0,-32768,515,16,768,-32768,7427,128,768,-16384,12803,32,16256,0,7427,16,0,-16384,515,16,768,-32768,7427,64,768,-16384,12292,241,768,4096,7427,243,1024,6912,12804,32,16256,0,7428,16,0,-32768,260,16,1024,-32768,7428,128,1024,-16384,12804,32,16256,0,7428,16,0,-16384,516,16,1024,-32768,7428,64,1024,-16384,12293,241,1024,4096,7428,243,1280,6912,10499,128,1024,0,7425,-32640,128,0,13312,0,384,0,12801,128,0,0,12801,64,0,0,12801,32,0,0,12801,16,16256,0,13568,0,0,0,12801,128,16256,0,12801,64,16256,0,12801,32,16256,0,12801,16,16256,0,13824,0,0,0,13568,0,0,0,12293,241,0,-20480,7425,243,1280,6912,13824,0,0,0];
            var b:ByteArray = new ByteArray; b.endian = Endian.BIG_ENDIAN; for (var i:int = 0; i < a.length; i++) b.writeShort (a [i]); b.position = 0; 0;
            k = new ShaderFilter (new Shader (b));
            k.shader.data ["rect"] ["value"] = [1, 1, 464, 464];

            // create bitmap
            this.b = new BitmapData (465, 465, false, 0xFFFFFF); this.b.setPixel (233, 0, 0); addChild (new Bitmap (this.b));

            // go
            addEventListener (Event.ENTER_FRAME, loop);
        }
        private var k:ShaderFilter;
        private var b:BitmapData;
        private function loop (e:Event):void {
            b.applyFilter (b, b.rect, b.rect.topLeft, k);
        }
    }
}
/* pbk:

<languageVersion : 1.0;>

kernel Rule90
<   namespace : "experimental";
    vendor : "makc";
    version : 1;
    description : "rule 90";
>
{
    input image4 src;
    output pixel4 dst;

    parameter float4 rect
    <
        minValue:float4 (0.0, 0.0, 0.0, 0.0);
        maxValue:float4 (2048.0, 2048.0, 2048.0, 2048.0);
        defaultValue:float4 (0.0, 0.0, 100.0, 100.0);
    >;


    void
    evaluatePixel()
    {
        float2 at = outCoord ();
        if ((at.x >= rect.x) && (at.y >= rect.y) &&
            (at.x <= rect.p) && (at.y <= rect.q)) {
            pixel4 lt = sampleNearest (src, float2 (at.x + 1.0, at.y - 1.0));
            pixel4 rt = sampleNearest (src, float2 (at.x - 1.0, at.y - 1.0));
            if (lt.r != rt.r)
                dst = pixel4 (0.0, 0.0, 0.0, 1.0);
            else
                dst = pixel4 (1.0, 1.0, 1.0, 1.0);
        } else {
            dst = sampleNearest (src, at);
        }
    }
}

*/