/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/31qO
 */

package 
{
    // Import External Classes
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
        
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='30')]
    
    /**
    * Name           : Main 
    * Coded By       : Matt Wakeling
    * Date           : 29th April 2012
    * Description    : Main Class for the Application.
    *                  Rose Curves using Polar Coordinates.
    *
    * @author Matt Wakeling
    */
    public class Main extends Sprite 
    {
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }

        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
                                                                   
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align     = StageAlign.TOP_LEFT;
        
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000,1);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();            
                         
            var $Pattern:uint = 0;
            
            for (var $column:Number = 0; $column < 3; $column++)
            {
                for (var $row:Number = 0; $row < 3; $row++)
                {
                    displayRose(($row * 170) + 60, ($column * 170) + 60, $Pattern);
                    $Pattern++;
                }
            }
        }
        
        // displayRose Method
        private function displayRose($displayatx:int, $displayaty:int, $pattern:uint) :void
        {
            var sprSprite:Sprite = new Sprite;
            
            sprSprite.graphics.clear();
            sprSprite.graphics.lineStyle(1, 0xFFFFFF);
                
            var $n:Array = new Array (2 , 3, 4, 5, 0.5, Math.PI, Math.sqrt(2), 10 , 30);
            var $a:Number = 50;
            
            var $r:Number = 0;
            var $x:Number = 0;
            var $y:Number = 0;
            
            
            for (var $t:Number = -8    * Math.PI; $t <= 8 * Math.PI; $t += 0.02)
            {
                $r = $a * Math.sin($n[$pattern] * $t);
                $x = $r * Math.cos($t) 
                $y = $r * Math.sin($t) 
                
                sprSprite.graphics.lineTo($x, $y);
            }
            
            sprSprite.x = $displayatx;
            sprSprite.y = $displayaty;
            
            addChild(sprSprite);
        }
    }
}