/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/30dQ
 */

// forked from kamibana's DotTexture
package
{
    import flash.display.AVM1Movie;
    import flash.geom.Matrix;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    /**
     * ...
     * @author kiyo
     */
    public class Main extends Sprite
    {
        private var texture:Texture;
        private var texture2:Texture;
        private var speed:Number=1;
        private var toggle:Boolean;
        
        public function Main() 
        {
            texture = new DotTexture(5);
            addChild(texture);
            
            texture2 = new DotTexture(5);
            addChild(texture2);
            
            addEventListener(Event.ENTER_FRAME,enterframeHandler);
        }
        
        private function enterframeHandler(e:Event):void{
            
            if(texture2.x>=stage.stageWidth){
                 toggle=true;
            }
            
            if(texture2.x<=0){               
                 toggle=false;
            }

            if(toggle){
                texture2.x -= 0.5;
                texture2.y -=1;
            }else{
                texture2.x+=0.5;
                texture2.y+=1;
            }

   
            


        }

        
        private function clickHandler(e:MouseEvent):void 
        {
            
            var radian:Number = speed*Math.PI/180;
            var rotateMatrix:Matrix = new Matrix();
            rotateMatrix.translate(texture2.width/2,texture2.height/2);
            rotateMatrix.rotate(radian);
            rotateMatrix.translate(-texture2.width/2,-texture2.height/2);
            texture2.transform.matrix = rotateMatrix;
            speed++;
            
        }
        
        private function loop(e:Event):void 
        {
            
        }

    }

}

import flash.display.Sprite;
    /**
     * ...
     * @author kiyo
     */
    class Texture extends Sprite
    {
        protected var interval:Number;
        
        public function Texture(interval:Number=10) 
        {
            this.interval = interval;
        }
        
        protected function draw():void
        {
            
        }
        
        
        
    }

import flash.events.Event;
    /**
     * ...
     * @author kiyo
     */
    class DotTexture extends Texture
    {
        
        public function DotTexture(interval:Number = 10) 
        {
            super(interval);
            addEventListener(Event.ADDED_TO_STAGE, addedStageHandler);
        }
        
        private function addedStageHandler(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedStageHandler);
            draw();
        }
        
        override protected function draw():void 
        {
            
            var dotRadius:Number = 1;
            var hNum:uint = stage.stageWidth / (dotRadius + interval) + 1;
            trace("hNum : " + hNum);
            trace("interval : " + interval);
            var vNum:uint = stage.stageHeight / (dotRadius + interval)+1;
            var totalNum:uint = hNum * vNum;
            trace("totalNum : " + totalNum);
            var hCount:uint = 0;
            var vCount:uint = 0;
            
            for (var i:int = 0; i < totalNum; i++) 
            {
                var dot:Dot = new Dot(dotRadius);
                if (i % hNum == 0 && i != 0){
                    hCount = 0;
                    vCount++;
                }
                dot.x = stage.stageWidth / hNum * hCount;
                dot.y = stage.stageHeight / vNum * vCount;
                addChild(dot);
                hCount++
            }
            
        }
        
    }
    
    import flash.display.Sprite;
    /**
     * ...
     * @author kiyo
     */
    class Dot extends Sprite
    {
        private var _radius:Number;
        private var _color:uint;
        
        public function Dot(radius:Number=10,color:uint=0x000000) 
        {
            _radius = radius;
            _color = color;
            graphics.beginFill(color);
            graphics.drawCircle(0, 0, _radius);
            graphics.endFill();
        }
        
    }

    
    
