/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zyE
 */

// forked from Quasimondo's Math Music - New Formulas
// forked from Saqoosha's Math Music
package {

    import com.bit101.components.Component;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;


    /**
     * AS3 8bit sounds engine by Saqoosha built after following video
     * "Experimental music from very short C programs"
     * http://www.youtube.com/watch?v=GtQdIYUtAHg
     * and Kyle's visualization.
     * http://www.flickr.com/photos/kylemcdonald/6187863454/in/photostream/
     *
     @quasimondo: New Sounds
     */
    [SWF(backgroundColor="0x000000", frameRate="30", width="475", height="475")]
    public class MathMusic extends Sprite {
        
        
        private static const FORMULAS:Array = [
            'Tilde',
            'Huh',
            'Calling_all_Cars',
            'Beep_Between_the_Lines',
            'Interruptus',
            'Exitus',
            'Spankbert',
            '64_Sievert',
            'Faster_Faster_Faster'
         ];


        private var _sound:Sound;
        private var _channel:SoundChannel;
        private var _t:Number = -1;
        private var _type:int = -1;
        private var _image:BitmapData;
        private var _px:int = 0;
        private var _py:int = 0;
        private var _control:Component;
        private var _buttons:Vector.<PushButton> = new Vector.<PushButton>();


        public function MathMusic() {
            _image = new BitmapData(256, 256, false, 0x0);
            var b:Bitmap = addChild(new Bitmap(_image)) as Bitmap;
            b.width = b.height = 475;
            
            var vbox:VBox = new VBox(this, 5, 5);
            for each (var f:String in FORMULAS) {
                var btn:PushButton = new PushButton(vbox, 0, 0, f.replace(/ +/g, '').toUpperCase(), _onClick);
                btn.toggle = true;
                btn.width = 232;
                _buttons.push(btn);
            }
            _control = vbox;
            _control.scaleX = _control.scaleY = 2;
            
            _sound = new Sound();
            _sound.addEventListener(SampleDataEvent.SAMPLE_DATA, _onSampleData);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, function(e:*):void { _control.visible = true; });
            stage.addEventListener(Event.MOUSE_LEAVE, function(e:*):void { _control.visible = false; });
        }
        
        
        private function _play():void {
            for (var i:int = 0, n:int = _buttons.length; i < n; i++) {
                _buttons[i].selected = i == _type;
            }
            _t = 0;
            _px = 0;
            _py = 0;
            _image.fillRect(_image.rect, 0x0);
            if (_channel) _channel.stop();
            _channel = _sound.play();
        }


        private function _onClick(e:Event):void {
            var type:int = _buttons.indexOf(e.target);
            if (_type != type) {
                _type = type;
                _play();
            }
        }


        private var ot:int = -1;
        
        private function _onSampleData(e:SampleDataEvent):void {
            var i:int, t:int, tt:int, val:Number;
            _image.lock();
            for (i = 0; i < 8192; i++, _t++) {
                t = (_t * 8 / 44.1);
                switch (_type) {
                    case 0: tt = ((~t)%(t^((t+14881035)>>((((t>>(t&0xf))-861555)&10902270)&0xf)))); break;
                    case 1: tt = (((t>>7)!=(7<<(7&0xf))?18:t)%(27>>((t>>((11-t)&0xf))&0xf))); break;
                    case 2: tt = ((((((t>>28)+t)&t)<<(((t>>10)>>(((((t>>17)%9345438)*(t>>10))/((t>>6)<<(((~(t>>30))-((12328846&(t>>10))%((t>>21)<<((t>>1)&0xf))))&0xf)))&0xf))&0xf))%(t^(~(t&10572745))))-t); break;
                    case 3: tt = ((t&(((t<<((t>>17)&0xf))*((3725551+12352000)&(3725551+12352000)))<<(((9389314/(1966799%(t>>10)))%(((t>>25)>>(((~(t>>29))|(t>>29))&0xf))^15658107))&0xf)))&14834528); break;
                    case 4: tt = (((t&(((((16426628+(5224560%((t>>7)<<((t>>7)&0xf))))>(16426628+(5224560%((t>>7)<<((t>>7)&0xf))))?8973357:9685148)|((16426628+(5224560%((t>>7)<<((t>>7)&0xf))))>(16426628+(5224560%((t>>7)<<((t>>7)&0xf))))?8973357:9685148))%(~9659207))%t))%t)+((t&(t*10751950))>>(16075754&0xf)));break;
                    case 5: tt = (((t&(((((6738337+(4971156%((t>>14)<<((t>>14)&0xf))))>(6738337+(4971156%((t>>14)<<((t>>14)&0xf))))?10738478:4204522)|((6738337+(4971156%((t>>14)<<((t>>14)&0xf))))>(6738337+(4971156%((t>>14)<<((t>>14)&0xf))))?10738478:4204522))%(~15113751))%t))%t)+((t&(t*10182052))>>(5506775&0xf)));break;
                    case 6: tt = ((((t>>((t>>14)&0xf))&(t^t))^((t>>4)%7842059))|(((t>>((t>>8)&0xf))*t)^t)); break;
                    case 7: tt = (((t<<(t&0xf))*(t<<((t>>(((~((t|((12632215>>(28&0xf))-(t>>11)))>>(t&0xf)))*t)&0xf))&0xf)))|((9616686&13665325)|(t>>(15799420&0xf))));break;
                    case 8: tt = ((((t>>20)|(t+t))^(~(t/t)))^(2406194>9260103?9260103:(((((t>>9)<<(2171718&0xf))*t)>>(4231325&0xf))&9626108))); break;
                            }
                tt &= 0xff;
                val = tt / 0xff;
                e.data.writeFloat(val);
                e.data.writeFloat(val);
                if (t != ot) {
                    _image.setPixel(_px, _py, tt << 16 | tt << 8 | tt);
                    if (++_px == _image.width) {
                        _px = 0;
                        if (++_py == _image.height) {
                            _py = 0;
                        }
                    }
                }
                ot = t;
            }
            _image.unlock();
        }
    }
}
