/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zuP
 */

// forked from John_Blackburne's Trig performance test
// forked from John_Blackburne's flash on 2011-12-16
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import flash.geom.Vector3D;

    public class FlashTest extends Sprite {
        
        public const kVecNum:int       = 64;
        public const kNumTrials:int    = 5000000;
        
        public var aVec:Vector.<Vector3D>;
        
        public var tf:TextField;

        public function FlashTest() {
            var iTime:int;
            
            InitText();
            InitTrigTable();
            
            iTime = getTimer();
            TestBuiltin();
            tf.appendText("Tables:" + String(getTimer() - iTime));

            iTime = getTimer();
            TestBuiltin();
            tf.appendText("\nTables:" + String(getTimer() - iTime));

            iTime = getTimer();
            TestCustom1();
            tf.appendText("\nFunctions:" + String(getTimer() - iTime));

            iTime = getTimer();
            TestCustom2();
            tf.appendText("\nFunctions:" + String(getTimer() - iTime));

            tf.appendText("\nDone");
        }
        
        public function InitText():void {
            tf = new TextField();
            addChild(tf);
        }

        public function InitTrigTable():void {
            var iVec:int;
            
            aVec = new Vector.<Vector3D>(kVecNum, true);    
            for (iVec = 0; iVec < kVecNum; iVec++) {
                aVec[iVec] = new Vector3D(1, 2, 2);
            }
        }

        public function TestBuiltin():void {
            var iTrial:int, v:Vector3D;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aVec[iTrial % kVecNum];
                v.normalize();
            }
        }

        public function TestCustom1():void {
            var iTrial:int, v:Vector3D,
                fX:Number, fY:Number, fZ:Number, fLength:Number;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aVec[iTrial % kVecNum];
                fX = v.x; fY = v.y; fZ = v.z;
                fLength = 1 / Math.sqrt(fX * fX + fY * fY + fZ * fZ);
                fX *= fLength; fY *= fLength; fZ *= fLength;
                v.x = fX; v.y = fY; v.z = fZ;
            }
        }

        public function TestCustom2():void {
            var iTrial:int, v:Vector3D, fLength:Number;
            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aVec[iTrial % kVecNum];
                fLength = Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
                v.x /= fLength;
                v.y /= fLength;
                v.z /= fLength;
            }
        }

    }
}