/**
 * Copyright ShutheSL ( http://wonderfl.net/user/ShutheSL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zsK
 */

// forked from Nyarineko's AudioSpectrum
/*
*   ※注意：音が出ます。マウスダウンでワイヤーフレーム消去。
*   参考：http://sakeprog.cocolog-nifty.com/sake/2008/05/post_a1d5.html
*/
package
{
	import flash.events.Event;
	import flash.media.Sound;
	import flash.media.SoundMixer;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import flash.system.*;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.effects.utils.BitmapDrawCommand;
	import org.papervision3d.objects.primitives.*;
	
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
	public class Main extends BasicView
	{
		private var _bytes:ByteArray;
		private var _spectrum:Array;
		private var _mySpherePos:Sphere;
		private var _mySphere:Sphere;
		private var _myPixels:Pixels;
		private var _myPixelArray:Array;
		
		public function Main():void
		{
			var i:uint = 0;
			camera.z=-400;
			camera.y=0;
			
			_bytes=new ByteArray();
			_spectrum=new Array();
			_myPixelArray=new Array();
			
			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
			layer.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 4), false));
			layer.drawCommand = new BitmapDrawCommand();  
			viewport.containerSprite.addLayer(layer);
			
			_myPixels=new Pixels(layer);
			_mySpherePos = new Sphere(null,150,16,16);
			_mySphere = new Sphere(null,150,16,16);
			
			_mySphere.x = 0;
			
            for each(var obj:* in _mySpherePos.geometry.vertices){
				_myPixelArray[i] = new Pixel3D( (0xff << 24 | 0xff << 16 | 0x33 << 8 | i ), obj.x, obj.y, obj.z);
				_myPixels.addPixel3D(_myPixelArray[i]);
				i++;
            }
			
			scene.addChild(_myPixels);
			scene.addChild(_mySphere);
            
			_myPixels.visible = true;
			_mySphere.visible = true;
			Security.loadPolicyFile("http://wakaz.info/pv3d_audio/crossdomain.xml");
			var sound:Sound=new Sound();
			sound.addEventListener(Event.COMPLETE, onComplete);
			sound.load(new URLRequest("http://wakaz.info/pv3d_audio/song.mp3"));
		}
		
		private function onComplete(e:Event):void
		{
			(e.target as Sound).play();
			addEventListener(Event.ENTER_FRAME, makeSpectrum);
            addEventListener(MouseEvent.MOUSE_DOWN, _hide);
            addEventListener(MouseEvent.MOUSE_UP, _show);
            addEventListener(MouseEvent.MOUSE_MOVE, _move);
		}
		
		public function makeSpectrum(e:Event):void
		{
			var i:int;
			var mscale:Number = 1.4;
			
			SoundMixer.computeSpectrum(_bytes, true, 0);
			
			for(i=0; i < 256; ++i) _spectrum[i]=_bytes.readFloat();
			i = 0;
            for each(var obj:* in _mySpherePos.geometry.vertices){
              _mySphere.geometry.vertices[i].x=obj.x*(_spectrum[i]*mscale+1);
              _mySphere.geometry.vertices[i].y=obj.y*(_spectrum[i]*mscale+1);
              _mySphere.geometry.vertices[i].z=obj.z*(_spectrum[i]*mscale+1);
			  _myPixelArray[i].x=obj.x*(_spectrum[i]*mscale+1);
			  _myPixelArray[i].y=obj.y*(_spectrum[i]*mscale+1);
			  _myPixelArray[i].z=obj.z*(_spectrum[i]*mscale+1);
			  i++;
            }
            
			_mySphere.rotationX+=0.2;
			_mySphere.rotationY+=0.3;
			_myPixels.rotationX+=0.2;
			_myPixels.rotationY+=0.3;
			startRendering();
		}
		private function _move(e:MouseEvent = null):void
		{
			camera.x = (mouseX - 230) * 3;
			camera.y = (mouseY - 130) * 3;
		}
		private function _hide(e:MouseEvent = null):void
		{
			 _mySphere.visible = false;
		}
		private function _show(e:MouseEvent = null):void
		{
			 _mySphere.visible = true;
		}
	}
	
}