/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zcA
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BitmapFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;

    import frocessing.color.ColorHSV;

    import com.flashdynamix.utils.SWFProfiler;

    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]

    /**
     *
     */
    public class Main extends Sprite
    {
        private var _isMouseDown:Boolean = false;
        private var _film0:BitmapData;
        private var _film1:BitmapData;
        private var _ctf:ColorTransform;
        private var _mtx:Matrix;
        private var _hsv:ColorHSV;
        private var _filter:BitmapFilter;
        private var _zeros:Point;
        private var _particles:Vector.<Particle>;

        /**
         *
         */
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        /**
         *
         */
        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            //  setup stage.
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            //  setup debugger.
            SWFProfiler.init(this);

            var bm:Bitmap;

            _film0 = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            bm = new Bitmap(_film0);
            bm.smoothing = true;
            addChild(bm);

            _film1 = new BitmapData(stage.stageWidth >> 2, stage.stageHeight >> 2, true, 0);
            bm = new Bitmap(_film1);
            bm.transform.matrix = new Matrix(4, 0, 0, 4);
            bm.smoothing = true;
            bm.blendMode = BlendMode.ADD;
            addChild(bm);

            _mtx = new Matrix(1/4, 0, 0, 1/4);
            _ctf = new ColorTransform(.75, .75, .75, 1);
            _hsv = new ColorHSV(0, 1, 1, 1);
            _filter = new BlurFilter(16, 16, BitmapFilterQuality.LOW);
            _zeros = new Point();
            _particles = new Vector.<Particle>();

            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }

        private function enterFrameHandler(evt:Event):void
        {
            var i:uint, l:uint,
                p:Particle;

            _hsv.h = ++_hsv.h % 360;
            if (_isMouseDown)
            {
                var strength:Number,
                    angle:Number;

                strength = Math.random() * 20;
                angle = Math.random() * Math.PI * 2;
                for (i=0; i<30; i++)
                {
                    p = new Particle();
                    p.life = 200;
                    p.c = 0xFF000000|_hsv.value;
                    p.x = mouseX;
                    p.y = mouseY;
                    p.vx = Math.cos(angle) * strength;
                    p.vy = Math.sin(angle) * strength;

                    _particles.push(p);
                }
            }

            _film0.lock();
            _film0.applyFilter(_film0, _film0.rect, _zeros, _filter);
            l = _particles.length;
            for (i=0; i<l; i++)
            {
                p = _particles[i];
                p.vy += 9.8 / stage.frameRate;
                p.x += p.vx * p.life / 1200;
                p.y += p.vy * p.life / 1200;
                p.life--;

                _film0.setPixel32(p.x, p.y, p.c);

                if (!p.life)
                {
                    _particles.splice(i, 1);
                    i--;
                    l--;
                }
            }
            //_film0.colorTransform(_film0.rect, _ctf);
            _film0.unlock();

            _film1.lock();
            _film1.colorTransform(_film1.rect, _ctf);
            _film1.draw(_film0, _mtx);
            _film1.unlock();
        }

        private function mouseDownHandler(evt:MouseEvent):void
        {
            _isMouseDown = true;
        }

        private function mouseUpHandler(evt:MouseEvent):void
        {
            _isMouseDown = false;
        }
    }
}

internal class Particle
{
    public var life:uint;
    public var c:uint;
    public var x:Number, y:Number;
    public var vx:Number, vy:Number;
}
