/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zVF
 */

package {
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;    
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    
    public class PerlinNoise extends Sprite {
        private  var bmdSource : BitmapData;
        private var bmdResult : BitmapData;
        private var bitmap : Bitmap; 
        private var poscount : int = 1;
        private var color_arr : Array = [];
        private var bitmapMaskArr : Array = [];
        
        public function PerlinNoise() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;

            var myShape : Sprite = new Sprite();
            var gradientBoxMatrix : Matrix = new Matrix();
            gradientBoxMatrix.createGradientBox(255, 1, 0, 0, 0);
            myShape.graphics.beginGradientFill(GradientType.LINEAR, [0xFFCC00,  0x996600,0x5EA813,0x052E0D,0xFFFFFF,0x777777], [1, 1, 1,1,1,1], [0, 60,80, 180,189,220], gradientBoxMatrix, SpreadMethod.PAD);
            myShape.graphics.drawRect(0, 0, 256, 40);
            var bmdColor : BitmapData = new BitmapData(256, 40, false, 0);     
            bmdColor.draw(myShape)

            for (var i : Number = 0;i < 256; i++) 
            {
                var color : uint = bmdColor.getPixel32(i, 1);
                color_arr.push(color);
            }

            bmdSource = new BitmapData(2500,150, false, 0);
            var seed : Number = Math.floor(Math.random() * 10);
            bmdSource.perlinNoise(100, 150, 4, seed, true, false, 1, true, null);
            bmdResult = new BitmapData(400, 400, true, 0);
            bitmap = new Bitmap(bmdResult);
            bitmap.scaleX = bitmap.scaleY = 1.5;
            bitmap.filters = [new BlurFilter(1, 1, 3)];
            addChild(bitmap);
            
            this.addEventListener(Event.ENTER_FRAME, loop);            
        }
        
        private function loop(event : Event):void{
            bmdResult.lock();
            var pval : int;
            var maskBitmapd : BitmapData = new BitmapData(400,400, true, 0);
            for (var i : int = 0;i < 150;i++)
            {
                pval = bmdSource.getPixel(poscount, i);          
                var ofzet : Number = pval >> 16 & 0xFF;
                var h : Number = ofzet * ofzet * ofzet / (265 * 265);
                //bmdResult.setPixel(i+200,200- i+ofzet, pval)
                if(h < 3)
                {    
                    maskBitmapd.fillRect(new Rectangle(i + 20, 300 - i - 3, 5, 8), 0xFF4985B6);    
                }else{
                    maskBitmapd.fillRect(new Rectangle(i +20, 300 - i - h, 5, 8), color_arr[ ofzet ]);    
                }
            }
            bitmapMaskArr.push(maskBitmapd);
            poscount++;
            if (poscount == 2000)
            {
                poscount = 1
            }
            bmdResult.lock()
            
            bmdResult.fillRect(bmdResult.rect, 0);
            for (i  = 0;i < bitmapMaskArr.length;i++)
            {
                bmdResult.copyPixels( bitmapMaskArr[i], bmdResult.rect, new Point(i*2, i-90),null,null,true);
            }
            bmdResult.unlock();
            bitmap.bitmapData = bmdResult;
            bitmap.smoothing =true;
            if (bitmapMaskArr.length >100)
            {
              bitmapMaskArr.shift().dispose();
            }            
        }

    }
}