/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zN8
 */

package {
  import flash.display.Sprite;
  import flash.net.URLRequest;
  import flash.events.*;
  import flash.media.*;
  import flash.text.*;
  public class ch31ex3 extends Sprite {
    protected var sound:Sound;
    protected var channel:SoundChannel;
    protected var lastPosition:Number;
    protected var positionTF:TextField;
    protected var isPaused:Boolean = false;
    protected const SEARCH_RATE:int = 2000;
    public function ch31ex3() {
      createChildren();
      var songurl:String = "http://actionscriptbible.com/files/winter.mp3";
      sound = new Sound(new URLRequest(songurl));
      play();
    }
    protected function createChildren():void {
      var txtFormat:TextFormat = new TextFormat("_typewriter", 14, 0);
      var controlsTF:TextField = new TextField();
      controlsTF.defaultTextFormat = txtFormat;
      controlsTF.selectable = false;
      controlsTF.htmlText = '<a href="event:rw">&lt;&lt;</a>\t' +
        '<a href="event:pause">||</a>\t<a href="event:ff">&gt;&gt;</a>';
      controlsTF.addEventListener(TextEvent.LINK, onControlClicked);
      addChild(controlsTF);
      positionTF = new TextField();
      positionTF.defaultTextFormat = txtFormat;
      positionTF.x = controlsTF.textWidth + 15;
      addChild(positionTF);
      this.addEventListener(Event.ENTER_FRAME, updatePositionDisplay);
    }
    public function play(position:int = 0):void {
      if (channel) channel.stop();
      channel = sound.play(position);
    }
    public function rewind(event:Event = null):void {
      if (!channel) return;
      isPaused = false;
      lastPosition = channel.position - SEARCH_RATE;
      lastPosition = Math.max(0, lastPosition);
      play(lastPosition);
    }
    public function fastForward():void {
      if (!channel) return;
      isPaused = false;
      lastPosition = channel.position + SEARCH_RATE;
      lastPosition = Math.min(sound.length, lastPosition);
      play(lastPosition);
    }
    public function pause():void {
      lastPosition = channel.position;
      channel.stop();
    }
    public function resume():void {
      play(lastPosition);
    }
    protected function updatePositionDisplay(event:Event):void {
      if (channel && sound) {
        positionTF.text = (channel.position/1000).toFixed(2) + " / " +
                          (sound.length/1000).toFixed();
      }
    }
    protected function onControlClicked(event:TextEvent):void {
      switch (event.text) {
        case "pause":
          (isPaused)? resume() : pause();
          isPaused = !isPaused;
          break;
        case "rw": rewind(); break;
        case "ff": fastForward(); break;
      }
    }
  }
}