/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zI1
 */

package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	import sliz.miniui.Label;
	import sliz.miniui.Silder;
	import sliz.utils.UIUtils;

	public class TestProjectVectors extends Sprite {
		private var l:Label;
		private var m:Matrix3D;
		private var v:Vector3D;

		public function TestProjectVectors() {
			l = new Label("", this,0,0,456);
			
			
			var pp:PerspectiveProjection = new PerspectiveProjection();
			m = pp.toMatrix3D();
			v = new Vector3D(1000, 1000, 1);
			var silder:Silder = new Silder(0, 100, this, "num", sf);
			
			UIUtils.changeStage(stage);
		}
		
		private function sf(v1:Number):String
		{
			var rv:Number = v1// * 1000;
			v.z = rv;
			l.text = "";
			var ps:Vector.<Number> = new Vector.<Number>();
			var uvts:Vector.<Number> = new Vector.<Number>();
			Utils3D.projectVectors(m, Vector.<Number>([v.x, v.y, v.z]), ps, uvts);
			trace("Utils3D.projectVectors", ps, uvts);
			var v2:Vector3D = Utils3D.projectVector(m, v);
			trace("Utils3D.projectVector", v2, "w", 1/v2.w);
			var v3:Vector3D =  projectVector(m, v);
			trace("projectVector", v3, v3.w);
			return v + "";
		}

		private function projectVector(m:Matrix3D, v:Vector3D):Vector3D {
			var rv:Vector3D = new Vector3D();
			var focalLength:Number = m.rawData[0];
			rv.z = focalLength / v.z//(focalLength + v.z);
			rv.x = rv.z * v.x;
			rv.y = rv.z * v.y;
			rv.w = 1 / v.z;
			return rv;
		}
		
		private function trace(...arg):void {
			l.appendText(arg.join(" "));
			l.appendText("\n");
		}
	}
}
