/**
 * Copyright hacker_47ryxtat ( http://wonderfl.net/user/hacker_47ryxtat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2zCj
 */

// forked from Murai's forked from: level0_CircleChainClock!
// forked from Murai's level0_CircleChainClock!
// forked from 9re's forked from: Steiner Chain version 1
// forked from paq's 超超超シンプル時計。

package {
	import flash.display.*;
	import flash.utils.*;
	import flash.events.*;
	import flash.text.*;
	import flash.geom.*;
	import flash.filters.*;
	/*
		@author Takashi Murai(KAYAC)
	*/

	[SWF(width="465",height="465",backgroundColor="0xFFFFFF",frameRate="60")];
	public class CircleChainClock extends Sprite {
		private var font:Class;
		public var textField:TextField = new TextField();
		public var date:Date;
		public var str:String = new String();

		private var _scale:Number = 75;
		private var _cx:Number;
		private var _cy:Number;

		private var Canvas:Sprite=new Sprite();
		private var Hs:Sprite=new Sprite();
		private var Ms:Sprite=new Sprite();
		private var Ss:Sprite=new Sprite();
		private var MSs:Sprite=new Sprite();
		private var _bmd:BitmapData;

		private static  const P:Point = new Point();
		private static  const BLUR:BitmapFilter = new BlurFilter( 16, 16, 1 );
		private static  const ALPHA:ColorTransform= new ColorTransform( 1, 1, 1, 0.85, 0, 0, 0, 0 );

		public function CircleChainClock() {

			_bmd= new BitmapData( 465, 465, true, 0x00000000 );
			addChild( new Bitmap(_bmd ) );

			var format:TextFormat = new TextFormat();
			format.font = "_sans";
			format.align="center";
			format.size = 20;
			format.color = 0x000000;
			//
			textField.defaultTextFormat = format;
			textField.text=" ";
			textField.x = 0;
			textField.y = 465/2-textField.textHeight/2;
			textField.width = 465;
			
			Hs.alpha=0.25;
			Ms.alpha=0.25;
			Ss.alpha=0.75;
			MSs.alpha=0.25
			;
			Canvas.addChild(Hs);
			Canvas.addChild(Ms);
			Canvas.addChild(Ss);
			Canvas.addChild(MSs);
			Canvas.addChild(textField);
			addChild(Canvas);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		public function drawSteiner(n:int,sp:Sprite,nR:Number):void {
    
                        sp.graphics.clear();
                        if(n<3)return
                        
			var r:Number = nR;
			var X:Number = ((new Date().seconds-1)*1000+new Date().milliseconds)/60000;
			var Y:Number = ((new Date().seconds-1)*1000+new Date().milliseconds)/60000;
			var t:Number = Math.PI / n;
			var rho:Number = r * Math.sin(t) / (1 - Math.sin(t));
			t = 2 * t;
			var s:Number;

			_cx = stage.stageWidth / 2;
			_cy = stage.stageHeight / 2;


			for (var i:int = 0; i < n; ++i) {
				s = i * t + Math.PI / 2;
				sp.graphics.beginFill(0x00000);
				draw(X + (r + rho) * Math.cos(s), Y + (r + rho) * Math.sin(s), rho,sp);
				sp.graphics.endFill();
			}
		}

		public function draw(cx:Number, cy:Number, cr:Number, sp:Sprite):void {
			var c:Number = cx * cx + cy * cy - cr * cr;
			var rx:Number, ry:Number, rr:Number;
			rx = cx / c * _scale + _cx;
			ry = -cy / c * _scale + _cy;
			rr = cr / c * _scale;

			sp.graphics.drawCircle(rx, ry, rr);
		}
		
		private function glower():void {
			_bmd.applyFilter( _bmd, _bmd.rect, P, BLUR );
			_bmd.colorTransform( _bmd.rect, ALPHA );
			_bmd.draw( Canvas );
		}
		
		private function onEnterFrame(e:Event):void {
			date = new Date();
			str ="";
			str += (date.hours < 10 ? "0" : "") + date.hours;
			str += " ";
			str += (date.minutes < 10 ? "0" : "") + date.minutes;
			str += " ";
			str += (date.seconds < 10 ? "0" : "") + date.seconds;
			textField.text = str;


			glower();
			drawSteiner(date.hours,Hs,1);
			drawSteiner(date.minutes,Ms,0.8);
			drawSteiner(date.seconds,Ss,0.5);
			drawSteiner(date.milliseconds/3,MSs,0.5);
		}
	}
}