/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2yid
 */

package {
	import flash.display.*;
	import flash.events.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	// ChangeSphereMaterialSample クラス
	public class Main extends BasicView {
		private var shpere:Sphere; // 球体
		private var wire_btn:Sprite;
		private var color_btn:Sprite;
		public function Main() {
			wire_btn = new Sprite();
			wire_btn.graphics.beginFill(0x00ff00);
			wire_btn.graphics.drawRect(100, 30, 100, 30);
			wire_btn.graphics.endFill();
			addChild(wire_btn);
			wire_btn.buttonMode = true;
			
			color_btn = new Sprite();
			color_btn.graphics.beginFill(0x00ff00);
			color_btn.graphics.drawRect(100, 80, 100, 30);
			color_btn.graphics.endFill();
			addChild(color_btn);
			color_btn.buttonMode = true;
			
			// 初期はカラーマテリアルを適用
			var material:ColorMaterial = new ColorMaterial(0xFF0000);
			
			// プリミティブオブジェクトの球体を作成
			shpere = new Sphere(material, 400);
			scene.addChild(shpere);
			
			// タイムラインに配置した3つのボタンの制御
			color_btn.addEventListener(MouseEvent.CLICK, clickHandler);
			wire_btn.addEventListener(MouseEvent.CLICK, clickHandler);
			//bmp_btn.addEventListener(MouseEvent.CLICK, clickHandler);
			
			// レンダリング開始
			startRendering();
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		// ボタンがクリックされたときに
		private function clickHandler(e:MouseEvent):void {
			// materialマテリアルプロパティに新しいマテリアルを指定して差し替える
			switch(e.currentTarget) {
				case color_btn:
					shpere.material = new ColorMaterial(0xFF0000);
					break;
				case wire_btn:
					shpere.material = new WireframeMaterial(0xFF0000);
					break;
				//case bmp_btn:
					//shpere.material = new BitmapAssetMaterial("SampleImage");
					//break;
			}
		}
		
		private function loop(e:Event):void {
			shpere.rotationY += 2;
		}
	}
}
