/**
 * Copyright Kitosan1986 ( http://wonderfl.net/user/Kitosan1986 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2yco
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.text.*;
    import flash.geom.Rectangle;

   
    public class FlashTest extends Sprite {
        private var canvas:BitmapData;
        private var textCanvas:BitmapData;
        private var particles:Array;
        private var _num:int;


        public function FlashTest() {
            // write as3 code here..
            
            //bitmapdataを背景にする
            canvas = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
            addChild( new Bitmap(canvas) ); //この書き方でBitmapDataをBitmapに乗せて表示できる
            
            //TextFieldを作成
            var tf:TextField = new TextField;
            tf.defaultTextFormat = new TextFormat("Swis721 BdRndBT",60,0xFFFF00);
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.text = "Text";
            
            //BitmapDataを作成し、TextField(DisplayObject)をコピー
            textCanvas = new BitmapData(tf.textWidth,tf.textHeight,false,0x000000);
            textCanvas.draw(tf);
            particles = new Array();
            //addChild( new Bitmap(textCanvas) );
            createText();//テキストフィールドからピクセルを取り出し、作成
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            //stage.addEventListener(MouseEvent.CLICK,onClick);
        }
           
        public function createText():void{
            //textCanvasの１pixelごとに色を取得していき、もし黒以外の色であれば、ピクセルを作成
            var ofx:Number = stage.stageWidth/2 - textCanvas.width/2;
            var ofy:Number = stage.stageHeight/2 - textCanvas.height/2;
            for ( var ex:Number = 0;ex < textCanvas.width;ex++){
                for (var ey:Number = 0;ey < textCanvas.height;ey++){
                    var c:uint = textCanvas.getPixel(ex,ey);
                    if(c != 0x000000){
                        createParticle(ex + ofx,ey + ofy,c);
                        
                    }
                }
            }
          }
         public function createParticle(ex:Number,ey:Number,c:int):void{
            //色の情報と、位置の情報を取得し配列に格納する。点一つ一つがParticleクラスのインスタンス
            var p:Particle = new Particle();
            p.ex = ex;
            p.ey = ey;
            p.c = c;
            initParticle(p);//初期位置。ばらばら。
            particles.push(p)
            canvas.setPixel(p.x,p.y,p.c);//canvasにピクセルを配置
            _num = 0;
        }
        
        public function initParticle(p:Particle):void{
            //位置の情報を元に、ランダムで散らばるようなファンクションを作成する。
            var rad:Number = Math.random()*(Math.PI*2);
            var dis:Number = Math.random()*400;
            p.x = p.ex+ dis * Math.cos(rad);
            p.y = p.ey + dis * Math.sin(rad);
        }

         private function onEnterFrame( evt:Event ):void{
            //キャンバス自体は黒でロックをしておく。
            canvas.lock();//setPixel時の画面の更新をロック（EnterFrameイベントごとに更新されるため無駄だから）
            canvas.fillRect( canvas.rect,0x000000 );

            for (var i:int = 0;i<_num;i++){
                var p:Particle = particles[i];
                if(Math.abs(p.ex - p.x)<0.5 &&Math.abs(p.ey-p.y)<0.5){
                    p.x = p.ex;
                    p.y = p.ey;
                }else{
                    p.x += (p.ex - p.x)*0.4;
                    p.y += (p.ey - p.y)*0.4;
                }
                canvas.setPixel(p.x,p.y,p.c);
            }
            var n:int = particles.length;
            _num = (_num +10<n)?_num + 10:n;
            //１０を足す。もし、１０を足すと超えてしまうならマックスの値をとる()サンプルだと１００だった。
            canvas.unlock();
        }

            
        
    }
}

//外部クラス：パーティクル。座標、相対座標、色、他
class Particle{
    public var x:Number;
    public var y:Number;
    public var ex:Number;
    public var ey:Number;
    public var c:int;
    public function Particle(){
        x = 0;
        y = 0;
        ex = 0;
        ey = 0;
        c = 0;
    }
}