/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2yIT
 */

// forked from ANTON072's Sprites on a Circle
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    
    public class Circle extends Sprite {
        private const RADIUS:Number = 150;
        
        private var _floorObj:Sprite;
        private var _obj/*Sprite*/:Array;
        private var _clickedNum:int = -1;
        private var _angle:Number = 0;
        private var _timer:Timer;
        
        public function Circle() {
            // write as3 code here..
            _obj = [];
            
            for (var i:int = 0; i < 12; i++) {
                var sp:Sprite = new Sprite();
                sp.graphics.beginFill(Math.random() * 0xFFFFFF);
                //sp.graphics.drawCircle(0, 0, 30);
                sp.graphics.drawRect(-20,-20,40,40);
                sp.graphics.endFill();
                _obj.push(sp);
                var num:Number = _obj.length -1;
                this.addChild(_obj[num]);
                _obj[num].buttonMode = true;
                
                _obj[num].name = String(num);
                _obj[num].x = this.stage.stageWidth / 2;
                _obj[num].y = this.stage.stageHeight / 2;
                _obj[num].scaleX = _obj[num].scaleY = 0;
                _obj[num].addEventListener(MouseEvent.CLICK, _onClick);
            }
            
            _floorObj = new Sprite();
            _floorObj.graphics.beginFill(0xFF0000);
            _floorObj.graphics.drawRect(0, 0, this.stage.stageWidth, this.stage.stageHeight);
            _floorObj.graphics.endFill();
            _floorObj.alpha = 0;
            _floorObj.addEventListener(MouseEvent.CLICK, _onFloorClick);
            this.addChildAt(_floorObj, 0);
            
            _timer = new Timer(33);
            _timer.addEventListener(TimerEvent.TIMER, _loop);
            _timer.start();
        }
        
        private function _onClick(e:MouseEvent):void {
            if (_clickedNum == int(e.target.name)) {
                _clickedNum = -1;
            }
            else {
                _clickedNum = int(e.target.name);
            }
        }
        
        private function _onFloorClick(e:MouseEvent):void {
            _clickedNum = -1;
        }
        
        private function _loop(e:TimerEvent):void {
            _angle += .002;
            for (var i:int = 0; i < _obj.length; i++) {
                var pos:Point = new Point();
                var scale:Number;
                
                if (_clickedNum == i) {
                    pos.x = this.stage.stageWidth / 2;
                    pos.y = this.stage.stageHeight / 2;
                    scale = 1;
                }
                else {
                    pos.x = this.stage.stageWidth / 2 + RADIUS * Math.cos(_angle + i / _obj.length * Math.PI * 2);
                    pos.y = this.stage.stageHeight / 2 + RADIUS * Math.sin(_angle + i / _obj.length * Math.PI * 2);
                    scale = .3;
                }
                _obj[i].x += (pos.x - _obj[i].x) / 5;
                _obj[i].y += (pos.y - _obj[i].y) / 5;
                _obj[i].scaleX += (scale - _obj[i].scaleX) / 5;
                _obj[i].scaleY += (scale - _obj[i].scaleY) / 5;
            }
        }
    }
}