/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2xhS
 */

/******************************
 *          Blazin'           *
 *----------------------------*
 *  Sprite trail from Sprite  *
 ******************************/
 
package
{
    import com.bit101.components.*;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    import flash.display.*;
    import flash.geom.*;
   
    [SWF(frameRate = 60)]
    public class Blazin extends Sprite {
        
        internal var stageLabel :Label;
        
        internal var birthSprite :Sprite = new Sprite;
        internal var trailArray  :Array  = new Array;
        
        public function Blazin()
        {
            stageLabel = new Label(stage, 4, 3, "");
            
            for (var i:int = 0; i < 10; i++)
            { 
                trailArray[i] = new Sprite;
                addChild(trailArray[i]);
                
                trailArray[i].graphics.beginFill (0xFF0000, 1);
                trailArray[i].graphics.drawRect  (0, 0, 50, 50);
                trailArray[i].graphics.endFill   ();
                
                trailArray[i].alpha = 0;
            }
            
            addChild(birthSprite);
            
            birthSprite.graphics.beginFill (0, 0.75);
            birthSprite.graphics.drawRect  (0, 0, 40, 40);
            birthSprite.graphics.endFill   ();
            
            birthSprite.x = ((stage.stageWidth/2) - (birthSprite.width/2));
            birthSprite.y = ((stage.stageHeight/2) - (birthSprite.height/2));
            
            birthSprite.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        internal var firstPoint   :Point = new Point;
        internal var currentPoint :Point = new Point;
        internal var calcPoint    :Point = new Point;
        
        internal var traverseToggle :Boolean = false;
        
        internal var centerInit  :Point = new Point;
        internal var centerTrail :Point = new Point;

        internal function onMouseDown($e:MouseEvent) :void
        {
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            
            firstPoint = new Point(mouseX, mouseY);
        }
    
        internal function onMouseMove($e:MouseEvent) :void
        {
            traverseToggle = true;
            
            currentPoint = new Point(mouseX, mouseY);
            calcPoint = Point(currentPoint.subtract(firstPoint));
            
            birthSprite.x = (birthSprite.x + calcPoint.x);
            birthSprite.y = (birthSprite.y + calcPoint.y);
            
            firstPoint = currentPoint;
        }
        
        internal function onMouseUp($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            traverseToggle = false;
        }
        
        internal function onEnterFrame($e:Event) :void
        {
            centerInit .x = (birthSprite.width / 2);
            centerInit .y = (birthSprite.height / 2);
            
            if (traverseToggle)
            {
                for (var i:int = 0; i < 10; i++)
                {
                    centerTrail.x = (trailArray[i].width / 2);
                    centerTrail.y = (trailArray[i].height / 2);             
                    
                    trailArray[i].x = ((birthSprite.x + (centerInit.x - centerTrail.x)) - (calcPoint.x * (i*0.75)));
                    trailArray[i].y = ((birthSprite.y + (centerInit.y - centerTrail.y)) - (calcPoint.y * (i*0.75)));
                    
                    trailArray[i].alpha  = (Math.abs(i-10) / 11);
                    trailArray[i].width  = (Math.abs(i-10) * 3.75);
                    trailArray[i].height = (Math.abs(i-10) * 3.75);
                }
            }else{
                for (var j:int = 0; j < 10; j++)
                {
                    var delta :Point = new Point;
                    
                    if (j == 0)
                    {
                        delta.x = ((birthSprite.x + (centerInit.x - (trailArray[j].width / 2))) - trailArray[j].x);
                        delta.y = ((birthSprite.y + (centerInit.y - (trailArray[j].height / 2))) - trailArray[j].y);
                    }else{
                        delta.x = ((trailArray[0].x + (centerInit.x - (trailArray[j].width / 2))) - trailArray[j].x);
                        delta.y = ((trailArray[0].y + (centerInit.y - (trailArray[j].height / 2))) - trailArray[j].y);
                    }

                    trailArray[j].alpha -= Math.abs((delta.x + delta.y) / 2) * 0.005;

                    trailArray[j].x += delta.x / 10;
                    trailArray[j].y += delta.y / 10;
                }
            }
        }    
    }
}