/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2xWf
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var grid:Array = [];
            var r:int;
            var c:int;
            var cell:Cell;
            
            for( r = 0; r < 20; r++){
                grid[r] = [];
                for(c = 0; c < 20; c++){
                    cell = new Cell(r,c);
                    addChild(cell);
                    grid[r].push(cell);
                }
            }
            
            for( r = 0; r < 20; r++){
                for(c = 0; c < 20; c++){
                    cell = grid[r][c];
                    cell.n = r > 0 ? grid[r-1][c] : null;
                    cell.ne = r > 0 && c < 19 ? grid[r-1][c+1] : null;
                    cell.nw = r > 0 && c > 0 ? grid[r-1][c-1] : null;
                    cell.e = c < 19 ? grid[r][c+1] : null;
                    cell.s = r < 19 ? grid[r+1][c] : null;
                    cell.se = r < 19 && c < 19 ? grid[r+1][c+1] : null;
                    cell.sw = r < 19 && c > 0 ? grid[r+1][c-1] : null;
                    cell.w = c > 0 ? grid[r][c-1] : null;
                }
            }
        }
    }
}

import flash.utils.Dictionary;
import flash.events.MouseEvent;

import flash.display.Sprite;
import flash.events.Event;
import flash.display.DisplayObjectContainer;

class Cell extends Sprite
{
    public var row:int;
    public var col:int;
    public var payload:Payload;
    
    public var n:Cell;
    public var ne:Cell;
    public var nw:Cell;
    public var e:Cell;
    public var s:Cell;
    public var se:Cell;
    public var sw:Cell;
    public var w:Cell;
    
    public function Cell(r:int, c:int):void
    {
        this.row = r;
        this.col = c;
        
        this.graphics.beginFill(0,0.1);
        this.graphics.drawRect(0,0,20,20);
        this.graphics.endFill();
        this.x = c * 20;
        this.y = r * 20;

        addEventListener(Event.ADDED_TO_STAGE, onStage);
    }
    
    
    private function onStage(event:Event):void
    {
        this.removeEventListener(Event.ADDED_TO_STAGE, onStage);
        createPayload(row, col, stage);    
        
        this.addEventListener(MouseEvent.CLICK, onClick);
    }
    
    private function onClick(event:MouseEvent):void
    {
        if( !this.payload )
            return;
            
        this.payload.blobCount = 0;
        this.payload.clearVisitLog();
        blobMatch(this.payload);
        
        if( this.payload.blobCount > 2 )
        {
            this.payload.clearVisitLog();
            showBlobMatches(this.payload);
        }
        
    }
    
    private function showBlobMatches( payload:Payload ):void
    {
        if( !this.payload )
            return;
            
        if( payload.type != this.payload.type )
            return;
            
        if( payload.hasVisited( this ))
             return;
         
        payload.logVisit(this);
        
        this.payload.showMatchState();
        
        if( n ) n.showBlobMatches( payload );
        if( ne ) ne.showBlobMatches( payload );
        if( nw ) nw.showBlobMatches( payload );
        if( e ) e.showBlobMatches( payload );
        if( s ) s.showBlobMatches( payload );
        if( se ) se.showBlobMatches( payload );
        if( sw ) sw.showBlobMatches( payload );
        if( w ) w.showBlobMatches( payload );
    }

    private function blobMatch( payload:Payload ):void
    {
        if( !this.payload )
            return;
            
        if( payload.type != this.payload.type )
            return;
            
        if( payload.hasVisited( this ))
             return;
         
        payload.logVisit(this);
        payload.blobCount++;
        
        if( n ) n.blobMatch( payload );
        if( ne ) ne.blobMatch( payload );
        if( nw ) nw.blobMatch( payload );
        if( e ) e.blobMatch( payload );
        if( s ) s.blobMatch( payload );
        if( se ) se.blobMatch( payload );
        if( sw ) sw.blobMatch( payload );
        if( w ) w.blobMatch( payload );
    }

    
    public function createPayload(r:int, c:int, container:DisplayObjectContainer):void
    {
        this.payload = new Payload(r, c);
        container.addChild(this.payload);
    }
    
}

class Payload extends Sprite
{
     public var row:int;
     public var col:int;
     public var type:int;
     public var blobCount:int;
     
     private var _visitLog:Dictionary;
     
     public function Payload(r:int, c:int):void
     {
         clearVisitLog();
         
         this.row = r;
        this.col = c;
        var colours:Array = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00, 0x00FFFF];
        var rnd:Number = Math.floor(Math.random() * colours.length);
        this.type = rnd;
        this.graphics.beginFill(colours[rnd]);
        this.graphics.lineStyle(0.1,0);
        this.graphics.drawRect(0,0,20,20);
        this.graphics.endFill();
        this.x = 20 * c;
        this.y = 20 * r;
        this.mouseEnabled = false;
        this.mouseChildren = false;
     }
     
     public function clearVisitLog():void
     {
         _visitLog = new Dictionary();
     }

     public function logVisit( cell:Cell ):void
     {
         _visitLog[cell] = true;
     }

     public function hasVisited( cell:Cell ):Boolean
     {
         if( _visitLog[cell] )
             return true;
                    
         return false;
     }
     
     public function showMatchState():void
     {
        this.graphics.clear();
        this.graphics.beginFill(0);
        this.graphics.lineStyle(0.1,0);
        this.graphics.drawRect(0,0,20,20);
        this.graphics.endFill();
     }

     
     

}

