/**
 * Copyright agenda23 ( http://wonderfl.net/user/agenda23 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2xTk
 */

package 
{
	import flash.display.Sprite;
	import flash.display.*;
	import flash.events.Event;
	
	import flash.geom.*;
    import flash.filters.*;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.system.System;
	
	
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	
	
	import net.hires.debug.Stats;
	import com.flashdynamix.motion.*;
	import com.flashdynamix.motion.easing.*;
	import fl.motion.easing.*;
	
	
	/**
	 * ...
	 * @author mi55ile
	 */
	
	 public class Main extends Sprite 
	{
		private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var objPlane:Plane;
		
		public function Main():void 
		{
			stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            init3D();
			addChild(new Stats({ bg: 0x1A1A1A }));
		}
		
		
		private function init3D():void
        {
            viewport = new Viewport3D(0,0,true);
            viewport.opaqueBackground = 0x000000;
            addChild(viewport);

            renderer = new BasicRenderEngine();

            camera = new Camera3D();
            camera.z = -450;
            camera.focus = 500;
            camera.zoom = 1;

            scene = new Scene3D();

            var colorMat:ColorMaterial = new ColorMaterial( 0x222222, 1 );
            var wireMat:WireframeMaterial = new WireframeMaterial( 0x08FF10 );
            var compoMat:CompositeMaterial = new CompositeMaterial();
            compoMat.addMaterial(colorMat);
            compoMat.addMaterial(wireMat);
            compoMat.doubleSided = true;

            objPlane = new Plane(compoMat,300,300,10,10);
            scene.addChild(objPlane);
			
            addEventListener(Event.ENTER_FRAME, onEnterFrame); 
            renderer.renderScene(scene, camera, viewport);
			}
			
		private function onEnterFrame(event:Event):void
        {
            objPlane.rotationY = stage.mouseX;
            objPlane.rotationX = stage.mouseY;
            objPlane.rotationZ += 0.4;
			  
            renderer.renderScene(scene, camera, viewport);
			
        }
		
        }

		
	}
	