/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2x6C
 */

package {
  import com.actionscriptbible.Example;

  public class ch12ex7 extends Example {
    public function ch12ex7() {
      //CONSTRUCTING REGULAR EXPRESSIONS
      
      trace("---- normal characters");
      trace("are you thinking what I'm thinking?".match(/think/g));
      //think,think
      trace("rub a dub dub, three men in a tub".match(/ub/g));
      //ub,ub,ub,ub
      
      trace("---- escaped characters");
      trace("c:\\windows\\"); //c:\windows\
      var re:RegExp = /I have a \$5 bill \& his\/her ID card\./;
      
      trace("---- character classes");
      var phoneNumberPattern:RegExp = /\d\d\d-\d\d\d-\d\d\d\d/;
      trace("the cat sat on the mat".match(/[msc]at/g)); //cat,sat,mat
      trace("abcdefghijklmnopqrstuvwxyz".match(/[a-cmx-z]/g)); //a,b,c,m,x,y,z      
      trace("roger dodger".match(/[^oge\s]/g)); //r,r,d,d,r
      
      trace("---- quantifiers");
      trace(/\w+:\s*\$\d+/.test("soup:          $40")); //true
      var betterPhoneNumber:RegExp = /\(?\d{3}\)?-?\d{3}-?\d{4}/;
      trace(betterPhoneNumber.test("(703)555-1234")); //true
      trace(betterPhoneNumber.test("310-555-1515")); //true
      trace(betterPhoneNumber.test("7245559090")); //true
      trace("a thousand thousandss!".match(/thousands*/g)); //thousand,thousandss      
      
      trace("---- anchors and boundaries");
      var contactText:String = 
          "Call us at one of these numbers.\n" +
          "Los Angeles: 310-555-2910\n" + 
          "New York: 212-555-2499\n" + 
          "Boston: 617-555-7141";
      var officeAndPhone:RegExp = /^([\w\s]+): (\d{3}-\d{3}-\d{4})/gm;

      var officeAndPhone:RegExp = /^([\w\s]+): (\d{3}-\d{3}-\d{4})$/;
      trace(officeAndPhone.test(">>>New York: 212-555-2499")); //false
      trace(officeAndPhone.test("New York: 212-555-2499 (fax)")); //false

      var usingBoundary:RegExp = /\bzarflax\b/i;
      var noBoundary:RegExp = /zarflax/i;

      var garbage:String = "asndzarflaxhtewio";
      trace(usingBoundary.test(garbage)); //false
      trace(noBoundary.test(garbage)); //true
      
      var dialogue:String = "Nice try, Zarflax!";
      trace(usingBoundary.test(dialogue)); //true
      trace(noBoundary.test(dialogue)); //true
      
      var fakingBoundary:RegExp = /\Wzarflax\W/i;
      trace(garbage.match(fakingBoundary)); //(null)
      trace(dialogue.match(fakingBoundary)); // Zarflax!

      trace("---- alternation");
      var friends:RegExp = /leigh|mariko|neal|oskar|paula/gi;
      
      trace("---- groups");
      var rhymes:RegExp = /\b(tr|r|sp|b)a(c|s)e\b/gi;
      var str:String = "trace() the race to the orbiting base in outerspace";
      trace(str.match(rhymes)); //trace,race,base

      trace("the cat goes mew meow mewmew meow!".match(/(meo?w\s*)+/));
      //mew meow mewmew meow,meow
    }
  }
}