/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2wf8
 */

package 
{
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.DisplayObjectContainer;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
        

    /**
     * ...
     * @author YopSolo
     */

    public class Main extends Sprite 
    {
        private var PIX_STRENGTH:Number = .75; // adjust effect here
        private var HALF_STAGE_WIDTH:int = 233;        
        private var URL_IMAGE:String = "http://yopsolo.fr/ressources/girl-lightsaber.png";

        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }       

        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0x333333);
            bg.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            bg.cacheAsBitmap = true;
            addChild( bg );         
            
            buildTextField(this, "Tip 9 : Pixelize Effect",0,390);

            // add custom menu
            new CustomMenu(this);
            run();
        }

        private function run():void 
        {
            var l:Loader = new Loader();
            // bonjour madame :D
            l.load( new URLRequest(URL_IMAGE), new LoaderContext(true) );
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, _pixelizeMe );
            addChild( l );
        }
        
        private function _pixelizeMe(e:Event):void 
        {
            if ( PIX_STRENGTH >= 1.0 )
            {
                PIX_STRENGTH  = 0.99;
            }            
            // original image
            var bmp:Bitmap = (e.target as LoaderInfo).content as Bitmap;
            bmp.smoothing = true;
            // downsample
            var scale:Number = (1 - PIX_STRENGTH);
            var dat:BitmapData = new BitmapData( Math.max( 1, int(scale * bmp.width) ), Math.max( 1, int(scale * bmp.height)) ,bmp.bitmapData.transparent, 0x0);
            var mtx:Matrix = new Matrix(scale, 0, 0, scale);
            dat.draw( bmp, mtx );
            // create a new display Object
            var copy:Bitmap = new Bitmap(dat);
            copy.smoothing = false;
            addChild( copy );
            
            // scale original to fit on screen
            var ratio:Number = HALF_STAGE_WIDTH / bmp.width;
            bmp.scaleX = bmp.scaleY = ratio;
            // scale the copy
            copy.x = bmp.width;
            copy.scaleX = copy.scaleY = 1 / scale;
            copy.width = bmp.width;
            copy.height = bmp.height;
        }
        
        private function buildTextField(doc:DisplayObjectContainer, txt:String, x:int = 0, y:int = 0):TextField
        {
            var fmt:TextFormat = new TextFormat;
            fmt.color = 0xFFFFFF;
            fmt.font = 'Arial'; //(new FONT_HARMONY() as Font).fontName;
            fmt.size = 11; // 8;
            var tf:TextField = new TextField;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.opaqueBackground = 0x0; // opaque background allow a perfect font rendering even in StageQuality.LOW mode
            tf.selectable = false;
            //tf.embedFonts = true;
            tf.defaultTextFormat = fmt;
            tf.text = txt;
            tf.x = x;
            tf.y = y;
            
            doc.addChild(tf);

            return tf;

        }         
        
        
    }
}

import flash.display.Sprite;
import flash.events.ContextMenuEvent;
import flash.net.navigateToURL;
import flash.net.URLRequest;
import flash.ui.ContextMenu;
import flash.ui.ContextMenuItem;

class CustomMenu
{
    private const NAME:String = "Flash Tips Collection : 'Pixelize effect'";   

    public function CustomMenu(ref:Sprite):void
    {
        var appContextMenu:ContextMenu = new ContextMenu;
        appContextMenu.hideBuiltInItems();
        var cmi:ContextMenuItem = new ContextMenuItem(NAME);
        var credits:ContextMenuItem = new ContextMenuItem("by YopSolo");
        appContextMenu.customItems.push(cmi);
        appContextMenu.customItems.push(credits);
        cmi.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCollection);
        credits.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCredits);
        ref.contextMenu = appContextMenu;
    }
    
    private function _onClickCollection(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr/wp/2012/01/14/flash-tips-collection/'), '_blank');
    }

    private function _onClickCredits(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr'), '_blank');
    }
}