/**
 * Copyright test12 ( http://wonderfl.net/user/test12 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2wUa
 */

// forked from actionscriptbible's forked from: Chapter 34 Example 14
// party version lulz
package {
  import flash.display.*;
  import flash.events.Event;
  import flash.filters.BlurFilter;
  import flash.geom.ColorTransform;
  import flash.geom.Point;
  import flash.net.*;
  import flash.utils.ByteArray;
  import flash.utils.getTimer;

  [SWF(backgroundColor="#000000", frameRate="45")]
  public class ch34ex14fork extends Sprite {
    protected var plasma:Shader;
    protected var shape:Shape;
    protected var bmp:BitmapData;
    
    protected const DIM_AMT:Number = 0.94;
    protected const DIM:ColorTransform = new ColorTransform(DIM_AMT, DIM_AMT, DIM_AMT);
    protected const BLUR:BlurFilter = new BlurFilter(1, 16, 1);

    public function ch34ex14fork() {
      plasma = new Shader();
      bmp = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
      var bitmap:Bitmap = new Bitmap(bmp, PixelSnapping.NEVER, false);
      addChild(bitmap);
      shape = new Shape();
      shape.x = stage.stageWidth/2; shape.y = stage.stageHeight/2;
      shape.blendMode = BlendMode.ADD;
      addChild(shape);
      var loader:URLLoader = new URLLoader();
      loader.dataFormat = URLLoaderDataFormat.BINARY;
      //plasma shader courtesy the inimitable mrdoob (Ricardo Cabello)
      loader.load(new URLRequest(
        "http://actionscriptbible.com/files/mrdoob-plasma.pbj"));
      loader.addEventListener(Event.COMPLETE, onLoadComplete);
    }
    
    protected function onLoadComplete(event:Event):void {
      var loader:URLLoader = URLLoader(event.target);
      plasma.byteCode = ByteArray(loader.data);
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    protected function onEnterFrame(event:Event):void {
      //this demo code also by mrdoob
      plasma.data.center.value = [Math.sin(getTimer() * .002) * 300 + (stage.stageWidth >> 1), Math.cos(getTimer() * .0001) * 300 + (stage.stageHeight >> 1)];
      plasma.data.wave.value = [Math.sin(getTimer() * .001) * .06 + 0.01, Math.cos(getTimer() * .00005) * .05];
      plasma.data.offset.value = [Math.sin(getTimer() * .004) * 200, Math.cos(getTimer() * .0003) * 200];
      plasma.data.color_offset.value = [Math.sin(getTimer() * .002) * 2, Math.sin(getTimer() * .00009) * 2, Math.cos(getTimer() * .00005) * 2];
      plasma.data.distort.value = [Math.sin(getTimer() * .0008) * .05];
      
      bmp.colorTransform(bmp.rect, DIM);
      bmp.applyFilter(bmp, bmp.rect, new Point(), BLUR);
      bmp.draw(stage);
      
      shape.graphics.clear();
      shape.graphics.lineStyle(6, 0, 1, false, null, CapsStyle.NONE);
      shape.graphics.lineShaderStyle(plasma);
      drawLissajous();
    }
    
    protected function drawLissajous():void {
      var W:Number = stage.stageWidth, H:Number = stage.stageHeight;
      var a:Number = 1;
      var b:Number = 4;
      shape.graphics.moveTo(-.5*W, 0);
      for (var x:Number = 0; x < W; x += b) {
        var y:Number = Math.sin((x/W)*8*Math.PI)*(H/2)*(.3+Math.random()*.7);
          shape.graphics.lineTo(x-.5*W, y);
      }
    }
  }
}