/**
 * Copyright geta ( http://wonderfl.net/user/geta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2v4B
 */

// forked from webgyo's forked from: Pixel Bender (円状にサインカーブで波打つフィルタ)
// forked from hakuhin's Pixel Bender (円状にサインカーブで波打つフィルタ)
// -------------------------------------------------
//
// 円状にサインカーブで波打つフィルタ
// 
//　
//　中心から垂直に捻ってます。
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;

    public class Main extends Sprite {

    	    public var board : Sprite;       	 // フィルタを適応するスプライト

        public function Main() {

 			// フレームレート       
 			stage.frameRate = 60;
	
			// 100%表示
			stage.scaleMode = StageScaleMode.NO_SCALE;
	
			// 左上
			stage.align = StageAlign.TOP_LEFT;
			stage.align = "TL";
			
			// スプライトを配置
			board = new Sprite();
			addChild(board);
	
			// リソース読み込み開始
			load();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load():void{

	
	// 画像のURL
	var graphic_url:String = "http://actionscript.web.officelive.com/wonderfl/bg001.jpg";

	// ローダー
	var loader_obj : Loader = new Loader();
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {

		// 読み込んだ画像を表示
		board.addChild(loader_obj);

		// 初期化へ
		init();
	}


	// 読み込み開始
	var url : URLRequest = new URLRequest(graphic_url);
	loader_obj.load(url);
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// ステージサイズ
	var w:uint;
	var h:uint;	
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		board.width = w;
		board.height = h;
	}
	ResizeFunc(null);
	
	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;

	// パラメータ
	var phase:Number = 0;		// 位相
	var amplitude:Number = 10;	// 振幅
	var cycle:Number = 100;		// 周期

	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		
		// 位相を変化
		phase += 0.01;
		if(phase > 1)	phase -= 1;

		// 位置
		param = data.position;
		param.value = [mouseX,mouseY];					

		// 位相
		param = data.phase;
		param.value = [phase];

		// 振幅
		param = data.amplitude;
		param.value = [amplitude];

		// 周期
		param = data.cycle;
		param.value = [cycle];

		// 適応
		board.filters = [filter];
	});
	
	// 表示
	var tf : TextField = new TextField();
	tf.x = 5;
	tf.y = 5;
	tf.width = 200;
	tf.height = 40;
	tf.border = true;
	tf.background = true;
	addChild(tf);
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		var str:String = "";
		str += "振幅:" + amplitude + "　(上下キーで変更)\n";
		str += "周期:" + cycle + "　(左右キーで変更)\n";
		
		tf.text = str;
	});
	
	
	// キー操作
	stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
	function KeyDown(event:KeyboardEvent):void{
		if(event.keyCode == Keyboard.UP)		amplitude -= 1;
		if(event.keyCode == Keyboard.DOWN)	amplitude += 1;
		if(event.keyCode == Keyboard.LEFT)	cycle -= 10;
		if(event.keyCode == Keyboard.RIGHT)	cycle += 10;
		
		if(amplitude < 0)	amplitude = 0;
		if(cycle < 0)	cycle = 0;
	};

}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:Array = [
		0xa5, 0x01, 0x00, 0x00, 0x00, 0xa4, 0x16, 0x00, 
		0x43, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x57, 0x61, 
		0x76, 0x65, 0x43, 0x69, 0x72, 0x63, 0x6c, 0x65, 
		0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0xa0, 0x0c, 
		0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 
		0x65, 0x00, 0x63, 0x75, 0x72, 0x76, 0x65, 0x20, 
		0x77, 0x61, 0x76, 0x65, 0x20, 0x63, 0x69, 0x72, 
		0x63, 0x6c, 0x65, 0x00, 0xa0, 0x0c, 0x76, 0x65, 
		0x6e, 0x64, 0x6f, 0x72, 0x00, 0x48, 0x61, 0x6b, 
		0x75, 0x68, 0x69, 0x6e, 0x00, 0xa0, 0x08, 0x76, 
		0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x00, 0x01, 
		0x00, 0xa0, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 
		0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x89, 
		0x7e, 0x8f, 0xf3, 0x82, 0xc9, 0x83, 0x54, 0x83, 
		0x43, 0x83, 0x93, 0x83, 0x4a, 0x81, 0x5b, 0x83, 
		0x75, 0x82, 0xc5, 0x94, 0x67, 0x91, 0xc5, 0x82, 
		0xc2, 0x83, 0x74, 0x83, 0x42, 0x83, 0x8b, 0x83, 
		0x5e, 0x00, 0xa1, 0x01, 0x02, 0x00, 0x00, 0x0c, 
		0x5f, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6f, 0x72, 
		0x64, 0x00, 0xa3, 0x00, 0x04, 0x73, 0x72, 0x63, 
		0x00, 0xa1, 0x02, 0x04, 0x01, 0x00, 0x0f, 0x64, 
		0x73, 0x74, 0x00, 0xa1, 0x01, 0x02, 0x00, 0x00, 
		0x03, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 
		0x6e, 0x00, 0xa2, 0x02, 0x64, 0x65, 0x66, 0x61, 
		0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0xa2, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 
		0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x89, 
		0x7e, 0x82, 0xcc, 0x92, 0x86, 0x90, 0x53, 0x8d, 
		0xc0, 0x95, 0x57, 0x00, 0xa1, 0x01, 0x01, 0x02, 
		0x00, 0x08, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x00, 
		0xa2, 0x01, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 
		0x75, 0x65, 0x00, 0x3f, 0x80, 0x00, 0x00, 0xa2, 
		0x01, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 
		0x56, 0x61, 0x6c, 0x75, 0x65, 0x00, 0x42, 0xc8, 
		0x00, 0x00, 0xa2, 0x0c, 0x64, 0x65, 0x73, 0x63, 
		0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00, 
		0x94, 0x67, 0x82, 0xaa, 0x88, 0xea, 0x8e, 0xfc, 
		0x82, 0xb7, 0x82, 0xe9, 0x92, 0xb7, 0x82, 0xb3, 
		0x00, 0xa1, 0x01, 0x01, 0x02, 0x00, 0x04, 0x70, 
		0x68, 0x61, 0x73, 0x65, 0x00, 0xa2, 0x01, 0x6d, 
		0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa2, 0x01, 0x6d, 0x61, 
		0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x00, 0x3f, 
		0x80, 0x00, 0x00, 0xa2, 0x01, 0x64, 0x65, 0x66, 
		0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 
		0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0x0c, 
		0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 
		0x69, 0x6f, 0x6e, 0x00, 0x94, 0x67, 0x82, 0xcc, 
		0x88, 0xca, 0x91, 0x8a, 0x00, 0xa1, 0x01, 0x01, 
		0x02, 0x00, 0x02, 0x61, 0x6d, 0x70, 0x6c, 0x69, 
		0x74, 0x75, 0x64, 0x65, 0x00, 0xa2, 0x01, 0x6d, 
		0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa2, 0x01, 0x64, 0x65, 
		0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 
		0x75, 0x65, 0x00, 0x41, 0x20, 0x00, 0x00, 0xa2, 
		0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 
		0x74, 0x69, 0x6f, 0x6e, 0x00, 0x94, 0x67, 0x82, 
		0xcc, 0x97, 0x68, 0x82, 0xea, 0x95, 0x9d, 0x00, 
		0x1d, 0x03, 0x00, 0xc1, 0x00, 0x00, 0x10, 0x00, 
		0x1d, 0x02, 0x00, 0x10, 0x00, 0x00, 0x80, 0x00, 
		0x02, 0x02, 0x00, 0x10, 0x03, 0x00, 0x00, 0x00, 
		0x1d, 0x03, 0x00, 0x20, 0x02, 0x00, 0xc0, 0x00, 
		0x1d, 0x02, 0x00, 0x10, 0x00, 0x00, 0xc0, 0x00, 
		0x02, 0x02, 0x00, 0x10, 0x03, 0x00, 0x40, 0x00, 
		0x1d, 0x03, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x1d, 0x04, 0x00, 0xc1, 0x03, 0x00, 0xb0, 0x00, 
		0x1d, 0x02, 0x00, 0x10, 0x04, 0x00, 0x40, 0x00, 
		0x06, 0x02, 0x00, 0x10, 0x04, 0x00, 0x00, 0x00, 
		0x1d, 0x03, 0x00, 0x20, 0x02, 0x00, 0xc0, 0x00, 
		0x1d, 0x02, 0x00, 0x10, 0x04, 0x00, 0x00, 0x00, 
		0x03, 0x02, 0x00, 0x10, 0x04, 0x00, 0x00, 0x00, 
		0x1d, 0x03, 0x00, 0x10, 0x04, 0x00, 0x40, 0x00, 
		0x03, 0x03, 0x00, 0x10, 0x04, 0x00, 0x40, 0x00, 
		0x1d, 0x04, 0x00, 0x20, 0x02, 0x00, 0xc0, 0x00, 
		0x01, 0x04, 0x00, 0x20, 0x03, 0x00, 0xc0, 0x00, 
		0x16, 0x02, 0x00, 0x10, 0x04, 0x00, 0x80, 0x00, 
		0x1d, 0x03, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x04, 0x02, 0x00, 0x10, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x02, 0x00, 0x10, 0x03, 0x00, 0xc0, 0x00, 
		0x1d, 0x04, 0x00, 0x20, 0x02, 0x00, 0xc0, 0x00, 
		0x1a, 0x02, 0x00, 0x10, 0x04, 0x00, 0x80, 0x00, 
		0x1d, 0x04, 0x00, 0x10, 0x04, 0x00, 0x80, 0x00, 
		0x02, 0x04, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x1d, 0x04, 0x00, 0x20, 0x04, 0x00, 0xc0, 0x00, 
		0x32, 0x02, 0x00, 0x10, 0x42, 0xb4, 0x00, 0x00, 
		0x01, 0x03, 0x00, 0x20, 0x02, 0x00, 0xc0, 0x00, 
		0x1d, 0x02, 0x00, 0x10, 0x04, 0x00, 0x80, 0x00, 
		0x01, 0x02, 0x00, 0x10, 0x02, 0x00, 0x40, 0x00, 
		0x32, 0x04, 0x00, 0x10, 0x43, 0xb4, 0x00, 0x00, 
		0x1d, 0x05, 0x00, 0x80, 0x02, 0x00, 0xc0, 0x00, 
		0x03, 0x05, 0x00, 0x80, 0x04, 0x00, 0xc0, 0x00, 
		0x32, 0x02, 0x00, 0x10, 0x3c, 0x8e, 0xfa, 0x35, 
		0x03, 0x02, 0x00, 0x10, 0x05, 0x00, 0x00, 0x00, 
		0x0c, 0x04, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x1d, 0x02, 0x00, 0x10, 0x04, 0x00, 0xc0, 0x00, 
		0x03, 0x02, 0x00, 0x10, 0x02, 0x00, 0x80, 0x00, 
		0x1d, 0x03, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x0d, 0x02, 0x00, 0x10, 0x03, 0x00, 0x80, 0x00, 
		0x1d, 0x04, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x03, 0x04, 0x00, 0x10, 0x03, 0x00, 0xc0, 0x00, 
		0x01, 0x03, 0x00, 0x80, 0x04, 0x00, 0xc0, 0x00, 
		0x0c, 0x02, 0x00, 0x10, 0x03, 0x00, 0x80, 0x00, 
		0x1d, 0x04, 0x00, 0x10, 0x02, 0x00, 0xc0, 0x00, 
		0x03, 0x04, 0x00, 0x10, 0x03, 0x00, 0xc0, 0x00, 
		0x01, 0x03, 0x00, 0x40, 0x04, 0x00, 0xc0, 0x00, 
		0x31, 0x05, 0x00, 0xf1, 0x03, 0x00, 0x10, 0x00, 
		0x1d, 0x01, 0x00, 0xf3, 0x05, 0x00, 0x1b, 0x00 
	];
	
	var b:ByteArray = new ByteArray();
	var i:uint = 0;
	var length:int = a.length;
	for(i=0;i<length;i++){
		b.writeByte(a[i]);
	}
	
	return b;
}

            
        }
    }
}


// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
	position		円の中心座標
	cycle			波が一周する長さ
	phase			波の位相 ( 0 ～ 1 までゆっくり変化させる)
	amplitude		波の揺れ幅
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel CircleWaveCircleFilter<
	namespace : "curve wave circle";
	vendor : "Hakuhin";
	version : 1;
	description : "円状にサインカーブで波打つフィルタ";
>{
	input image4 src;	// 入力イメージ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float2 position<
		defaultValue:float2(0.0 , 0.0);
		description : "円の中心座標";
	>;
	parameter float cycle<
		minValue:float(1.0);
		defaultValue:float(100.0);
		description : "波が一周する長さ";
	>;
	parameter float phase<
		minValue:float(0.0);
		maxValue:float(1.0);
		defaultValue:float(0);
		description : "波の位相";
	>;
	parameter float amplitude<
		minValue:float(0.0);
		defaultValue:float(10.0);
		description : "波の揺れ幅";
	>;


	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){
		// ピクセルの位置を取得
		float2 pos = outCoord();

		// 位置から中心座標までのベクトルを取得
		float2 v = float2(position.x - pos.x,position.y - pos.y);

		// ベクトルからラジアンを取得
		float rad = atan(v.y , v.x);

		// ベクトルから長さを求める
		float distance = sqrt((v.x * v.x) + (v.y * v.y));
		
		// 周期に丸める
		float d = distance / cycle;
		d = d - floor(d);
		
		// オフセットを取得して座標に加算
		rad += 90.0;
		distance = sin(radians((d + phase) * 360.0)) * amplitude;
		pos.x += cos(rad) * distance;
		pos.y += sin(rad) * distance;

		// ソースイメージからピクセルカラーを取得して出力
		dst = sampleLinear(src,pos);
	}
}
*/