/**
 * Copyright CoremindJP ( http://wonderfl.net/user/CoremindJP )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2ugA
 */

package {
    import flash.display.*;
    import flash.utils.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    public class Main extends Sprite
    {
        private const
            WINDOW_LENGTH:int         = 465,
            BMP_LENGTH:int            = 700,
            TIMER_COUNT:int           = 300,
            MAX_NOISE_OCTAVE:uint     = 4,
            WINDOW_HALF_LENGTH:Number = WINDOW_LENGTH * 0.5,
            EVAL:Number               = TIMER_COUNT * 0.5,
            BLUR_RATIO:Number         = 0.8;
            
        private var 
            blur:BlurFilter,
            bmpData:BitmapData,
            ct:ColorTransform,
            ctBMP:Bitmap,
            grayScale:Boolean,
            point:Point,
            rectangle:Rectangle,
            timer:Timer,
            transformRatio:Array;//0=r,1=g,2=b
        
        public function Main()
        {
            blur = new BlurFilter();
            bmpData = new BitmapData( BMP_LENGTH, BMP_LENGTH, true, 0x0 );
            ctBMP = new Bitmap( bmpData.clone(), "auto", true );
            grayScale= false;
            point = new Point();
            rectangle = new Rectangle( 0, 0, BMP_LENGTH, BMP_LENGTH );
            timer = new Timer( 20 , TIMER_COUNT );
            transformRatio = [];
            
            timer.addEventListener( TimerEvent.TIMER, timerHandler );
            timer.addEventListener( TimerEvent.TIMER_COMPLETE, timerCompleteHandler );
            
            addChild(ctBMP);
            this.x = WINDOW_HALF_LENGTH;
            this.y = WINDOW_HALF_LENGTH;
            ctBMP.x -= BMP_LENGTH * 0.5;
            ctBMP.y -= BMP_LENGTH * 0.5;
            
            timerCompleteHandler();
        }
        private function timerCompleteHandler( event:TimerEvent = null ):void
        {
            grayScale ?
                grayScale= false:
                grayScale= true;
            
            bmpData.perlinNoise(
                WINDOW_LENGTH,
                WINDOW_LENGTH,
                uint( Math.random() * MAX_NOISE_OCTAVE ) + 1,
                int( Math.random() * 10 ),
                true,
                false,
                7,
                grayScale);
                
            blur.blurX = EVAL * BLUR_RATIO;
            blur.blurY = EVAL * BLUR_RATIO;
            ct = new ColorTransform( 1,1,1,1, -127, -127, -127 );
            
            transformRatio[0] = generateColor();
            transformRatio[1] = generateColor();
            transformRatio[2] = generateColor();
            
            ctBMP.bitmapData.lock();
            ctBMP.bitmapData.copyPixels( bmpData, rectangle, point );
            ctBMP.bitmapData.unlock();
            ctBMP.bitmapData.colorTransform( rectangle, ct );
                
            timer.reset();
            timer.start();
        }
        private function timerHandler( event:TimerEvent ):void
        {
            if( timer.currentCount <= EVAL )
            {
                update( 1 );
                //this.rotation += ( EVAL - timer.currentCount );
            }
            else
            {
                update(-1 );
                //this.rotation += ( timer.currentCount - EVAL );
            }
            ctBMP.bitmapData.applyFilter(
                bmpData,
                rectangle,
                point,
                blur );
            ctBMP.bitmapData.colorTransform( rectangle, ct );
        }
        private function update( value:int ):void
        {
            blur.blurX += -1 * value * BLUR_RATIO;
            blur.blurY += -1 * value * BLUR_RATIO;
            ct.redOffset   += transformRatio[0] * value;
            ct.greenOffset += transformRatio[1] * value;
            ct.blueOffset  += transformRatio[2] * value;
        }
        private function generateColor():Number
        {
            var _resultValue:Number = Math.random() * 300;
            if( 0 < _resultValue && _resultValue < 100 )
                _resultValue += 100;
            if( _resultValue < 0 )
                _resultValue += 255;
            return _resultValue / EVAL;
        }
    }
}