/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2tvOP
 */

package

{

    import flash.display.Sprite;

    import flash.events.Event;

    

    /**

     * ...

     * @author umhr

     */

    public class WonderflMain extends Sprite 

    {

        

        public function WonderflMain() 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            // entry point

            stage.scaleMode = "noScale";

            stage.align = "TL";

            

            addChild(new Canvas());

        }

        

    }

    

}



    import com.bit101.components.HSlider;

    import com.bit101.components.Label;

    import com.bit101.components.PushButton;

    import flash.display.BitmapData;

    import flash.display.PNGEncoderOptions;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.net.FileReference;

    import flash.utils.ByteArray;

    /**

     * ...

     * @author umhr

     */

     class Canvas extends Sprite 

    {

        

        

        private var _ichimatsuCanvas:Sprite = new Sprite();

        private var _iconCanvas:Sprite = new Sprite();

        private var _uiCanvas:Sprite = new Sprite();

        private var _hSlider:HSlider;

        private var _ratioNum:Label;

        private var _save:PushButton;

        

        public function Canvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            addChild(_ichimatsuCanvas);

            addChild(_iconCanvas);

            addUI();

            //onChange(null);

            

            stage.addEventListener(Event.RESIZE, stage_resize);

            stage_resize(null);

        }

        

        private function stage_resize(e:Event):void 

        {

            _ichimatsuCanvas.removeChildren();

            _ichimatsuCanvas.addChild(new Ichimatsu(stage.stageWidth, stage.stageHeight));

            onChange(null);

            

            _uiCanvas.x = (stage.stageWidth - 440) * 0.5;

            _uiCanvas.y = stage.stageHeight-60;

        }

        private function addUI():void {

            

            _uiCanvas.graphics.beginFill(0xCCCCCC, 0.7);

            _uiCanvas.graphics.drawRoundRect(0, 0, 440, 55, 8, 8);

            _uiCanvas.graphics.endFill();

            addChild(_uiCanvas);

            

            _ratioNum = new Label(_uiCanvas, 6, 4);

            

            _hSlider = new HSlider(_uiCanvas, 0, 0, onChange);

            _hSlider.value = 1;

            _hSlider.minimum = 0;

            _hSlider.maximum = 5;

            _hSlider.width = 330;

            _hSlider.x = 6;

            _hSlider.y = 20;

            

            var mark1:Sprite = new Sprite();

            mark1.graphics.beginFill(0x666666);

            mark1.graphics.moveTo(0, 0);

            mark1.graphics.lineTo(6, 10);

            mark1.graphics.lineTo(-6, 10);

            mark1.graphics.endFill();

            mark1.x = _hSlider.x + ((_hSlider.width - 10) / 5) * 1 + 5;

            mark1.y = _hSlider.y + 14;

            mark1.addEventListener(MouseEvent.CLICK, function():void { _hSlider.value = 1; onChange(null) } );

            new Label(_uiCanvas, mark1.x - 16, mark1.y + 6,"Golden");

            _uiCanvas.addChild(mark1);

            

            var mark2:Sprite = new Sprite();

            mark2.graphics.beginFill(0x666666);

            mark2.graphics.moveTo(0, 0);

            mark2.graphics.lineTo(6, 10);

            mark2.graphics.lineTo(-6, 10);

            mark2.graphics.endFill();

            mark2.x = _hSlider.x +((_hSlider.width - 10) / 5) * 2 + 5;

            mark2.y = _hSlider.y + 14;

            mark2.addEventListener(MouseEvent.CLICK, function():void { _hSlider.value = 2; onChange(null) } );

            new Label(_uiCanvas, mark2.x - 16, mark2.y + 6, "Silver");

            _uiCanvas.addChild(mark2);

            

            var mark3:Sprite = new Sprite();

            mark3.graphics.beginFill(0x666666);

            mark3.graphics.moveTo(0, 0);

            mark3.graphics.lineTo(6, 10);

            mark3.graphics.lineTo(-6, 10);

            mark3.graphics.endFill();

            mark3.x = _hSlider.x + ((_hSlider.width - 10) / 5) * 3 + 5;

            mark3.y = _hSlider.y + 14;

            mark3.addEventListener(MouseEvent.CLICK, function():void { _hSlider.value = 3; onChange(null) } );

            new Label(_uiCanvas, mark3.x - 16, mark3.y + 6, "Bronze");

            _uiCanvas.addChild(mark3);

            

            _save = new PushButton(_uiCanvas, 350, 16, "Save", onSave);

            _save.width = 84;

        }

        

        private function onSave(event:Event):void 

        {

            var bitmapData:BitmapData = new BitmapData(1024, 1024);

            var ratio:Number = _hSlider.value;

            bitmapData.draw(IOSIconCreator.getShape(1024, ratio));

            var byteArray:ByteArray = bitmapData.encode(bitmapData.rect, new PNGEncoderOptions());

            var fileReference:FileReference = new FileReference();

            fileReference.save(byteArray,"template.png");

        }

        

        private function onChange(event:Event):void 

        {

            var size:int = Math.min(stage.stageWidth - 20, stage.stageHeight - 70);

            

            var ratio:Number = _hSlider.value;

            _iconCanvas.removeChildren();

            _iconCanvas.addChild(IOSIconCreator.getShape(size, ratio));

            _iconCanvas.x = (stage.stageWidth - size) * 0.5;

            _iconCanvas.y = (stage.stageHeight - size-60) * 0.5;

            _ratioNum.text = "Ratio:" + IOSIconCreator.metallicRatio(ratio).toFixed(4);

        }

    }

    



    import flash.display.BitmapData;

    import flash.display.Shape;

    import flash.geom.Matrix;

    

    /**

     * ...

     * @author umhr

     */

     class Ichimatsu extends Shape 

    {

        

        public function Ichimatsu(width:int, height:int) 

        {

            drawIchimatsu(width, height);

        }

        public function drawIchimatsu(width:int, height:int):void {

            if (width == this.width && height == this.height) {

                return;

            }

            

            var bitmapData:BitmapData = new BitmapData(2, 2, false);

            bitmapData.setPixel(0, 0, 0xCCCCCC);

            bitmapData.setPixel(1, 1, 0xCCCCCC);

            

            this.graphics.clear();

            this.graphics.beginBitmapFill(bitmapData, new Matrix(8, 0, 0, 8));

            this.graphics.drawRect(0, 0, width, height);

            this.graphics.endFill();

            bitmapData = null;

        }

    }



    import flash.display.Shape;

    /**

     * ...

     * @author umhr

     */

     class IOSIconCreator  

    {

        

        static public var GOLDEN_RATIO:int = 1;

        static public var SILVER_RATIO:int = 2;

        static public var BRONZE_RATIO:int = 3;

        public function IOSIconCreator() 

        {

        }

        

        static public function getShape(w:int, ratio:Number = 1):Shape 

        {

            w -= 1;

            var h:int = w;

            var mRatio:Number = 1 / metallicRatio(ratio);

            

            var shape:Shape = new Shape();

            shape.graphics.lineStyle(0, 0x000000, 0.3);

            shape.graphics.beginFill(0xFFFFFF);

            shape.graphics.drawRect(0, 0, w, h);

            shape.graphics.endFill();

            

            shape.graphics.lineTo(w, h);

            shape.graphics.moveTo(w, 0);

            shape.graphics.lineTo(0, h);

            shape.graphics.moveTo(w * 0.5, 0);

            shape.graphics.lineTo(w * 0.50, h);

            shape.graphics.moveTo(0, h * 0.5);

            shape.graphics.lineTo(w, h * 0.50);

            

            var r:Number = Math.sqrt(w * 0.5 * w * 0.5 + h * 0.5 * h * 0.5) * mRatio;

            

            shape.graphics.lineStyle(0, 0x000000, 0.3);

            shape.graphics.moveTo(w * 0.5 + r, 0);

            shape.graphics.lineTo(w * 0.5 + r, h);

            shape.graphics.moveTo(w * 0.5 - r, 0);

            shape.graphics.lineTo(w * 0.5 - r, h);

            

            shape.graphics.moveTo(0, h * 0.5 + r);

            shape.graphics.lineTo(w, h * 0.5 + r);

            shape.graphics.moveTo(0, h * 0.5 - r);

            shape.graphics.lineTo(w, h * 0.5 - r);

            

            shape.graphics.lineStyle(0, 0x000000, 0.3);

            shape.graphics.drawCircle(w * 0.5, h * 0.5, r);

            

            shape.graphics.lineStyle(0, 0x000000, 0.3);

            r = w * 0.5 * (1 - mRatio)

            shape.graphics.moveTo(w * 0.5 + r, 0);

            shape.graphics.lineTo(w * 0.5 + r, h);

            shape.graphics.moveTo(w * 0.5 - r, 0);

            shape.graphics.lineTo(w * 0.5 - r, h);

            shape.graphics.moveTo(0, h * 0.5 + r);

            shape.graphics.lineTo(w, h * 0.5 + r);

            shape.graphics.moveTo(0, h * 0.5 - r);

            shape.graphics.lineTo(w, h * 0.5 - r);

            

            // 内接円

            //shape.graphics.lineStyle(0, 0x00FF00, 1);

            shape.graphics.drawCircle(w * 0.5, h * 0.5, r);

            r = Math.sqrt(r * r + r * r);

            // 外接円

            //shape.graphics.lineStyle(0, 0x0000FF, 1);

            shape.graphics.drawCircle(w * 0.5, h * 0.5, r);

            

            

            // frame

            var d:Number = 0.25;// 0.21;

            var dr:Number = 0.1;// 0.1;

            shape.graphics.moveTo(w * 0.5, 0);

            shape.graphics.lineTo(w * (1 - d), 0);

            shape.graphics.cubicCurveTo(w * (1-dr), 0, w, h * dr, w, h * d);

            shape.graphics.lineTo(w, h * (1 - d));

            shape.graphics.cubicCurveTo(w, h * (1-dr), w * (1-dr), h, w * (1 - d), h);

            shape.graphics.lineTo(w * d, h);

            shape.graphics.cubicCurveTo(w * dr, h, 0, h * (1-dr), 0, h * (1 - d));

            shape.graphics.lineTo(0, h * d);

            shape.graphics.cubicCurveTo(0, h * dr, w * dr, 0, w * d, 0);

            shape.graphics.lineTo(w * 0.5, 0);

            

            return shape;

        }

        

        static public function metallicRatio(num:Number):Number {

            return (num + Math.sqrt(num * num + 4)) * 0.5;

        }

    }

    



